<?php
	namespace App\Http\Controllers\API;
	use Illuminate\Http\Request;
	use App\Http\Controllers\Controller;
	use DB;
	use Helper;
	use Mtownsend\XmlToArray\XmlToArray;
	
	class RechargeWebService extends Controller
	{
		//
		private $STATUS = "failed";
		private $ERRMSG = "Invalid Operation";
		private $ERRCODE = "error";
		private $isError = FALSE;
		private $record_per_page =10;
        private $userData = '';
		
		function valid_phone_number($str)
		{
			$regex = "/^[0-9]+$/";
			if(preg_match($regex,$str))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}
		function valid_decimal_amount($amt)
		{
			$regex = "/^(?:d*.d{1,2}|d+)$/";
			if(preg_match($regex,$amt))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}
		//private $apiToken;
		/**
			* Method name	: recharge
			* @description 	: Used to Recharge Prepaid,DTH,Datacard 
			* @param		: Request data  
			* @return		: Get Recharge data array with response message
		*/
		public function apitransaction(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$token = $request->header('Authorization');
			}
			if($_SERVER['REQUEST_METHOD']=="GET")
			{	
					$token = $request->get('api_token');
				$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";	$auto_response="";
			
				$res_format="json";$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="remark";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";	$circlecode="";$opcircle_id ="";$circleid=0;
				$status1="PENDING";$status2=2;$method='GET';$mbal=0.00;$auto_switch='false';$hit_count=1;$auto_status='1';$next_api='';
				$mobileno=$request->get('mobile');
				$amount  =$request->get('amount');
				$opcode  =$request->get('opt');
				$agentid =$request->get('agentid');
				$format  =$request->get('fmt');
				$ip=$request->server('REMOTE_ADDR');
				$fullurl=$request->fullUrl();
				$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('$token','$agentid','$ip','$fullurl','',1)");		
				$incmghit_record_id=DB::select("SELECT LAST_INSERT_ID() As id");	
				
			}
			if($token=='')
			{
				$ERRMSG = "Api Token should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="error";
				$userData ='';
			}
			else
			{
				$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
				if($login_detail)
				{    
					if($login_detail[0]->IPAddress!="192.168.0.1")
						$ipvalidate=DB::select("SELECT * FROM `tr04_login` WHERE `tr04_ip`='".$ip."' AND m11_user_id=".$login_detail[0]->RegId." LIMIT 1");
					else
						$ipvalidate=DB::select("SELECT * FROM `tr04_login` WHERE  m11_user_id=".$login_detail[0]->RegId." LIMIT 1");
					if(!$ipvalidate)
					{
						$ERRMSG = "Server IP should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$this->isError= FALSE;
						$ERRCODE="success";
						$userData=$mobileno;
					}
				}
				else
				{
					$ERRMSG = "User not found.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				if($this->isError== FALSE)
				{
					if($request->get('mobile')=='')
					{
						$ERRMSG = "Mobile no should be valid.";
						$this->isError= TRUE;
						$ERRCODE="success";
						$userData ='';
					}
					else if(trim($amount) == '' || trim(floatval($amount))<=0.00)
					{
						$ERRMSG = "Amount should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else if(trim($opcode) == '')
					{
						$ERRMSG = "Operator Code should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else if(trim($agentid) == '')
					{
						$ERRMSG = "Agent id should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else if(trim($format) == '')
					{
						$ERRMSG = "Format should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else
					{
						$circlecode=2;
						/*$url='http://planapi.in/api/Mobile/OperatorFetchNew?ApiUserID=3889&ApiPassword=123456&Mobileno='.$request->get('mobile').'';
						$host = '';    
						$options = array(
							CURLOPT_SSL_VERIFYHOST => 0,
							CURLOPT_SSL_VERIFYPEER => 0
							);
							$defaults = array(
							CURLOPT_URL => $url,
							CURLOPT_HEADER => 0,
							CURLOPT_RETURNTRANSFER => TRUE,
							CURLOPT_TIMEOUT =>60
							);

							$ch = curl_init();
							curl_setopt_array($ch, ($options + $defaults));
							$result = curl_exec($ch);
							$json=json_decode($result);
							if(!$result)
							{
								//$result=trigger_error(curl_error($ch));
								if (curl_errno($ch)) {
                                     $error_msg = curl_error($ch);
                                    }
								curl_close($ch);
										$ERRMSG = "DETAILS NOT FIND.";
										$ERRCODE="error";
									return response()->json([
											'ERROR'=>$ERRCODE,
											'MSG' =>$ERRMSG 
											]);
							}
							else
							{
								curl_close($ch);
								if($json->Operator!=''){
										$opcode	=$json->Operator;
										$circlecode=$json->CircleCode;
								}
							}*/
						
						$mobileno=$request->input('mobile');
						$amount  =$request->input('amount');
						$opcode  =$request->input('opt');
						if($circlecode!='' && $circlecode!=0){
						$opcircle_id = DB::select("SELECT IFNULL(`CIRCLE_ID`,'') as CIRCLE_ID FROM `op_circle` WHERE `CIRCLE_CODE`=".$circlecode." LIMIT 1");
						$circleid=$opcircle_id[0]->CIRCLE_ID;
						}
						/*else
						{
						    $ERRMSG = "Operator Circle should be valid.";
    						$this->isError= TRUE;
    						$ERRCODE="error";
                			$response_inc= response()->json([
                			'ERROR'=>$ERRCODE,
                			'STATUS'=>trim('FAILED'),
                			'MSG' =>$ERRMSG 
                			]);
                				$arr = array(
                							'tr09_apihit_response' =>trim($response_inc)
                						);
                					DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
                						return $response_inc;
						}*/
						$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_code`='".$opcode."' AND `m04_tc_brand_status`='Active' LIMIT 1");
						$brand_id=$opcode_id[0]->BRAND_ID;
						$service_id=$opcode_id[0]->SERVICE_ID;
						$ERRMSG = "D.";
						$this->isError= FALSE;
						$ERRCODE="success";
						$userData =$opcode_id[0]->BRAND_ID.'_'.$service_id;
					}
				}
				if($this->isError== FALSE)
				{
					
					$rechreq=array(
					'proc'=>'1',
					'user_id'=>$login_detail[0]->RegId,
					'mobile'=>$mobileno,
					'operator'=>$brand_id,
					'amount'=>$amount,
					'requesttype'=>3,
					'servicetype'=>$service_id,
					'agentid'=>trim($request->get('agentid')),
					'format'=>$circleid,
					'timelimit'=>(config('INTERVAL_RECHARGE')*60),
					'defaultstatus'=>'2'
					);	
					$rechreq_report=DB::select('CALL dorecharge(				
					:proc,
					:user_id,
					:mobile,
					:operator,
					:amount,
					:requesttype,
					:servicetype,
					:agentid,
					:format,
					:timelimit,
					:defaultstatus,
					@msg,
					@msg2
					)',$rechreq);
					
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					
					if($DB_ERROR[0]->ERROR!="Error")
					{
						$transid=$DB_ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$next_api=$row->next_api;
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						$apiid=$row->apiid;
						$param1=$service_id;
						$res_format=$row->RES_FORMAT;$status=$row->RES_PARAM;$opid=$row->LIVEID;$rbid=$row->APITXNID;
                        $res_success=$row->SUCCESS_VALUE;$res_fail=$row->FAILED_VALUE;$res_pending=$row->PENDING_VALUE;$mbal=$row->MAINWALLET;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($userid!="")
						$url=str_replace('@userid',$userid,$url);
						if($password!="")
						$url=str_replace('@password',$password,$url);
						if($mobileno!="")
						$url=str_replace('@account',$mobileno,$url);
						if($amount!="")
						$url=str_replace('@amount',$amount,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						if($DB_ERROR[0]->ERROR!="Error")
						$url=str_replace('@refrence',$DB_ERRMSG[0]->ERR_MSG,$url);
						if($format!="")
						$url=str_replace('@format',$format,$url);
						if($param1!="")
						$url=str_replace('@param1',$param1,$url);
						if($param2!="")
						$url=str_replace('@param2',$param2,$url);
						//echo $url.'</br>';
						//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
						$response=Helper::_curl_execute('GET',$url,'');
						$response=str_replace("\xEF\xBB\xBF",'',$response); 
						$outgoinghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				       VALUES ('$token','$transid ','$ip','$url','$response',2)");	
                        $res_rbid=$agentid;
						if($res_format=="string")
						{
									$regex0 = '/[A-Z][^\\;]*(SUCCESS)[^\\;]*/';
									$regex1 = '/[A-Z][^\\;]*(Success)[^\\;]*/';
									$regexS1= '/[A-Z][^\\;]*(Succesful)[^\\;]*/';
									$regexS2= '/[A-Z][^\\;]*(SUCCESFUL)[^\\;]*/';
									$regex2 = '/[A-Z][^\\;]*(Failed)[^\\;]*/';
									$regex3 = '/[A-Z][^\\;]*(FAILED)[^\\;]*/';
									$regex4 = '/[A-Z][^\\;]*(FAIL)[^\\;]*/';
									$regex5 = '/[A-Z][^\\;]*(Accepted)[^\\;]*/';
									$regex6 = '/[A-Z][^\\;]*(Pending)[^\\;]*/';
									$status1="PENDING";
									$status2=2;
									$ERRCODE="warning";
									if(preg_match_all($regex5, $response, $match) || preg_match_all($regex6, $response, $match)) 
									{
										$start1 = "System id=";
										$end1 = "#";
										$res_rbid===Helper::getBetween($response,$start1,$end1);
										$res_status="PENDING";
										$status2=2;
										$margin=$amt;
										$ERRCODE="warning";
									}
									if(preg_match_all($regex0, $response, $match) || preg_match_all($regex1, $response, $match)) 
									{
										$start1 = "TXID ";
										$end1 = " ";
										$operid=Helper::getBetween($response,$start1,$end1);
										$start2 = "System id=";
										$end2 = "#";
										$res_rbid===Helper::getBetween($response,$start2,$end2);
										$res_status="SUCCESS";
										$status2=1;
										$margin=$amt;
										$ERRCODE="success";
									}
									if (preg_match_all($regex2, $response, $match) || preg_match_all($regex3, $response, $match) || preg_match_all($regex4, $response, $match)) 
									{
										$res_status="FAILED";
										$status2=4;
										if(preg_match_all($regex2, $response, $match) || preg_match_all($regex3, $response, $match))
										{
											$start1 = "Failed";
											$end1 = "BAL";
											$operid=Helper::getBetween($response,$start1,$end1);
										}
										if(preg_match_all($regex2, $response, $match))
										{
											$start1 = "Reson=";
											$end1 = "Bal";
											$operid=Helper::getBetween($response,$start1,$end1);
										}
										$ERRCODE="warning";
									}
						}
						if($res_format=="JSON")
						{
							$json=json_decode($response,true);
							if($status!="")
							{
								if(!empty($json[$status]))
								$res_status=$json[$status];
								else
								{
								$is_error=$json['error'];
								if($is_error=='true')
								$res_status="FAILED";
								}
								if($res_status==$res_fail || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						$auto_switch='true';
							}
							if($opid!='')
							{
							    if(!empty($json[$opid]))
								$res_opid=$json[$opid];
							}
							if($rbid!='')
							{
							    if(!empty($json[$rbid]))
								$res_rbid=$json[$rbid];
							}
							if($msg!='' && $msg!="remark")
							{
							    if(!empty($json[$msg]))
								$res_msg=$json[$msg];
							}
						}
						if($res_format=="xml" || $res_format=="XML" )
						{
							$array = XmlToArray::convert($response);
							$json = json_encode($array);
							$xmlarray = json_decode($json,TRUE);
							if($status!="")
							{
								 if(!empty($xmlarray[$status]))
								$res_status=$xmlarray[$status];
								
							}
							if($opid!='' && $res_status=="SUCCESS" )
							{
							    if(!empty($xmlarray[$opid]))
								$res_opid=$xmlarray[$opid];
							}
							if($rbid!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$rbid]))
								$res_rbid=$xmlarray[$rbid];
						
							}
							if($msg!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$msg]))
								$res_msg=$xmlarray[$msg];
								
							}
							if($res_status=="FAILED" || $res_status=="REFUND") 
							{
							    $auto_switch='true';
							}
						}
						
						 $arr = array(
						    'tr05_api_txnid'=>$res_rbid,
							'tr05_remarks' =>trim($response)
						);
					DB::table('tr05_recharge_detail')->where('tr05_trans_id',$transid)->update($arr);
				
			        	if($auto_switch=='true' && $next_api!=0)
						{
							do{ 
								$auto_response=$this->auto_switch_api($login_detail[0]->RegId,$transid,$brand_id,$hit_count);
								if($auto_response=='')
								$hit_count=$hit_count+1;
								else
								break;
							}while (($status=='' || $hit_count<6));
							    if($auto_response!='')
								{
								    $arr = array(
							'tr09_apihit_response' =>trim($auto_response)
						);
				     	DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
									return $auto_response;
								}
								
						}
						else
						{
						    $auto_switch='false';$auto_status='1';
						}
					
						if($auto_switch=='false' && $auto_status!='')
						{
        						if($res_status==$res_success || $res_status=="SUCCESS" || $res_status=="Success" )
        						{
        							$status1="SUCCESS";
        							$status2=1;
        						}
        						if($res_status==$res_pending || $res_status=="PENDING" || $res_status=="Pending")
        						{
        							$status1="PENDING";
        							$status2=2;
        						}
        						if($res_status==$res_fail || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						{
        							$status1="FAILED";
        							$status2=4;
        						}
        						$respreport=array(
        						'proc'=>1,
        						'userid'=>$login_detail[0]->RegId,
        						'account'=>$mobileno,
        						'transid'=>$transid,
        						'liveid'=>$res_opid,
        						'amt'=>$amount,
        						'recstatus'=>$status2,
        						'descrip'=>1							
        						);
        						$resquery = DB::select('CALL recharge_statusupdate(
        						:proc,
        						:userid,
        						:account,
        						:transid,
        						:liveid,
        						:amt,
        						:recstatus,
        						:descrip,
        						@resmsg)',$respreport);
        						$ERRMSG = "RECHARGE IS ".$status1;
        						$this->isError= FALSE;
        						$ERRCODE="success";
        						$userData =$DB_ERRMSG[0]->ERR_MSG;
        					   // $this->send_sms('9919111099', $res_status);
						}
						 $response_inc=response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG ,
						'STATUS'=>trim($status1),
						'MOBILE'=>trim($mobileno),
						'AMOUNT'=>trim($amount),
						'AGENTID'=>trim($agentid),
						'OPID'=>trim($res_opid),
						'TID'=>trim($DB_ERRMSG[0]->ERR_MSG),
						'BAL'=>trim(floatval($mbal))
						]);
							 $arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
					DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
						return $response_inc;			
					}
					else
					{	
						$ERRMSG = $DB_ERRMSG[0]->ERR_MSG;
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';	
						$response_inc= response()->json([
						'ERROR'=>$ERRCODE,
						'STATUS'=>trim('FAILED'),
						'MSG' =>$ERRMSG 
						]);
						$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
					DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
						return $response_inc;	
					}
				}
			}
			$response_inc= response()->json([
			'ERROR'=>$ERRCODE,
			'STATUS'=>trim('FAILED'),
			'MSG' =>$ERRMSG 
			]);
				$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
					DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
						return $response_inc;	
		}
	/**
			* Method name	: Status_check
			* @description 	: Used to Status_check Prepaid,DTH,Datacard 
			* @param		: Request data  
			* @return		: Get status_check data array with response message
		*/
		public function status_check(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$token = $request->header('Authorization');
			}
			if($_SERVER['REQUEST_METHOD']=="GET")
			{	
				$token = $request->get('api_token');
				$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;
				$transid =$request->get('transid');
				$ip=$request->server('REMOTE_ADDR');
				$fullurl=$request->fullUrl();
				$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('$token','$transid','$ip','$fullurl','',1)");	
				$incmghit_record_id=DB::select("SELECT LAST_INSERT_ID() As id");
			}
			if($token=='')
			{
				$ERRMSG = "Api Token should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="error";
				$userData ='';
			}
			else
			{
				$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
				if($login_detail)
				{
					if($login_detail[0]->IPAddress!="192.168.0.1")
						$ipvalidate=DB::select("SELECT * FROM `tr04_login` WHERE `tr04_ip`='".$ip."' AND m11_user_id=".$login_detail[0]->RegId." LIMIT 1");
					else
						$ipvalidate=DB::select("SELECT * FROM `tr04_login` WHERE  m11_user_id=".$login_detail[0]->RegId." LIMIT 1");
					if(!$ipvalidate)
					{
						$ERRMSG = "Server IP should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$this->isError= FALSE;
						$ERRCODE="success";
						$userData=$login_detail[0]->MemberContactNo;
					}
				}
				else
				{
					$ERRMSG = "User not found.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				if($this->isError== FALSE)
				{
				    if(trim($transid) == '')
					{
						$ERRMSG = "Transaction id should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else
					{
						$ERRMSG = "Transaction Id";
						$this->isError= FALSE;
						$ERRCODE="success";
						$userData ='';
					}
				}
				if($this->isError== FALSE)
				{
					$recereport=array
					(
						'proc'=>3,
						'account'=>'',
						'transid'=>trim($transid),
						'userid'=>$login_detail[0]->RegId,
						'fromdate'=>'1970-01-01',
						'todate'=>'1970-01-01',
						'noofrecords'=>1,
						'recstatus'=>-1,
						'descrip'=>'1'
					);
					$rec_report = DB::select('CALL recharge_report(
					 :proc,
					 :account,
					 :transid, 
					 :userid,
					 :fromdate,
					 :todate,
					 :noofrecords,
					 :recstatus,
					 :descrip,
					 @msg
					 )',$recereport);
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					if($rec_report)
					{
						$ERRMSG = "RECHARGE IS ".$rec_report[0]->Status." TRANSACTION ID- ".$rec_report[0]->Transactionid;
						$this->isError= FALSE;
						$ERRCODE="success";
						$userData =$DB_ERRMSG[0]->ERR_MSG;
						
					    $response_inc=response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG ,
						'STATUS'=>trim($rec_report[0]->Status),
						'MOBILE'=>trim($rec_report[0]->Account),
						'AMOUNT'=>trim($rec_report[0]->Amount),
						'AGENTID'=>trim($rec_report[0]->APITransactionid),
						'OPID'=>trim($rec_report[0]->LiveId),
						'TID'=>trim($rec_report[0]->Transactionid),
						'BAL'=>trim(floatval(0.00))
						]);
						$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
				    	DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
						return $response_inc;
					}
					else
					{	
						if($DB_ERRMSG[0]->ERR_MSG==0)
						$ERRMSG = "TRANSACTION ID IS NOT VALID.";
						else
						$ERRMSG =$DB_ERRMSG[0]->ERR_MSG;
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';	
						$response_inc= response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
						$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
				    	DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
						return $response_inc;
					}
				}
			}
			return response()->json([
			'ERROR'=>$ERRCODE,
			'MSG' =>$ERRMSG 
			]);
			
		}
		
		/**
			* Method name	: Balance Check
			* @description 	: Used to Balance check Prepaid,DTH,Datacard 
			* @param		: Request data  
			* @return		: Get balance_check data array with response message
		*/
		public function balance_check(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$token = $request->header('Authorization');
			}
			if($_SERVER['REQUEST_METHOD']=="GET")
			{	
				$token = $request->get('api_token');
				$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;
				$transid =$request->get('transid');
				$ip=$request->server('REMOTE_ADDR');
				$fullurl=$request->fullUrl();
				$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('$token','$transid','$ip','$fullurl','',1)");	
				$incmghit_record_id=DB::select("SELECT LAST_INSERT_ID() As id");
			}
			if($token=='')
			{
				$ERRMSG = "Api Token should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="error";
				$userData ='';
			}
			else
			{
				$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
				if($login_detail)
				{
					if($login_detail[0]->IPAddress!="192.168.0.1")
						$ipvalidate=DB::select("SELECT * FROM `tr04_login` WHERE `tr04_ip`='".$ip."' AND m11_user_id=".$login_detail[0]->RegId." LIMIT 1");
					else
						$ipvalidate=DB::select("SELECT * FROM `tr04_login` WHERE  m11_user_id=".$login_detail[0]->RegId." LIMIT 1");
					if(!$ipvalidate)
					{
						$ERRMSG = "Server IP should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else
					{
						$ERRMSG = "CURRENT BALANCE";
						$this->isError= FALSE;
						$ERRCODE="success";
						$response_inc=response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG ,
						'RECHARGE_BAL'=>trim(floatval($login_detail[0]->RECHARGE_BAL)),
						'UTILITY_BAL'=>trim(floatval($login_detail[0]->UTILITY_BAL))
						]);
							 $arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
				    	DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
						return $response_inc;
					}
				}
				else
				{
					$ERRMSG = "User not found.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$response_inc=response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
						$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
				    	DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
						return $response_inc;
				}
			}
			return response()->json([
			'ERROR'=>$ERRCODE,
			'MSG' =>$ERRMSG 
			]);
			
		}
		public function send_sms($mob,$msg)
    	{
		$url = Config('SMS_SEND_URL');
		$params = array(
			'user'=>Config('SMS_AUTH'),
			'password'=>Config('SMS_PWD'),
			'msisdn'=>$mob,
			'sid'=>Config('SMS_SENDERID'),
			'msg'=>$msg, 	 	 
			'fl'=>0,	 	 	 
			'gwid'=>2	 	 
		);
     	Helper::_curl_execute('GET',$url,$params);
    	}
    	
    	
    	
    	/**
			* Method name	: Auto Switch
			* @description 	: Used to Status_check Prepaid,DTH,Datacard 
			* @param		: Request data  
			* @return		: Get status_check data array with response message
		*/
		public function auto_switch_api($user_id,$transid,$brand_id,$hit_count)
		{
				$auto_switch='true';
				$ip='';$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$res_format="json";$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="remark";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;$method='GET';$status3="";$next_api='';
			        $rechreq=array(
					'proc'=>'6',
					'user_id'=>$user_id,
					'mobile'=>$transid,
					'operator'=>$brand_id,
					'amount'=>10,
					'requesttype'=>$hit_count,
					'servicetype'=>1,
					'agentid'=>1,
					'format'=>1,
					'timelimit'=>900,
					'defaultstatus'=>2
					);	
					$rechreq_report=DB::select('CALL dorecharge(				
					:proc,
					:user_id,
					:mobile,
					:operator,
					:amount,
					:requesttype,
					:servicetype,
					:agentid,
					:format,
					:timelimit,
					:defaultstatus,
					@msg,
					@msg2
					)',$rechreq);
					
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					//dd($rechreq,$rechreq_report,$DB_ERROR[0]->ERROR);
					if($DB_ERROR[0]->ERROR!="Error")
					{
						//$transid=$DB_ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$next_api=$row->next_api;
						$user_id=$row->user_id;
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						$apiid=$row->apiid;
						$mobileno=$row->account;
						$amount=$row->amount;
						$agentid=$row->agentid;
						$BAL=$row->MAINWALLET;
						$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_id`=".$brand_id." AND `m04_tc_brand_status`='Active' LIMIT 1");
						$service_id=$opcode_id[0]->SERVICE_ID;
						$param1=$service_id;
						$res_format=$row->RES_FORMAT;$status=$row->RES_PARAM;$opid=$row->LIVEID;$rbid=$row->APITXNID;
						$res_success=$row->SUCCESS_VALUE;$res_fail=$row->FAILED_VALUE;$res_pending=$row->PENDING_VALUE;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($userid!="")
						$url=str_replace('@userid',$userid,$url);
						if($password!="")
						$url=str_replace('@password',$password,$url);
						if($mobileno!="")
						$url=str_replace('@account',$mobileno,$url);
						if($amount!="")
						$url=str_replace('@amount',$amount,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						if($DB_ERROR[0]->ERROR!="Error")
						$url=str_replace('@refrence',$DB_ERRMSG[0]->ERR_MSG,$url);
						if($format!="")
						$url=str_replace('@format',$format,$url);
						if($param1!="")
						$url=str_replace('@param1',$param1,$url);
						if($param2!="")
						$url=str_replace('@param2',$param2,$url);
						//echo $url.'</br>';
						//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
						$response=Helper::_curl_execute('GET',$url,'');
						$response=str_replace("\xEF\xBB\xBF",'',$response); 
						//echo $response;
						//echo $hit_count;	
						  $arr = array(
							'tr05_remarks' =>trim("HIT count-".$hit_count."-".$response)
						);
						DB::table('tr05_recharge_detail')->where('tr05_trans_id',$transid)->update($arr);
						$response=str_replace("\xEF\xBB\xBF",'',$response); 
						$outgoinghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				        VALUES ('','$transid','$ip','$url','$response',2)");
                        $res_rbid=$transid;
                        
						if($res_format=="JSON")
						{
							$json=json_decode($response,true);
							$error_exist=array_key_exists('error',$json);
							$status_exist=array_key_exists('status',$json);
							$res_error='false';
							if($status!="" && $error_exist)
							{
								if($status_exist)
								{
								    $res_status=$json[$status];
									//$res_status='success';
									if($res_status==$res_fail && $error_exist)
									{
										$res_error=$json['error'];
										$auto_switch='true';
									}
									if($opid!='' && $res_status==$res_success)
									{
										$res_opid=$json[$opid];
										//$res_opid='';
										$auto_switch='false';
									}
									if($rbid!='' && $res_status!=$res_fail)
									{
										$res_rbid=$json[$rbid];
										//$res_rbid='';
									}
								}
								else
								{
									$res_error=$json['error'];
									$res_status="FAILED";
								}
								if($res_error=='true')
								{
									$auto_switch='true';
								}
							}
							else
							{
									if($status!="")
									{
										$res_status=$json[$status];
									}
									if($res_status==$res_fail )
									{
										$auto_switch='true';
									}
									if($opid!='' && $res_status==$res_success)
									{
										$res_opid=$json[$opid];
										$auto_switch='false';
									}
									if($rbid!='' && $res_status!=$res_fail)
									{
										$res_rbid=$json[$rbid];
									}
							}
							
						}
						if($res_format=="xml" || $res_format=="XML" )
						{
							$array = XmlToArray::convert($response);
							$json = json_encode($array);
							$xmlarray = json_decode($json,TRUE);
							if($status!="")
							{
								$res_status=$xmlarray[$status];
							}
							if($opid!='' && $res_status=="SUCCESS" )
							{
								$res_opid=$xmlarray[$opid];
								$auto_switch='false';
							}
							if($rbid!='' && ($res_status!="FAILED" || $res_status!="REFUND")  )
							{
								$res_rbid=$xmlarray[$rbid];
								$auto_switch='false';
							}
							if($msg!='' && ($res_status=="FAILED" || $res_status=="REFUND") )
							{
								$auto_switch='true';
							}
						}
						 					
						if($hit_count==5)
						{
							$auto_switch='false';
						}
						if($auto_switch=='false' || $next_api==0 )
						{
							if($res_status == $res_success || $res_status=="SUCCESS" || $res_status=="Success" )
							{	
								$status1="SUCCESS";
								$status2=1;
							}
							if($res_status==$res_pending || $res_status=="PENDING" || $res_status=="Pending")
							{
								$status1="PENDING";
								$status2=2;
							}
							if($res_status==$res_fail || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
							{
								$status1="FAILED";
								$status2=4;
							}
							$respreport=array(
							'proc'=>1,
							'userid'=>$user_id,
							'account'=>$mobileno,
							'transid'=>$transid,
							'liveid'=>$res_opid,
							'amt'=>$amount,
							'recstatus'=>$status2,
							'descrip'=>1							
							);
							$resquery = DB::select('CALL recharge_statusupdate(
							:proc,
							:userid,
							:account,
							:transid,
							:liveid,
							:amt,
							:recstatus,
							:descrip,
							@resmsg)',$respreport);
							$ERRMSG = "RECHARGE IS ".$status1."-".$hit_count;
							$this->isError= FALSE;
							$ERRCODE="success";
						     $response_inc=response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG ,
						'STATUS'=>trim($status1),
						'MOBILE'=>trim($mobileno),
						'AMOUNT'=>trim($amount),
						'AGENTID'=>trim($agentid),
						'OPID'=>trim($res_opid),
						'TID'=>trim($transid),
						'BAL'=>trim(floatval($BAL))
						]);
						return $response_inc;
						
						}
					
						if($hit_count<6)
                          return $status3;
					}
			
		}
		
	}?>