<?php
	namespace App\Http\Controllers\API;
	use Illuminate\Http\Request;
	use App\Http\Controllers\Controller;
	use DB;
	use Helper;
    use PayTM;
    use CyberPlat;

	class MoneyTransferWebService extends Controller
	{
		//
		private $STATUS = "failed";
		private $ERRMSG = "Invalid Operation";
		private $ERRCODE = "error";
		private $isError = FALSE;
		private $record_per_page =10;
        private $userData = '';
		
		private $environment    = "TEST";
		private $mid = "TALK2M53414181715410";/*your mid*/
		private $key = "aoxeves#9u!c3r7P";
		private $subwalletGuid = "adadadfd-ddec-11e9-8708-fa163e429e83";
		
		private $purpose = "BONUS";
		//include(app_path().'\Paytm\lib\encdec_paytm.php');

		public function valid_phone_number($str)
		{
			$regex = "/^[0-9]+$/";
			if(preg_match($regex,$str))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}
		public function valid_decimal_amount($amt)
		{
			$regex = "/^(?:d*.d{1,2}|d+)$/";
			if(preg_match($regex,$amt))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}
		
		
		public function dmt_register(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$token = $request->header('Authorization');
				$username="";$contactno="";$email="";$dob="";$location="";$pincode="";$bankproof="";$gstno ="";
				$username=$request->has('username')?'1':'0';
				$email=$request->has('email')?'1':'0';
				$contactno=$request->has('contactno')?'1':'0';
				$dob=$request->has('dob')?'1':'0';
				$location=$request->has('location')?'1':'0';	
				$pincode=$request->has('pincode')?'1':'0';
				if($token=='')
				{
					$ERRMSG ="Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'USERDATA'=>$login_detail[0]
							]);
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
				if($this->isError==FALSE)
				{
					if($username==0 || $contactno==0 || $email==0 || $dob==0 || $location==0 || $pincode==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('username')=='')
					{
						$ERRMSG = "User Name should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('contactno')=='')
					{
						$ERRMSG = "User Contact should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('email')=='')
					{
						$ERRMSG = "User Email address should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dob')=='')
					{
						$ERRMSG = "User Date of birth should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('location')=='')
					{
						$ERRMSG = "Location should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('pincode')=='')
					{
						$ERRMSG = "Pincode should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$name=explode(" " ,$request->input('username'));
					$user_name=$request->input('username');
					$pass=rand(100000,999999);
					$pinpass=rand(100000,999999);
					$data=array
					(
						'proc'=>1,
						'm11_user_id'=>0,
						'm11_user_code'=>'',
						'm22_affiliate_id'=>1,
						'm11_first_name'=> $name[0],
						'm11_last_name'=>$name[1],
						'm11_user_name'=> $request->input('username'),
						'm11_user_dob'=> '1970-01-01',
						'm11_user_gender'=> 1,
						'm11_user_email'=> $request->input('email'),
						'm11_user_contactno'=> $request->input('contactno'),
						'm11_user_about_me'=>'',
						'm11_user_interested_in'=>'',
						'm16_gr_id'=>1,
						'm11_user_location'=> $request->input('location'),
						'm11_user_image'=> '',
						'm11_user_role'=>8,
						'm11_cancellation_policy'=>2,
						'm11_subcription'=> 2,
						'm11_fb_id'=>'',
						'm11_gplus_id'=> '',
						'm11_user_status'=>2,
						'm11_user_callback'=>'',
						'm11_user_islogin'=> 2,
						'm11_user_istraveling'=> '',
						'm11_user_notifications'=> 1,
						'm11_user_emailalert'=> 1,
						'm11_user_newsletter'=> 1,
						'm11_user_language'=> 1,
						'm11_user_activate_code'=> '',
						'm11_user_api_token'=> uniqid ( base64_encode ( str_random(60))),
						'm11_user_device_token'=> '',
						'm11_user_device_type'=> '',
						'm11_user_app_version'=> '',
						'm11_user_latitude'=>'',
						'm11_user_longitude'=>'',
						'm11_user_referral_code'=>$login_detail[0]->RegId,
						'm22_shop_company_name'=>'',
						'm22_shop_gstin'=> '',
						'm22_shop_gstin_copy'=> $gstno,
						'm22_shop_bankproof_copy'=> $bankproof,
						'tr04_login_pwd'=>$pass,
						'tr04_pin_pwd'=>$pinpass
					);
					$result =  DB::select('CALL add_user(
						:proc,
						:m11_user_id,
						:m11_user_code,
						:m22_affiliate_id,
						:m11_first_name,
						:m11_last_name,
						:m11_user_name,
						:m11_user_dob,
						:m11_user_gender,
						:m11_user_email,
						:m11_user_contactno,
						:m11_user_about_me,
						:m11_user_interested_in,
						:m16_gr_id,
						:m11_user_location,
						:m11_user_image,
						:m11_user_role,
						:m11_cancellation_policy,
						:m11_subcription,
						:m11_fb_id,
						:m11_gplus_id,
						:m11_user_status,
						:m11_user_callback,
						:m11_user_islogin,
						:m11_user_istraveling,
						:m11_user_notifications,
						:m11_user_emailalert,
						:m11_user_newsletter,
						:m11_user_language,
						:m11_user_activate_code,
						:m11_user_api_token,
						:m11_user_device_token,
						:m11_user_device_type,
						:m11_user_app_version,
						:m11_user_latitude,
						:m11_user_longitude,
						:m11_user_referral_code,
						:m22_shop_company_name,
						:m22_shop_gstin,
						:m22_shop_gstin_copy,
						:m22_shop_bankproof_copy,
						:tr04_login_pwd,
						:tr04_pin_pwd,
						@status_code,
						@status_msg
					)',$signup_data);
					$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
	    }
		
		public function dmt_login(Request $request)
		{
			if($request->method() == 'POST')
			{
				$get_useralldetail = "";$dmt_user = "";
				$ERRMSG = "SEARCH AND VIEW USER DMT DETAILS";
				$ERRCODE="info";
				$token = $request->header('Authorization');
				$username="";
				$username=$request->has('sender_mobileno')?'1':'0';
				
				if($token=='')
				{
					$ERRMSG ="Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'USERDATA'=>$login_detail[0]
							]);
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
				if($this->isError==FALSE)
				{
					if($username==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('sender_mobileno')=='')
					{
						$ERRMSG = "Member contact number should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('sender_mobileno'))<10)
					{
						$ERRMSG = "Member contact number should be sequal to 10 digit.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('sender_mobileno'))>10)
					{
						$ERRMSG = "Member contact number should be equal to 10 digit.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$userid = Helper::get_userid($request->input('sender_mobileno'));
					if($userid!=FALSE)
					{
					$dmt_user = Helper::get_userdetail($userid);
					$get_useralldetail = Helper::get_user_bene_detail($userid);
					$ERRMSG = "USER DMT DETAILS";
					}
					else
					{
					$ERRMSG = "Mobile No is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					}
					return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}
		public function addbeneficiary(Request $request)
		{
			if($request->method() == 'POST')
			{
				$token = $request->header('Authorization');
				
				$contactno			=$request->has('contactno')?'1':'0';
				$txt_nameatbank		=$request->has('nameatbank')?'1':'0';
				$txt_cbsacno		=$request->has('cbsacno')?'1':'0';
				$txt_bankbranch		=$request->has('bankbranch')?'1':'0';
				$txt_bankifsccode	=$request->has('bankifsccode')?'1':'0';
				if($token=='')
				{
					$ERRMSG ="Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
				if($this->isError==FALSE)
				{
					if($contactno==0 || $txt_bankname==0 || $txt_cbsacno==0 || $txt_bankbranch==0 || $txt_bankifsccode==0 )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('contactno')=='')
					{
						$ERRMSG = "Member contact number should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('contactno'))<10)
					{
						$ERRMSG = "Member contact number should be sequal to 10 digit.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('contactno'))>10)
					{
						$ERRMSG = "Member contact number should be equal to 10 digit.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('nameatbank')=='' )
					{
						$ERRMSG = "Member Name at Bank should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('bankname')=='')
					{
						$ERRMSG = "Member Bank Name should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('cbsacno')=='')
					{
						$ERRMSG = "Member Bank no Account should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('bankbranch')=='')
					{
						$ERRMSG = "Member Bank Branch should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('bankifsccode')=='')
					{
						$ERRMSG = "Member Bank IFSCode should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$ACCOUNTNO=$request->input('txt_cbsacno');
					$USER= Helper::get_userid($request->input('contactno'));
					$arr = array(
					'm11_user_id'=>$USER,
					'm28_bene_nameat_bank'=>$request->input('nameatbank'),
					'm28_bene_cbsacno' =>$request->input('cbsacno'),
					'm01_bank_name'=>$request->input('bankname'),
					'm28_bene_branch'=>$request->input('bankbranch'),
					'm28_bene_ifscode' =>$request->input('bankifsccode')
					);
					DB::table('m28_b2cuser_beneficiary')->insert($arr);
					$bank_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('m11_user','','$ACCOUNTNO','$USER','USER S BENEFICIARY HAS BEEN ADDED SUCCESSFULLY!')");		
					$ERRMSG="USER'S BENEFICIARY HAS BEEN ADDED  SUCCESSFULLY!";
					$ERRCODE='success';	
					$dmt_user = Helper::get_userdetail($USER);
					$get_benealldetail = Helper::get_user_bene_detail($USER);
				    return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG, 
						'USER_DETAILS'=>$dmt_user,
						'BENE_DETAILS'=>$get_benealldetail
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}
		
		
		
		public function payto_bank(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$token = $request->header('Authorization');
				$beneficiaryname=""; $contactno="";$amount="";$orderId="";
				$beneficiaryAccount="";$beneficiaryIFSC="";$purpose="";
				$callbackUrl="";$comments="";$agentid="";
				
				$beneficiaryname	=$request->has('beneficiaryname')?'1':'0';
				$contactno			=$request->has('contactno')?'1':'0';
				$amount			    =$request->has('amount')?'1':'0';
				$beneficiaryAccount	=$request->has('beneficiaryAccount')?'1':'0';
				$beneficiaryIFSC	=$request->has('beneficiaryIFSC')?'1':'0';
				$purpose			=$request->has('purpose')?'1':'0';	
				$callbackUrl		=$request->has('callbackUrl')?'1':'0';
				$agentid            =$request->has('agentid')?'1':'0';
				
				if($token=='')
				{
					$ERRMSG ="Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$this->isError=FALSE;
						    $ERRCODE="success";
							
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($this->isError==FALSE)
				{
					if($beneficiaryname==0 || $contactno==0 || $beneficiaryAccount==0 || $beneficiaryIFSC==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneficiaryname')=='')
					{
						$ERRMSG = "Beneficiary Name should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('contactno')=='')
					{
						$ERRMSG = "User Contact should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('amount')=='')
					{
						$ERRMSG = "Amount should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneficiaryAccount')=='')
					{
						$ERRMSG = "Beneficiary Account should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneficiaryIFSC')=='')
					{
						$ERRMSG = "Beneficiary IFSCODE should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('purpose')=='')
					{
						$ERRMSG = "Purpose should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('callbackUrl')=='')
					{
						$ERRMSG = "Call backurl should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$dmr_req=array(
					'proc'=>'1',
					'm11_user_id'=>$login_detail[0]->RegId,
					'trans_id'=>'',
					'refre_id'=>'',
					'request_no'=>'',
					'mobile_no'=>$request->input('contactno'),
					'amount'=>$request->input('amount'),
					'payment_id'=>'',
					'payment_status'=>'',
					'impsrefno'=>'',
					'message'=>'',
					'remarks'=>'',
					'account_number'=>$request->input('beneficiaryAccount'),
					'beneficiary_code'=>'',
					'beneficiary_name'=>$request->input('beneficiaryname'),
					'account_type'=>'',
					'ifsc'=>$request->input('beneficiaryIFSC'),
					'bank_name'=>'',
					'branch_name'=>'',
					'address'=>'',
					'state'=>'',
					'city'=>'',
					'agentid'=>$request->input('agentid'),
					'payctransid'=>'',
					'topup_charge'=>'0.00',
					'transfer_status'=>'2'
					);	
					$dmrreq_response=DB::select('CALL doremmitance(				
					:proc,
					:m11_user_id,
					:trans_id,
					:refre_id,
					:request_no,
					:mobile_no,
					:amount,
					:payment_id,
					:payment_status,
					:impsrefno,
					:message,
					:remarks,
					:account_number,
					:beneficiary_code,
					:beneficiary_name,
					:account_type,
					:ifsc,
					:bank_name,
					:branch_name,
					:address,
					:state,
					:city,
					:agentid,
					:payctransid,
					:topup_charge,
					:transfer_status,
					@msg,
					@msg2
					)',$dmr_req);
					
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					$ERRCODE=$DB_ERROR[0]->ERROR;
					$ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
					if($DB_ERROR[0]->ERROR!="error" && $DB_ERROR[0]->ERROR!="Error")
					{
						if($DB_ERROR[0]->ERROR=="success"){
							$token="VlZvT2U3NFQxRDFOcTZjMWFzUVM3OWd5d0FiNWRXaVJCMkkxNnNMWEoxY2FDTEluQ3pNNkJkRENRN0Nn5fa3f39e08b84"; 
							$url="http://uniqueestore.in/public/"; 
							$url=$url."api/v1/apitransferto_bank";
							$data=json_encode(array(
							 'beneficiaryname'=>$request->input('beneficiaryname'),
							 'contactno'=>$request->input('contactno'),
							 'amount'=>$request->input('amount'),
							 'beneficiaryAccount'=>$request->input('beneficiaryAccount'),
							 'beneficiaryIFSC'=>$request->input('beneficiaryIFSC'),
							 'purpose'=>'PAYOUT',
							 'callbackUrl'=>'http://letslaunch.in/',
							 'agentid'=> $DB_ERRMSG[0]->ERR_MSG
							 ));
							$header_data=array(
													"Content-Type:application/json",
													"Authorization:".$token.""
												);
									$method="POST";
									if($method=="POST")
									{
										$curl = curl_init();
											curl_setopt_array($curl, array
											(
											CURLOPT_URL => $url,
											CURLOPT_RETURNTRANSFER => true,
											CURLOPT_ENCODING => "",
											CURLOPT_MAXREDIRS => 10,
											CURLOPT_TIMEOUT => 30,
											CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
											CURLOPT_CUSTOMREQUEST => "POST",
											CURLOPT_POSTFIELDS =>$data,
											CURLOPT_HTTPHEADER =>$header_data
											));
										$result = curl_exec($curl);
												if(!$result)
												{
													$result=trigger_error(curl_error($curl));
													curl_close($curl);
													print_r($result);
												}
												else
												{	                
													curl_close($curl);
													//print_r($result);
												}
									}
				
								$dmr_req=array(
								'proc'=>'3',
								'm11_user_id'=>$login_detail[0]->RegId,
								'trans_id'=>  $DB_ERRMSG[0]->ERR_MSG,
								'refre_id'=>'',
								'request_no'=>'',
								'mobile_no'=>$request->input('contactno'),
								'amount'=>$request->input('amount'),
								'payment_id'=>'',
								'payment_status'=>'',
								'impsrefno'=>'',
								'message'=>'',
								'remarks'=>$result,
								'account_number'=>$request->input('beneficiaryAccount'),
								'beneficiary_code'=>'',
								'beneficiary_name'=>$request->input('beneficiaryname'),
								'account_type'=>'',
								'ifsc'=>$request->input('beneficiaryIFSC'),
								'bank_name'=>'',
								'branch_name'=>'',
								'address'=>'',
								'state'=>'',
								'city'=>'',
								'agentid'=>$request->input('agentid'),
								'payctransid'=>'',
								'topup_charge'=>'0.00',
								'transfer_status'=>'2'
								);	
								$dmrreq_response=DB::select('CALL doremmitance(				
								:proc,
								:m11_user_id,
								:trans_id,
								:refre_id,
								:request_no,
								:mobile_no,
								:amount,
								:payment_id,
								:payment_status,
								:impsrefno,
								:message,
								:remarks,
								:account_number,
								:beneficiary_code,
								:beneficiary_name,
								:account_type,
								:ifsc,
								:bank_name,
								:branch_name,
								:address,
								:state,
								:city,
								:agentid,
								:payctransid,
								:topup_charge,
								:transfer_status,
								@msg,
								@msg2
								)',$dmr_req);
								$status1="PENDING";
								$status2=2;
								//$result = json_decode (json_encode($response));
					           $ERRMSG=$status1;
					           $respreport=array(
										'proc'=>1,
										'userid'=>$login_detail[0]->RegId,
										'account'=>$request->input('beneficiaryAccount'),
										'transid'=>  $DB_ERRMSG[0]->ERR_MSG,
										'liveid'=>"",
										'amt'=>$request->input('amount'),
										'recstatus'=>$status2,
										'descrip'=>$result
									);
							   $resp_report = DB::select('CALL dmr_statusupdate(
								 :proc,
								 :userid,
								 :account, 
								 :transid,
								 :liveid,
								 :amt,
								 :recstatus,
								 :descrip,
								 @msg
							 )',$respreport);

								return response()->json([
									'ERROR'=>$ERRCODE,
									'STATUS'=>$status1,
									'MSG' =>$ERRMSG,
									'REMARK'=>$ERRMSG
								]);
					}
}
				}
				else
				{
					return response()->json([
				'ERROR'=>$ERRCODE,
				'STATUS'=>'FAILED',
				'MSG' =>$ERRMSG 
				]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
	    }

		
		public function checkstatus_from_bank(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$token = $request->header('Authorization');
				$orderid=""; $contactno="";$amount="";$orderId="";
				$beneficiaryAccount="";$beneficiaryIFSC="";$purpose="";
				$callbackUrl="";$comments="";$agentid="";
				$orderid	=$request->has('dmr_tid')?'1':'0';
				if($token=='')
				{
					$ERRMSG ="Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$this->isError=FALSE;
						    $ERRCODE="success";
							
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($this->isError==FALSE)
				{
					if($orderid==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dmr_tid')=='')
					{
						$ERRMSG = "Transaction Id should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					
					
						$transid=$request->input('dmr_tid');
						$environment    = "PROD";
						$mid="Vaishn02349821820001";
						$key = "We8JEr#pejrBk5#u";     
						$orderId = $transid;
						$subwalletGuid = "f527834b-18ff-47c5-9cd6-1fa9e06d2dbb";
						$beneficiaryAccount = $request->input('beneficiaryAccount');
						$amount = $request->input('amount');
						$beneficiaryIFSC =$request->input('beneficiaryIFSC');
						$purpose = "BONUS";
						$paramList = array();
						$paramList["orderId"]                 = $orderId;
						$body= json_encode($paramList, true);
						$Checksumhash = PayTM::getChecksumFromString($body,$key);
						$header= array('Content-Type:application/json', 'x-mid:'.$mid, 'x-checksum:'.$Checksumhash);
						 $url ='https://staging-dashboard.paytm.com/bpay/api/v1/disburse/order/query';
						if($environment == "PROD")
							$url = 'https://dashboard.paytm.com/bpay/api/v1/disburse/order/query';
							//echo $url.'</br>';
							//echo "CheckSum-".$Checksumhash.'</br>';
							//echo "Header-".print_r($header).'</br>';
							//echo "BODY-".print_r($body).'</br>';
							$response=Helper::__curl_execute('POST',$url,$body,$header);

							$status_data=json_encode($response);
							$status1="PENDING";
								$status2=2;
								$txt_status=$response['status'];
								$operid=$response['result']['rrn'];
								$account=$response['result']['paytmOrderId'];	
								$amount=$response['result']['amount'];
							if($txt_status=="SUCCESS")
							{
								$status1="SUCCESS";
								$status2=1;
								$ERRCODE="success";
							}
							if($txt_status=="PENDING")
							{
								$status1="PENDING";
								$status2=2;
								$ERRCODE="warning";
							}
							if($txt_status=="FOR REFUND")
							{
								$status1="FOR REFUND";
								$status2=3;
								$ERRCODE="warning";
							}
							if($txt_status=="FAILURE")
							{
								$status1="FAILED";
								$status2=4;
								$ERRCODE="error";
							}
							if($txt_status=="REFUNDED")
							{
								$status1="REFUNDED";
								$status2=5;
								$ERRCODE="error";
							}
							if($txt_status=="RSUCCESS")
							{
								$status1="RSUCCESS";
								$status2=7;
							}
							$respreport=array(
										'proc'=>2,
										'userid'=>$login_detail[0]->RegId,
										'account'=>$account,
										'transid'=>$transid,
										'liveid'=>$operid,
										'amt'=>$amount,
										'recstatus'=>$status2,
										'descrip'=>json_encode($response)
									);
							
							$resp_report = DB::select('CALL dmr_statusupdate(
								 :proc,
								 :userid,
								 :account, 
								 :transid,
								 :liveid,
								 :amt,
								 :recstatus,
								 :descrip,
								 @msg
							 )',$respreport);
							 //$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							//dd($DB_ERRMSG[0]->ERR_MSG);
								return response()->json([
									'ERROR'=>$ERRCODE,
									'MSG' =>$response['statusMessage'],
									'REMARK'=>$response['result']
								]);
					
				}
				else
				{
					return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
	    }





		public function payto_icicibank(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$token = $request->header('Authorization');
				$beneficiaryname=""; $contactno="";$amount="";$orderId="";
				$beneficiaryAccount="";$beneficiaryIFSC="";$purpose="";
				$callbackUrl="";$comments="";$agentid="";
				
				$beneficiaryname	=$request->has('beneficiaryname')?'1':'0';
				$contactno			=$request->has('contactno')?'1':'0';
				$amount			    =$request->has('amount')?'1':'0';
				$beneficiaryAccount	=$request->has('beneficiaryAccount')?'1':'0';
				$beneficiaryIFSC	=$request->has('beneficiaryIFSC')?'1':'0';
				$purpose			=$request->has('purpose')?'1':'0';	
				$callbackUrl		=$request->has('callbackUrl')?'1':'0';
				$agentid            =$request->has('agentid')?'1':'0';
				
				if($token=='')
				{
					$ERRMSG ="Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$this->isError=FALSE;
						    $ERRCODE="success";
							
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($this->isError==FALSE)
				{
					if($beneficiaryname==0 || $contactno==0 || $beneficiaryAccount==0 || $beneficiaryIFSC==0 || $purpose==0 || $agentid==0 || $callbackUrl==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneficiaryname')=='')
					{
						$ERRMSG = "Beneficiary Name should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('contactno')=='')
					{
						$ERRMSG = "User Contact should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('amount')=='')
					{
						$ERRMSG = "Amount should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneficiaryAccount')=='')
					{
						$ERRMSG = "Beneficiary Account should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneficiaryIFSC')=='')
					{
						$ERRMSG = "Beneficiary IFSCODE should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('purpose')=='')
					{
						$ERRMSG = "Purpose should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('callbackUrl')=='')
					{
						$ERRMSG = "Call backurl should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					    $transid=date('YmdHis');

						$environment    = "STAGING";
						
						$passcode = "a9a42043d31945c0bbb87f6fc5d0b31e";     
						$orderId = $transid;
		
						$paramList = array();
						$paramList["RemMobile"]  = '8188802777';
						$paramList["RemName"]    = 'ARVIND RASTOGI';
						$paramList["RetailerCode"]  = 'UEB001';
						$paramList["Amount"]     = '10.00';
						$paramList["BeneAccNo"]  = '111234567890';
						$paramList["BeneIFSC"]   = 'DLXB0000092';
						$paramList["TranRefNo"]  = $orderId;
						$paramList["PaymentRef"] = "FTTransferP2A";
						$paramList["PassCode"] = $passcode;
						$paramList["TransactionDate"] = date('YmdHis');
						$body=$paramList;
						//$body= json_encode($paramList, true);
						$header= array('Content-Type:application/json');
						$url ='http://impsbc.icicibank.co.in:7474/imps-web-bc/api/transaction/bc/ABC/p2a?';
						$response=Helper::__curl_execute('POST',$url,$body,$header);
						echo $_SERVER['LOCAL_ADDR'];
						echo $url;
						echo "BODY-".print_r($body);
						echo "Header-".print_r($header);
						echo "RESPONSE-".print_r($response);
						dd();
								return response()->json([
									'ERROR'=>$ERRCODE,
									'STATUS'=>$status1,
									'MSG' =>$ERRMSG,
									'REMARK'=>$ERRMSG
								]);
				
				}
				else
				{
					return response()->json([
				'ERROR'=>$ERRCODE,
				'STATUS'=>'FAILED',
				'MSG' =>$ERRMSG 
				]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
	    }

		public function verify_account(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$token = $request->header('Authorization');
				$beneficiaryname=""; $contactno="";$amount="";$orderId="";
				$beneficiaryAccount="";$beneficiaryIFSC="";$purpose="";
				$callbackUrl="";$comments="";$agentid="";

				$beneficiaryAccount	=$request->has('beneficiaryAccount')?'1':'0';
				$beneficiaryIFSC	=$request->has('beneficiaryIFSC')?'1':'0';
	
				if($token=='')
				{
					$ERRMSG ="Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$this->isError=FALSE;
						    $ERRCODE="success";
							
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($this->isError==FALSE)
				{
					if($beneficiaryAccount==0 || $beneficiaryIFSC==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneficiaryAccount')=='')
					{
						$ERRMSG = "Beneficiary Account should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneficiaryIFSC')=='')
					{
						$ERRMSG = "Beneficiary IFSCODE should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$transid = DB::select("SELECT `get_transaction_id`() as TXNID");
					$txnid=$transid[0]->TXNID;
					$bene_account=$request->input('beneficiaryAccount');
					$bene_ifscode=$request->input('beneficiaryIFSC');
					$ACCHOLDER_NAME=""; 
					$BANK_REFNO="";
					$VERIFI_STATUS =""; $REMARK="";
					$token="aHI3emZiY2FNZHEzRW5nMlNUQm1SY1pPSWNwTlhq5e2fe23126a59"; 
					$url="http://uniqueestore.in/public/"; 
					//$url=$url."api/v1/apiverify_account";
					$data=json_encode(array(
						 'beneficiaryAccount'=>$request->input('beneficiaryAccount'),
						 'beneficiaryIFSC'=>$request->input('beneficiaryIFSC')
						 ));
					$header_data=array(
													"Content-Type:application/json",
													"Authorization:".$token.""
												);
					$method="POST";
					if($method=="POST")
					{
						$curl = curl_init();
							curl_setopt_array($curl, array
							(
							CURLOPT_URL => $url,
							CURLOPT_RETURNTRANSFER => true,
							CURLOPT_ENCODING => "",
							CURLOPT_MAXREDIRS => 10,
							CURLOPT_TIMEOUT => 30,
							CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
							CURLOPT_CUSTOMREQUEST => "POST",
							CURLOPT_POSTFIELDS =>$data,
							CURLOPT_HTTPHEADER =>$header_data
							));
						$result = curl_exec($curl);
						if(!$result)
						{
							$result=trigger_error(curl_error($curl));
							curl_close($curl);
							print_r($result);
						}
						else
						{	                
							curl_close($curl);
						    //print_r($result);
						}
					}
								$json=json_decode($result,true);
								if($json['ERROR']=="error")
								{
								$status1="FAILED";
								$status2=4;
								$ERRCODE="warning";
								$ERRMSG=$json['MSG'];
							    $REMARK=$json['REMARK'];
								}
								else if($json['ERROR']=="success")
								{
								$status1="SUCCESS";
								$status2=1;
								$ERRCODE="success";
								$ERRMSG=$json['MSG'];
							    $REMARK=$json['REMARK'];
								}
								else
								{
								$ERRCODE="info";
								}
					          
								return response()->json([
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG,
									'REMARK'=>$REMARK
								]);
					
				}
				else
				{
					return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
	    }














		
}?>