<?php

namespace App\Http\Controllers\API;

use App\Repositories\Product\ProductRepository;
use App\Repositories\Category\CategoryRepository;
use App\Repositories\Subcategory\SubcategoryRepository;
use App\Repositories\Brand\BrandRepository;
use App\Repositories\User\UserRepository;
use App\Repositories\Wishlist\WishlistRepository;
use App\Repositories\Address\AddressRepository;
use App\Repositories\Order\OrderRepository;
use App\Repositories\Option\OptionRepository;
use App\Repositories\Unit\UnitRepository;
use App\Repositories\Banner\BannerRepository;
use App\Repositories\Market\MarketRepository;
use App\Repositories\Faq\FaqRepository;
use App\Repositories\Favorites\FavoritesRepository;
use App\Repositories\Cart\CartRepository;
use App\Repositories\Categorypriority\CategorypriorityRepository;
use Illuminate\Http\Request; 
use App\Http\Requests;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use DB;
use Config;
use Helper;
use Session;
use Cookie;
use App;
use File;

class GroceryWebApi extends Controller
{
    private $product;
	private $category;
	private $subcategory;
    private $brand;
    private $folder;
    private $user;
    private $wishlist;
    private $address;
    private $order;
    private $option;
    private $unit;
    private $banner;    
    private $market;
    private $faq;
    public $lang;
    public $translation;
    public $favorites;
    public $cart;
    private $categorypriority;

    public function __construct(ProductRepository $product,
	 CategoryRepository $category,
	  SubcategoryRepository $subcategory, BrandRepository $brand,
      UserRepository $user, WishlistRepository $wishlist,
      AddressRepository $address, OrderRepository $order, OptionRepository $option,
      UnitRepository $unit, BannerRepository $banner, MarketRepository $market,
      FaqRepository $faq, FavoritesRepository $favorites, CartRepository $cart, 
      CategorypriorityRepository $categorypriority)
    {
    	$this->product = $product;
    	$this->category = $category;
    	$this->subcategory = $subcategory;
        $this->brand = $brand;
        $this->user = $user;
        $this->folder = 'Front1';
        $this->wishlist = $wishlist;
        $this->address = $address;
        $this->order = $order;
        $this->option = $option;
        $this->unit = $unit;
        $this->banner = $banner;
        $this->market = $market;
        $this->faq = $faq;
        $this->favorites = $favorites;
        $this->cart = $cart;
        $this->categorypriority = $categorypriority;
    }

    /**
			* Method name	: Home
			* @description 	: Used for getting all data for home page 
			* @param		: Request data  
			* @return		: Return response with category banners, categories and products
		*/
    public function home(){
        Helper::get_lang();
        $cat_banner = $this->banner->getCategoryBanner();
        $offer_banner = $this->banner->getOfferBanner();
        $promo_banner = $this->banner->getPromoBanner();
    	$categories = $this->category->getByParentId();
        $proirity_one = $this->categorypriority->getByPriority('first');
        $proirity_two = $this->categorypriority->getByPriority('second');
        $proirity_three = $this->categorypriority->getByPriority('third');
        $proirity_four = $this->categorypriority->getByPriority('fourth');
        $proirity_five = $this->categorypriority->getByPriority('fifth');
        $cat_one = $this->getProducts($proirity_one[0]->m29_cat_id);
        $cat_two = $this->getProducts($proirity_two[0]->m29_cat_id);
        $cat_three = $this->getProducts($proirity_three[0]->m29_cat_id);
        $cat_one_name = $this->category->getName($proirity_one[0]->m29_cat_id);
        $cat_two_name = $this->category->getName($proirity_two[0]->m29_cat_id);
        $cat_three_name = $this->category->getName($proirity_three[0]->m29_cat_id);

        if(isset($proirity_four[0]->m29_cat_id)){
            $cat_four = $this->getProducts($proirity_four[0]->m29_cat_id);
            $cat_four_name = $this->category->getName($proirity_four[0]->m29_cat_id);
        }
        else{
            $cat_four = '';
            $cat_four_name = '';
        }

        if(isset($proirity_five[0]->m29_cat_id)){
            $cat_five = $this->getProducts($proirity_five[0]->m29_cat_id);
            $cat_five_name = $this->category->getName($proirity_five[0]->m29_cat_id);
        }
        else{
            $cat_five = '';
            $cat_five_name = '';
        }
        //dd($cat_four);
        $cart_items = "";
        $cart = json_decode(Cookie::get('cart'));
        if($cart != ""){
            $cart_items = $cart;       
        }else{
            $cart_items = ""; 
        }

    	return response()->json([
			'cat_banner'=>$cat_banner,
			'offer_banner' =>$offer_banner,
			'promo_banner'=>$promo_banner,
			'categories' =>$categories, 
			'cat_one'=>$cat_one,
			'cat_two' =>$cat_two, 
			'cat_three'=>$cat_three,
			'cat_four' =>$cat_four, 
			'cat_five'=>$cat_five,
			'cart_items' =>$cart_items,
			'cat_one_name'=>$cat_one_name,
			'cat_two_name' =>$cat_two_name, 
			'cat_three_name'=>$cat_three_name,
			'cat_four_name' =>$cat_four_name,
			'cat_five_name' =>$cat_five_name   
		]);
    }

    /**
			* Method name	: Get products
			* @description 	: Used for getting products by category
			* @param		: Request data  
			* @return		: Return response with products data
		*/
    public function getProducts($id){
        Helper::get_lang();
        $categories = $this->category->getByParentId();
        $category = $this->category->getById($id);
        $count = count($categories);
        $arr = '';
        foreach($categories as $sc){
            if($sc->m29_parent_id == $category[0]->m29_cat_id){
                $arr = $sc->m29_cat_id.','.$arr;
                    foreach($categories as $ic){
                        if($ic->m29_parent_id == $sc->m29_cat_id){
                            $arr = $ic->m29_cat_id.','.$arr;
                        }           
                    }
            }
        }
        return DB::select("select * from m33_products left join m46_markets on m33_products.m46_market_id = m46_markets.m46_id where m33_products.m29_cat_id IN (".$arr."".$category[0]->m29_cat_id.")");
    }
    

}
