<?php
namespace App\Http\Controllers\API;
use Illuminate\Http\Request;
use App\Repositories\Closing\ClosingRepository;
use App\Repositories\Master\Location\LocationRepository;
use App\Repositories\Master\Package\PackageRepository;
use App\Repositories\Employee\EmployeeRepository;
use App\Repositories\Enroll\EnrollRepository;
use App\Repositories\Associate\AssociateRepository;
use App\Repositories\Recharge\Rechargereport\RechargereportRepository;
use App\Repositories\Team\TeamRepository;
use App\Repositories\Profile\ProfileRepository;
use App\Repositories\Log\LogRepository;
use App\Repositories\Master\Bank\BankRepository;
use App\Repositories\Master\Banner\BannerRepository;
use App\Repositories\Dmt\Dmtprocess\DmtprocessRepository;

use App\Repositories\Dmt\Dmtreport\DmtreportRepository;
use App\Repositories\Fund\FundRepository;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller;
use DB;
use Image;
use Helper;
use Session;
use Hash;
use Validator;
use Mtownsend\XmlToArray\XmlToArray;
use Faker\Generator as Faker;
	
class AppWebService extends Controller
{
    //
	private $STATUS = "failed";
	private $ERRMSG = "Invalid Operation";
	private $ERRCODE = "error";
	private $isError = FALSE;
	private $record_per_page =10;
    private $userData = '';
    private $closing_repo;
	private $location_repo;
	private $package_repo;
	private $emp_repo;
	private $enroll_repo;
	private $profile_repo;
	private $rech_reprt_repo;
	private $team_repo;
	private $log_repo;
	private $bank_repo;
	private $associate_repo;
    private $banner_repo;
	private $dmt_proc_repo;
	private $fund_repo;private $dmt_reprt_repo;


	public function __construct(ClosingRepository $closing_repo,LocationRepository $location_repo, PackageRepository $package_repo,
		EmployeeRepository $emp_repo, EnrollRepository $enroll_repo, ProfileRepository $profile_repo,
		RechargereportRepository $rech_reprt_repo, TeamRepository $team_repo, LogRepository $log_repo,
		BankRepository $bank_repo, AssociateRepository $associate_repo,BannerRepository $banner_repo,DmtreportRepository $dmt_reprt_repo,
		DmtprocessRepository $dmt_proc_repo, FundRepository $fund_repo)
    {
    	$this->closing_repo = $closing_repo;
    	$this->location_repo = $location_repo;
    	$this->package_repo = $package_repo;
    	$this->emp_repo = $emp_repo;
    	$this->enroll_repo = $enroll_repo;
    	$this->profile_repo = $profile_repo;
    	$this->rech_reprt_repo = $rech_reprt_repo;
    	$this->team_repo = $team_repo;
    	$this->log_repo = $log_repo;
    	$this->bank_repo = $bank_repo;
    	$this->associate_repo = $associate_repo;
		$this->banner_repo = $banner_repo;
		$this->dmt_proc_repo = $dmt_proc_repo;
		$this->dmt_reprt_repo = $dmt_reprt_repo;
    	$this->fund_repo = $fund_repo;
    }


		function valid_phone_number($str)
		{
			$regex = "/^[0-9]+$/";
			if(preg_match($regex,$str))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}
		



/**
			* Method name	: Banner
			* @description 	: Used to Get Banner 
			* @param		: Request data  
			* @return		: Get App Banner array with response message
		*/
		public function banner(Request $request)
		{
			
			if($_SERVER['REQUEST_METHOD']=="GET")
			{	
				if($request->affiliate == null)
				{
							$ERRMSG = "Affiliate id should be valid";
							$ERRCODE="error";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
				}	
				
				$banners = $this->banner_repo->getByIdAndAffi(4,$request->affiliate);

					if($banners)
					{
							$ERRMSG = "BANNER GET SUCCESSFULLY";
							$ERRCODE="success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'BANNER'=>$banners
							]);
					}
					else
					{
						$ERRMSG = "BANNER  NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
						]);
					}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
		}



		
	public function dapp_login(Request $request)
	{
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
				$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;
				if($request->input('usercode')=='')
				{
					$ERRMSG = "User code should be fvalid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
					return response()->json([
					'ERROR_CODE'=>'000',
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				
				/*else if($request->input('device_type')=='')
				{
					$ERRMSG = "Device Type should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if($request->input('device_type')!='android')
				{
					$ERRMSG = "Device Type should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if($request->input('imei_no')=='')
				{
					$ERRMSG = "Device IMEI NO should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}*/
				else
				{
						$login_data = array(
                            'login_id'=>$request->usercode,
                            'login_ip'=>$request->server('REMOTE_ADDR'),
                            'user_agent'=>$request->server('HTTP_USER_AGENT'),
                            'user_type'=>2
                        );
						
            $result =  DB::select('CALL dapp_login(:login_id,:login_ip,:user_agent, :user_type, @status_code,@status_msg)',$login_data);
			$count = count($result);

			$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
			$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

			$userData = DB::select("SELECT * FROM `tr04_login` WHERE `tr04_login`.`m11_bsc_address`='".$request->usercode."' LIMIT 1"); //OR `tr04_login`.`m11_user_email`='".$request->usercode."'
								

                    if($count == 1)
                    {

                        foreach($result as $row)
                        {
                            break;
                        }	

						$sessiondata=array(
							'USER_ID'	      =>	$result[0]->USER_ID,
							'EMAIL'  		  =>	$result[0]->EMAIL,
							'NAME'     		  => 	$result[0]->FIRST_NAME.$result[0]->LAST_NAME,
							'USER_CODE' 	  =>	$result[0]->USER_CODE,
							'USER_ROLE' 	  =>	$result[0]->USER_ROLE,
							'USER_ROLE_ID'    => 	$result[0]->USER_ROLE_ID,
							'USER_TYPE'    	  =>    $result[0]->USER_TYPE,
							'CONTACTNO' 	  =>	$result[0]->CONTACTNO,
							'USER_IMG'        =>	$result[0]->USER_IMG,
							'AFFILIATE_CODE'  => 	$result[0]->AFFILIATE_CODE,
							'IS_LOGIN' 	      => 	$result[0]->IS_LOGIN,
							'GROUP_ID'        =>	$result[0]->USER_GROUPID
						);

						Session::put($sessiondata);
						//Session::flash('type','success' );
						//Session::flash('message','Success "Login' );
						//return redirect('/user_dashboard');
						return response()->json([
								'ERROR_CODE'=>$request->usercode,
								'ERROR'=>'SUCCESS',
								'MSG' =>$DB_ERRMSG[0]->ERR_MSG 
								]);
                    }
                    else 
                    {
						$ERRMSG = $DB_ERRMSG[0]->ERR_MSG;
						$ERRCODE="error";	
						return response()->json([
								'ERROR_CODE'=>'000',
								'ERROR'=>$ERRCODE,
								'MSG' =>$ERRMSG 
								]);
                    }	
			}	
				
		}
		else
		{
			$ERRMSG="THIS METHOD IS NOT ALLOWED";
			$ERRCODE="error";
			return response()->json([
			'ERROR_CODE'=>'000',
			'ERROR'=>$ERRCODE,
			'MSG' =>$ERRMSG 
			]);
		}
	}
			
		public function login(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
					$apitoken="";$userid="";$url="";
					$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
					$format="json";$param1="";$param2="";
					$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
					$res_status="";$res_opid="";$res_rbid="";$res_msg="";
					$status1="PENDING";$status2=2;
					if($request->input('usercode')=='')
					{
						$ERRMSG = "User code should be fvalid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else if($request->input('password')=='')
					{
						$ERRMSG = "Password should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else if($request->input('device_type')=='')
					{
						$ERRMSG = "Device Type should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else if($request->input('device_type')!='android')
					{
						$ERRMSG = "Device Type should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else if($request->input('imei_no')=='')
					{
						$ERRMSG = "Device IMEI NO should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else
					{
							$login_data = array(
                                'login_id'=>$request->usercode,
                                'user_pwd'=>$request->password,
                                'login_ip'=>$request->server('REMOTE_ADDR'),
                                'user_agent'=>$request->server('HTTP_USER_AGENT'),
                                'user_type'=>2
                            );
							//print_r($login_data);
                        $result =  DB::select('CALL login(:login_id, :user_pwd,:login_ip,:user_agent, :user_type, @status_code,@status_msg)',$login_data);

						$userData = DB::select("SELECT * FROM `tr04_login` WHERE `tr04_login`.`m11_user_contactno`='".$request->usercode."' LIMIT 1"); //OR `tr04_login`.`m11_user_email`='".$request->usercode."'
									
									if(count($userData) >0)
									{
										if(Hash::check($request->password, $userData[0]->tr04_login_pwd)) 
										{
											$count = count($result);
											$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
											$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
										}
										else
										{
											$count = 0;
											return response()->json([
											'ERROR_CODE'=>"error",
											'ERROR'=>"201",
											'MSG' =>"Please Check Your Login Password " 
											]);
										}

									}
									else
									{
										$count = 0;
										return response()->json([
										'ERROR_CODE'=>"error",
										'ERROR'=>"101",
										'MSG' =>"Please Check Your Login id " 
										]);
									}

                        //$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                       // $DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

                        if($count == 1)
                        {
                            foreach($result as $row)
                            {
                                break;
                            }

						//for app refral inpor
						//DB::table('m76_app_refral')->update(['m11_new_user' => $row->USER_ID])->where('m76_device_id', $request->imei_no);

							if($request->input('device_type')=='android')
							{
										if($request->input('imei_no')==trim($row->DEVICE_TOKEN) || trim($row->DEVICE_TOKEN)=='')
										{
												if(trim($row->DEVICE_TOKEN)=='')
												{
													$DEVICE_TOKEN=$request->input('imei_no');
													$DEVICE_TYPE=$request->input('device_type');
													$user_devicedetails=DB::update("UPDATE `m11_user` SET `m11_user_device_token`='".$DEVICE_TOKEN."' WHERE `m11_user_code`='".$request->input('usercode')."'");	
												}
												$ERRCODE="success";
												$ERRMSG = $DB_ERRMSG[0]->ERR_MSG;
												return response()->json([
												'ERROR_CODE'=>$DB_ERRCODE[0]->ERR_CODE,
												'ERROR'=>$ERRCODE,
												'MSG' =>$ERRMSG,
												'TOKEN'=>trim($row->API_TOKEN)
												]);
										}
										else
										{
											$ERRCODE="error";
											/*$message=rand(10000,99999);*/
											$message='123456';
											$msg="Please submit this code ".$message." to verify your device.";
											$user_logindetails=DB::update("UPDATE `tr04_login` SET `tr04_device_otp` =".$message." WHERE `m11_user_contactno`='".$request->input('usercode')."'");
											
											// SMS SEND OR INSERT
											$sms_data['MOBILE_NO'] = $row->CONTACTNO;
											$sms_data['SUBJECT'] = 'User App Login';
											$sms_data['MESSAGE'] = $msg;
											$sms_data['TYPE'] = 4;
											$sms_data['SEND_BY'] = 2;
											$sms_data['SEND_BY_ID'] = $row->USER_ID;
											Helper::send_sms_or_log($sms_data);
											//SMS SEND END 

											$ERRMSG = "Please check your E-mail account OR Mobile No to DEVICE CHANGED,PLEASE VERIFY BY OTP'.";
											return response()->json([
														'ERROR_CODE'=>'104',
														'ERROR'=>$ERRCODE,
														'MSG' =>$ERRMSG 
														]);
										}
						   }
							
                        }
                        else 
                        {
							$ERRMSG = $DB_ERRMSG[0]->ERR_MSG;
							$ERRCODE="error";
								if($DB_ERRCODE[0]->ERR_CODE=="103")
								{
										/*$message=rand(10000,99999);*/
											$message='123456';
									$msg="Please submit this code ".$message." to active your account.";
									$user_logindetails=DB::update("UPDATE `tr04_login` SET `tr04_lb_otp` =".$message." WHERE `m11_user_contactno`='".$request->input('usercode')."'");
											
											// SMS SEND OR INSERT
											$sms_data['MOBILE_NO'] = $row->CONTACTNO;
											$sms_data['SUBJECT'] = 'User App Login';
											$sms_data['MESSAGE'] = $msg;
											$sms_data['TYPE'] = 4;
											$sms_data['SEND_BY'] = 2;
											$sms_data['SEND_BY_ID'] = $row->USER_ID;
											Helper::send_sms_or_log($sms_data);
											//SMS SEND END 

									$ERRMSG = "Please check your E-mail account OR Mobile No to verify OTP.";
								}
							return response()->json([
							'ERROR_CODE'=>$DB_ERRCODE[0]->ERR_CODE,
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
                        }		
					}
						return response()->json([
						'ERROR_CODE'=>'000',
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
			}
			else
			{
				$ERRMSG="THIS METHOD IS NOT ALLOWED";
				$ERRCODE="error";
				return response()->json([
				'ERROR_CODE'=>'000',
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}





        /**
			* Method name	: Add Member
			* @description 	: Add Team
			* @param		: Request data  
			* @return		: Add user as Team array with response message
		*/
		public function add_user(Request $request, Faker $faker)
		{

			$request->merge([
			    'txt_username' => 'DAPP USER',
			    'txt_password' => '123456',
			    'txt_mobileno' => '0000000000',
			    'txt_address' => 'INDIA',
			    'dd_role' => '8',
			    'dd_state' => '1',
			    'dd_city' => '1',
			    'dd_country' => '1',
			    'dd_position' => 'LEFT',
			    'txt_email' => $faker->unique()->email	
			]);


				if( $request->method() == 'POST')
				{
				$txt_cancelchq="";
				$txt_gstcrt ="";
				$username="";$email="";$mobileno="";$referral_code="";$password="";
				$username=$request->has('txt_username')?'1':'0' ;
				$dd_position=$request->has('dd_position')?'1':'0' ;
				$email=$request->has('txt_email')?'1':'0' ;
				$mobileno=$request->has('txt_mobileno')?'1':'0' ;
				$referral_code=$request->has('txt_referralcode')?'1':'0' ;
				$password=$request->has('txt_password')?'1':'0' ;
					if($username==0|| $email==0 || $referral_code==0|| $password==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->get('txt_username')=='')
					{
						$ERRMSG = "Affiliate Id should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
						
					}
					else if($request->get('txt_referralcode')=='')
					{
						$ERRMSG = "Referral Code should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
					}
					else if($request->get('dd_position')=='')
					{
						$ERRMSG = "Position should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
					}
					else if($request->input('txt_password')=='')
					{
						$ERRMSG = "Password should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
					}
					else if($request->input('txt_bscaddress')=='')
					{
						$ERRMSG = "BSC Address should be valid";
						$this->isError= TRUE;
						$ERRCODE="error";
					}
					else
					{
						$ERRMSG = "";
						$this->isError= FALSE;
						$ERRCODE="success";
						
					}
					if($this->isError==FALSE && $request->method() == 'POST')
					{	
						
						$pass=$request->input('txt_password');
						$pinpass=$request->input('txt_password');
						$bankproof ="";
						$gstno = $request->input('txt_bscaddress');
						$signup_data=Helper::reg_data($request,$pass,$pinpass,'','','',$gstno,$bankproof);   
						$response= $this->enroll_repo->create($signup_data);
						
						//for app refral import
						//DB::table('m76_app_refral')->update(['m11_new_user' => $response['ID']])->where('m76_device_id', $request->txt_device_id);

						$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
						if( $ERRCODE[0]->ERR_CODE=="success")
						{
							$uid = Helper::getuserdetail_ByMobileNo($request->input('txt_mobileno'));
							$user_massage  = $request->input('txt_username')." has been registered successfully. Website-".config('WEBSITE_NAME')."";
											// SMS SEND OR INSERT
								$sms_data['MOBILE_NO'] = $request->input('txt_mobileno');
								$sms_data['SUBJECT'] = 'Signup User in App';
								$sms_data['MESSAGE'] = $user_massage;
								$sms_data['TYPE'] = 1;
								$sms_data['SEND_BY'] = 2;
								$sms_data['SEND_BY_ID'] = $uid[0]->RegId;
							    Helper::send_sms_or_log($sms_data);
											//SMS SEND END 
							return response()->json([
							'ERROR'=>$ERRCODE[0]->ERR_CODE,
							'MSG' =>$user_massage 
							]);
						}
							return response()->json([
							'ERROR'=>$ERRCODE[0]->ERR_CODE,
							'MSG' =>$ERRMSG[0]->ERR_MSG 
							]);
					}
					else
					{
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
			}
			else
			{
				$ERRMSG="THIS METHOD IS NOT ALLOWED";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}




        /**
			* Method name	: Add Member
			* @description 	: Add Team
			* @param		: Request data  
			* @return		: Add user as Team array with response message
		*/
		public function signup(Request $request)
		{
				if( $request->method() == 'POST')
				{
				$txt_cancelchq="";
				$txt_gstcrt ="";
				$username="";$email="";$mobileno="";$referral_code="";$password="";
				$username=$request->has('txt_username')?'1':'0' ;
				$dd_position=$request->has('dd_position')?'1':'0' ;
				$email=$request->has('txt_email')?'1':'0' ;
				$mobileno=$request->has('txt_mobileno')?'1':'0' ;
				$referral_code=$request->has('txt_referralcode')?'1':'0' ;
				$password=$request->has('txt_password')?'1':'0' ;
					if($username==0|| $email==0 || $mobileno==0 || $referral_code==0|| $password==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->get('txt_username')=='')
					{
						$ERRMSG = "Affiliate Id should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
						
					}
					else if($request->get('txt_mobileno')=='')
					{
						$ERRMSG = "Mobile no should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
						
					}
					else if(!$this->valid_phone_number($request->get('txt_mobileno')))
					{
						$ERRMSG = "Mobile no should be valid or numeric.";
						$this->isError= TRUE;
						$ERRCODE="error";
						
					}
					else if($request->get('txt_referralcode')=='')
					{
						$ERRMSG = "Referral Code should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
					}
					else if($request->get('dd_position')=='')
					{
						$ERRMSG = "Position should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
					}
					else if($request->get('txt_device_id')=='')
					{
						$ERRMSG = "Device id should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
					}
					else if($request->input('txt_password')=='')
					{
						$ERRMSG = "Password should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
					}
					else
					{
						$ERRMSG = "";
						$this->isError= FALSE;
						$ERRCODE="success";
						
					}
					if($this->isError==FALSE && $request->method() == 'POST')
					{	
						
						$pass=$request->input('txt_password');
						$pinpass=$request->input('txt_password');
						$bankproof ="";
						$gstno ="";
						$signup_data=Helper::reg_data($request,$pass,$pinpass,'','','',$gstno,$bankproof);   
						$response= $this->enroll_repo->create($signup_data); 
					

						if(isset($response['ID'])){
							$srvs = DB::select("SELECT * FROM `m03_service_type`"); 
							
						/*	if($request->input('dd_role') == 7)
							{ */
								$service = DB::table("admin_service_charges")->where('SC_ID', 1)->first();
								if($service)
								{
									$transfer="DEDUCT";
									$fundtransfer_data=array(
									'proc'=>7,
									'to_user_id'=>$response['ID'],
									'from_user_id'=>0,
									'amount'=>$service->SC_AMOUNT,
									'collected_amount'=>$service->SC_AMOUNT, 
									'requesttype'=>1,
									'balfor'=>1,
									'transtype'=>18,
									'timelimit'=>100,
									'defaultstatus'=>1,
									'remark'=>"Retailer registration fee package name ".$service->BDT_LEDGER_NMAE."  charge ".$service->SC_AMOUNT." Rs" ,
									'collected_remark'=>"Retailer registration fee package name ".$service->BDT_LEDGER_NMAE."  charge ".$service->SC_AMOUNT." Rs" 
									);

									$fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);


									if($service->SERVICE_ID != '')
									{
										$srvs =  DB::table('m03_service_type')->whereIn('m03_sr_type_id', explode(",",$service->SERVICE_ID))->get();
											foreach($srvs as $value)
											{
														$arr = array(
														'm11_user_id' => $response['ID'],
														'm03_sr_type_id' =>$value->m03_sr_type_id,
														'tr02_ms_price' => $value->m03_service_surcharge,
														'tr02_ms_duration' => 1,
														'tr02_ms_buffer' => 1,
														'tr02_ms_status' => 1,
														'tr02_service_expiry_notify' => 1,
														'tr02_service_en_bb' => 1,
														'tr02_service_low_bal_notify' => 1,
														'tr02_service_lbn_bb' => 1
													);
													DB::table('tr02_merchant_service')->insert($arr);
											}
										$nsrvs =  DB::table('m03_service_type')->whereNotIn('m03_sr_type_id', explode(",",$service->SERVICE_ID))->get();
											
											foreach($nsrvs as $value)
											{
														$arr = array(
														'm11_user_id' => $response['ID'],
														'm03_sr_type_id' =>$value->m03_sr_type_id,
														'tr02_ms_price' => $value->m03_service_surcharge,
														'tr02_ms_duration' => 1,
														'tr02_ms_buffer' => 1,
														'tr02_ms_status' => 2,
														'tr02_service_expiry_notify' => 1,
														'tr02_service_en_bb' => 1,
														'tr02_service_low_bal_notify' => 1,
														'tr02_service_lbn_bb' => 1
													);
													DB::table('tr02_merchant_service')->insert($arr);
											}
									}
									else
									{
										$srvs =  DB::table('m03_service_type')->get();
											foreach($srvs as $value)
											{
														$arr = array(
														'm11_user_id' => $response['ID'],
														'm03_sr_type_id' =>$value->m03_sr_type_id,
														'tr02_ms_price' => $value->m03_service_surcharge,
														'tr02_ms_duration' => 1,
														'tr02_ms_buffer' => 1,
														'tr02_ms_status' => 2,
														'tr02_service_expiry_notify' => 1,
														'tr02_service_en_bb' => 1,
														'tr02_service_low_bal_notify' => 1,
														'tr02_service_lbn_bb' => 1
													);
													DB::table('tr02_merchant_service')->insert($arr);
											}
									}
									
								}
								else
								{
										$srvs =  DB::table('m03_service_type')->get();
											foreach($srvs as $value)
											{
														$arr = array(
														'm11_user_id' => $response['ID'],
														'm03_sr_type_id' =>$value->m03_sr_type_id,
														'tr02_ms_price' => $value->m03_service_surcharge,
														'tr02_ms_duration' => 1,
														'tr02_ms_buffer' => 1,
														'tr02_ms_status' => 1,
														'tr02_service_expiry_notify' => 1,
														'tr02_service_en_bb' => 1,
														'tr02_service_low_bal_notify' => 1,
														'tr02_service_lbn_bb' => 1
													);
													DB::table('tr02_merchant_service')->insert($arr);
											}
								}
								/*}*/
						}

						//for app refral inpor
						//DB::table('m76_app_refral')->update(['m11_new_user' => $response['ID']])->where('m76_device_id', $request->txt_device_id);

						$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
						if( $ERRCODE[0]->ERR_CODE=="success")
						{
										$uid = Helper::getuserdetail_ByMobileNo($request->input('txt_mobileno'));
										$user_massage  = $request->input('txt_username')." has been registered successfully. Email Id- ".$request->input('txt_email').". Id-".$request->input('txt_mobileno')." and Login Password-".$pass." and MPIN-".$pass." Website-".config('WEBSITE_NAME')."";
											// SMS SEND OR INSERT
											$sms_data['MOBILE_NO'] = $request->input('txt_mobileno');
											$sms_data['SUBJECT'] = 'Signup User in App';
											$sms_data['MESSAGE'] = $user_massage;
											$sms_data['TYPE'] = 1;
											$sms_data['SEND_BY'] = 2;
											$sms_data['SEND_BY_ID'] = $uid[0]->RegId;
											Helper::send_sms_or_log($sms_data);
											//SMS SEND END 

							return response()->json([
							'ERROR'=>$ERRCODE[0]->ERR_CODE,
							'MSG' =>$user_massage 
							]);
						}

							return response()->json([
							'ERROR'=>$ERRCODE[0]->ERR_CODE,
							'MSG' =>$ERRMSG[0]->ERR_MSG 
							]);

					}
					else
					{
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
			}
			else
			{
				$ERRMSG="THIS METHOD IS NOT ALLOWED";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}


/**
			* Method name	: Add Member
			* @description 	: Add Team
			* @param		: Request data  
			* @return		: Add user as Team array with response message
		*/
		public function add_member(Request $request)
		{
			if($request->method() == 'POST')
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$txt_cancelchq="";
				$txt_gstcrt ="";
				$username="";$email="";$mobileno="";$referral_code="";$password="";
				$username=$request->has('txt_username')?'1':'0' ;
				$email=$request->has('txt_email')?'1':'0' ;
				$mobileno=$request->has('txt_mobileno')?'1':'0' ;
				$referral_code=$request->has('txt_referralcode')?'1':'0' ;
				$password=$request->has('txt_password')?'1':'0' ;
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($username==0|| $email==0 || $mobileno==0 || $referral_code==0|| $password==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->get('txt_username')=='')
					{
						$ERRMSG = "Affiliate Id should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
						
					}
					else if($request->get('txt_mobileno')=='')
					{
						$ERRMSG = "Mobile no should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
						
					}
					else if(!$this->valid_phone_number($request->get('txt_mobileno')))
					{
						$ERRMSG = "Mobile no should be valid or numeric.";
						$this->isError= TRUE;
						$ERRCODE="error";
						
					}
					else if($request->get('txt_referralcode')=='')
					{
						$ERRMSG = "Referral Code should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
						
					}
					else if($request->input('txt_password')=='')
					{
						$ERRMSG = "Password should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="error";
					}
					else
					{
						$ERRMSG = "";
						$this->isError= FALSE;
						$ERRCODE="success";
						
					}
					if($this->isError==FALSE && $request->method() == 'POST')
					{	
						
						$pass=$request->input('txt_password');
						$pinpass=$request->input('txt_password');
						$signup_data=Helper::reg_data($request,$pass,$pinpass,'','','',$txt_gstcrt,$txt_cancelchq);  
						$result =  DB::select('CALL add_user(
					   :proc,
						:m11_user_id,
						:m11_user_code,
						:m22_affiliate_id,
						:m11_first_name,
						:m11_last_name,
						:m11_user_name,
						:m11_user_dob,
						:m11_user_gender,
						:m11_user_email,
						:m11_user_contactno,
						:m11_user_about_me,
						:m11_user_interested_in,
						:m16_gr_id,
						:m11_user_location,
						:m11_user_country,
						:m11_user_state,
						:m11_user_city,
						:m11_user_image,
						:m11_user_role,
						:m11_cancellation_policy,
						:m11_subcription,
						:m11_fb_id,
						:m11_gplus_id,
						:m11_user_status,
						:m11_user_callback,
						:m11_user_islogin,
						:m11_user_istraveling,
						:m11_user_notifications,
						:m11_user_emailalert,
						:m11_user_newsletter,
						:m11_user_language,
						:m11_user_activate_code,
						:m11_user_api_token,
						:m11_user_device_token,
						:m11_user_device_type,
						:m11_user_app_version,
						:m11_user_latitude,
						:m11_user_longitude,
						:m11_user_referral_code,
						:m11_user_parent_code,
						:m11_user_position,
						:m22_shop_company_name,
						:m22_shop_gstin,
						:m22_shop_gstin_copy,
						:m22_shop_bankproof_copy,
						:m19_uk_idproof_type,
						:m19_uk_id_img,
						:m19_uk_id_number,
						:tr04_login_pwd,
						:tr04_pin_pwd,
						@status_code,
						@status_msg,            
						@u_id,
						@u_code
						)',$signup_data);
						$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
						$u_id=DB::select('SELECT @u_id as ID');
						$u_code=DB::select('SELECT @u_code as CODE');


						if(isset($u_id[0]->ID)){
							$srvs = DB::select("SELECT * FROM `m03_service_type`"); 
							
						/*	if($request->input('dd_role') == 7)
							{ */
								$service = DB::table("admin_service_charges")->where('SC_ID', 1)->first();
								if($service)
								{
									$transfer="DEDUCT";
									$fundtransfer_data=array(
									'proc'=>7,
									'to_user_id'=>$u_id[0]->ID,
									'from_user_id'=>0,
									'amount'=>$service->SC_AMOUNT,
									'collected_amount'=>$service->SC_AMOUNT, 
									'requesttype'=>1,
									'balfor'=>1,
									'transtype'=>18,
									'timelimit'=>100,
									'defaultstatus'=>1,
									'remark'=>"Retailer registration fee package name ".$service->BDT_LEDGER_NMAE."  charge ".$service->SC_AMOUNT." Rs" ,
									'collected_remark'=>"Retailer registration fee package name ".$service->BDT_LEDGER_NMAE."  charge ".$service->SC_AMOUNT." Rs" 
									);

									$fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);


									if($service->SERVICE_ID != '')
									{
										$srvs =  DB::table('m03_service_type')->whereIn('m03_sr_type_id', explode(",",$service->SERVICE_ID))->get();
											foreach($srvs as $value)
											{
														$arr = array(
														'm11_user_id' => $u_id[0]->ID,
														'm03_sr_type_id' =>$value->m03_sr_type_id,
														'tr02_ms_price' => $value->m03_service_surcharge,
														'tr02_ms_duration' => 1,
														'tr02_ms_buffer' => 1,
														'tr02_ms_status' => 1,
														'tr02_service_expiry_notify' => 1,
														'tr02_service_en_bb' => 1,
														'tr02_service_low_bal_notify' => 1,
														'tr02_service_lbn_bb' => 1
													);
													DB::table('tr02_merchant_service')->insert($arr);
											}
										$nsrvs =  DB::table('m03_service_type')->whereNotIn('m03_sr_type_id', explode(",",$service->SERVICE_ID))->get();
											
											foreach($nsrvs as $value)
											{
														$arr = array(
														'm11_user_id' => $u_id[0]->ID,
														'm03_sr_type_id' =>$value->m03_sr_type_id,
														'tr02_ms_price' => $value->m03_service_surcharge,
														'tr02_ms_duration' => 1,
														'tr02_ms_buffer' => 1,
														'tr02_ms_status' => 2,
														'tr02_service_expiry_notify' => 1,
														'tr02_service_en_bb' => 1,
														'tr02_service_low_bal_notify' => 1,
														'tr02_service_lbn_bb' => 1
													);
													DB::table('tr02_merchant_service')->insert($arr);
											}
									}
									else
									{
										$srvs =  DB::table('m03_service_type')->get();
											foreach($srvs as $value)
											{
														$arr = array(
														'm11_user_id' => $u_id[0]->ID,
														'm03_sr_type_id' =>$value->m03_sr_type_id,
														'tr02_ms_price' => $value->m03_service_surcharge,
														'tr02_ms_duration' => 1,
														'tr02_ms_buffer' => 1,
														'tr02_ms_status' => 2,
														'tr02_service_expiry_notify' => 1,
														'tr02_service_en_bb' => 1,
														'tr02_service_low_bal_notify' => 1,
														'tr02_service_lbn_bb' => 1
													);
													DB::table('tr02_merchant_service')->insert($arr);
											}
									}
									
								}
								else
								{
										$srvs =  DB::table('m03_service_type')->get();
											foreach($srvs as $value)
											{
														$arr = array(
														'm11_user_id' => $u_id[0]->ID,
														'm03_sr_type_id' =>$value->m03_sr_type_id,
														'tr02_ms_price' => $value->m03_service_surcharge,
														'tr02_ms_duration' => 1,
														'tr02_ms_buffer' => 1,
														'tr02_ms_status' => 1,
														'tr02_service_expiry_notify' => 1,
														'tr02_service_en_bb' => 1,
														'tr02_service_low_bal_notify' => 1,
														'tr02_service_lbn_bb' => 1
													);
													DB::table('tr02_merchant_service')->insert($arr);
											}
								}
							/* } */
						}



						if( $ERRCODE[0]->ERR_CODE=="success")
						{

						$user_massage  = $request->input('txt_username')." has been registered successfully. Email Id- ".$request->input('txt_email').". Id-".$request->input('txt_mobileno')." and Login Password-".$pass." and MPIN-".$pass." Website-".config('WEBSITE_NAME')."";

											// SMS SEND OR INSERT
											$sms_data['MOBILE_NO'] = $request->input('txt_mobileno');
											$sms_data['SUBJECT'] = 'Add Member in App';
											$sms_data['MESSAGE'] = $user_massage;
											$sms_data['TYPE'] = 1;
											$sms_data['SEND_BY'] = 2;
											$sms_data['SEND_BY_ID'] = $login_detail[0]->RegId;
											Helper::send_sms_or_log($sms_data);
											//SMS SEND END 

							return response()->json([
							'ERROR'=>$ERRCODE[0]->ERR_CODE,
							'MSG' =>$user_massage 
							]);
						}
						else
						{
							return response()->json([
							'ERROR'=>$ERRCODE[0]->ERR_CODE,
							'MSG' =>$ERRMSG[0]->ERR_MSG 
							]);
						}
					}
					else
					{
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG="THIS METHOD IS NOT ALLOWED";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}


/**
			* Method name	: Operator
			* @description 	: Used to Get Operator 
			* @param		: Request data  
			* @return		: Get Telecom Operator data array with response message
		*/
		public function operator(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="GET")
			{	
				$status=$request->get('status');
				$serviceid=$request->get('service_id');
				if($serviceid=='')
				{
					$ERRMSG = "Service Id should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					
				}
				else if($status=='')
				{
					$ERRMSG = "Status should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					
				}
				else
				{
					if($serviceid==-1)
					{
					  $operator = DB::select("SELECT * FROM `telecom_brand` WHERE BrandStatus='".$status."'");
					}
					else if ($serviceid==-2) 
					{
						$operator = DB::select("SELECT * FROM `telecom_brand` WHERE `ServiceTypeId` IN(1,3)  AND BrandStatus='".$status."' ORDER BY ServiceTypeId ");
					}
					else 
					{
					  $operator = DB::select("SELECT * FROM `telecom_brand` WHERE `ServiceTypeId`=".$serviceid." AND BrandStatus=".$status."");
					}
					if($operator)
					{
							$ERRMSG = "OPERATER DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'OPERATOR'=>$operator
							]);
					}
					else
					{
						$ERRMSG = "OPERATER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
		}





					/**
			* Method name	: REfral NAME OR NUMBER
			* @description 	: Used to Get ID,NAME Data
			* @param		: Request data  
			* @return		: Get Get ID,NAME Data array with response message
		*/
		public function refral_data(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				
				$token='';
				$device_id='';
			
				
				$username="";$email="";$dob="";$gender="";
				$username=$request->has('txt_username')?'1':'0' ;
				
		
				if($this->isError==FALSE)
				{
					if($username==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_username')=='')
					{
						$ERRMSG = "Mobile no should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$user = Helper::get_userid($request->input('txt_username'));
						if(empty($user))
						{
							$ERRMSG = "Mobile no not registered with us.";
							$this->isError = TRUE;
							$ERRCODE="warning";
						}
						else
						{
							$ERRMSG = "";
							$this->isError=FALSE;
							$ERRCODE="success";
						}
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$id=$request->input('txt_username');
					$query= Helper::getuserdetail_ByCode($id);	// Get Details From Admin_Helper

					if(count($query) > 0)
					{
						$name = $query[0]->MemberName;
						$role = $query[0]->MemberRole;
					}
					else
					{
						$name = '';
						$role = '';
					}
					$ERRMSG="USER'S DATA WITH BALANCE!";
					$ERRCODE='success';	
					return response()->json([
					'USERDATA'=>$name,
					'USERROLE'=>$role,
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}




			/**
			* Method name	: MEMBER_DATABY NAME OR NUMBER
			* @description 	: Used to Get ID,NAME,BALANCE Data
			* @param		: Request data  
			* @return		: Get Get ID,NAME,BALANCE Data array with response message
		*/
		public function member_data(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$username="";$email="";$dob="";$gender="";
				$username=$request->has('txt_username')?'1':'0' ;
				
				/*if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}*/
				if($this->isError==FALSE)
				{
					if($username==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_username')=='')
					{
						$ERRMSG = "Mobile no should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(!$this->valid_phone_number($request->input('txt_username')))
					{
							$ERRMSG = "Mobile no should be valid.";
							$this->isError= TRUE;
							$ERRCODE="warning";
							
					}
					else if(strlen($request->input('txt_username'))!=10)
					{
						$ERRMSG = "Mobile  no should be equal to 10 digit.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$user = Helper::get_userid($request->input('txt_username'));
						if(empty($user))
						{
							$ERRMSG = "Mobile no not registered with us.";
							$this->isError = TRUE;
							$ERRCODE="warning";
						}
						else
						{
							$ERRMSG = "";
							$this->isError=FALSE;
							$ERRCODE="success";
						}
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$id=$request->input('txt_username');
					$query['name']= Helper::get_user_name($id);	// Get Details From Admin_Helper
					$query['id']= Helper::get_userid($id);
					$userbal=Helper::get_bal(Helper::get_userid($id),1);
					$userbal1=Helper::get_bal(Helper::get_userid($id),2);
					$userbal2=Helper::get_bal(Helper::get_userid($id),3);
					$query['bal']=$userbal[0]->bal;
					$query['ubal']=$userbal1[0]->bal;
					$query['abal']=$userbal2[0]->bal;
					
					$ERRMSG="USER'S DATA WITH BALANCE!";
					$ERRCODE='success';	
					return response()->json([
					'USERDATA'=>$query,
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}
		/**
			* Method name	: refresh_data
			* @description 	: Used to Get Refresh Data
			* @param		: Request data  
			* @return		: Get Refresh Data array with response message
		*/
		public function refresh_data(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;	
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `refresh_details` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'USERDATA'=>$login_detail[0]
							]);
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
		}

	/**
			* Method name	: Profile
			* @description 	: Used to Login App 
			* @param		: Request data  
			* @return		: Get Login data array with response message
		*/
		public function profile(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;	
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$hit_data=array(
									'proc'=>3,
									'user_id'=>$login_detail[0]->RegId,
									'rec_fromdate'=>NOW(),
									'rec_todate'=>NOW()
								);
							$today_hit = $this->rech_reprt_repo->todayHitStatus($hit_data);

							$hit_data2=array(
									'proc'=>3,
									'user_id'=>$login_detail[0]->RegId,
									'rec_fromdate'=>date('Y-m-d',strtotime("-1 days")),
									'rec_todate'=>date('Y-m-d',strtotime("-1 days"))
								);
							$today_hit2 = $this->rech_reprt_repo->todayHitStatus($hit_data2);


							$hit_data3=array(
								'proc'=>3,
								'user_id'=>$login_detail[0]->RegId,
								'rec_fromdate'=>date("Y-m-d", strtotime("this week")),
								'rec_todate'=>NOW()
							);
						$today_hit3 = $this->rech_reprt_repo->todayHitStatus($hit_data3);

							$hit_data4=array(
								'proc'=>3,
								'user_id'=>$login_detail[0]->RegId,
								'rec_fromdate'=>date("Y-m-d", strtotime("last week")),
								'rec_todate'=>date("Y-m-d", strtotime("sunday last week"))
							);
						$today_hit4 = $this->rech_reprt_repo->todayHitStatus($hit_data4);
						$UserService = DB::select("SELECT `MS_SERVICE_ID`,`MS_SERVICE_NAME`,`MS_SERVICE_NAME`,`MS_STATUS` FROM `user_services` WHERE `USER_ID`=".$login_detail[0]->RegId." ");

							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'USERDATA'=>$login_detail[0],
							'TODAYHIT'=>$today_hit[0]->SUCCESS+0,
							'YESTERDAYHIT'=>$today_hit2[0]->SUCCESS+0,
							'THISWEEKHIT'=>$today_hit3[0]->SUCCESS+0,
							'LASTWEEKHIT'=>$today_hit4[0]->SUCCESS+0,
							'SERVICE'=>$UserService,
							'LAT'=>$request->input('lat'),
							'LANG'=>$request->input('lng')
							]);
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
		}
	


		public function update_userprofile(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$username="";$email="";$dob="";$gender="";
				$username=$request->has('username')?'1':'0' ;
				$email=$request->has('email')?'1':'0' ;
				$dob=$request->has('dob')?'1':'0' ;
				$gender=$request->has('gender')?'1':'0' ;
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($username==0 || $email==0 || $dob==0 || $gender==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('username')=='')
					{
						$ERRMSG = "Member user name should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('email')=='')
					{
						$ERRMSG = "Member email address should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dob')=='')
					{
						$ERRMSG = "Member Date of birth should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('gender')=='' || $request->input('gender')=='-1')
					{
						$ERRMSG = "Member Gender be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$name=explode(" " ,$request->input('username'));
					$user_name=$request->input('username');
					$USER=$login_detail[0]->RegId;
					$user_profile=DB::select("UPDATE m11_user SET m11_first_name='".$name[0]."',
					m11_last_name='".$name[1]."',
					m11_user_name='".$request->input('username')."',
					m11_user_dob='".$request->input('dob')."',
					m11_user_email='".$request->input('email')."',
					m11_user_gender='".$request->input('gender')."' 
					WHERE m11_user_contactno =".$login_detail[0]->MemberContactNo." 
					AND m11_user_id=". $login_detail[0]->RegId." 
					AND m11_user_status='ACTIVE'");
					$mobileno_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('m11_user','','$user_name','$USER','USER S PROFILE HAS BEEN CHANGED SUCCESSFULLY!')");
					
					$ERRMSG="USER'S PROFILE HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}
		
		public function update_password(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}

				$new_password="";$old_password="";$new_cpassword="";
				$old_password=$request->has('old_password')?'1':'0' ;
				$new_password=$request->has('new_password')?'1':'0' ;
				$new_cpassword=$request->has('new_cpassword')?'1':'0' ;
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($old_password==0 || $new_password==0 || $new_cpassword==0 )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('old_password')=='')
					{
						$ERRMSG = "Old password should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('old_password')<6))
					{
						$ERRMSG = "Old password length would be greater then 6 or equal 6";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('new_password')=='')
					{
						$ERRMSG = "New password should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('new_password')<6))
					{
						$ERRMSG = "New password length would be greater then 6 or equal 6";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('new_cpassword')=='')
					{
						$ERRMSG = "New Confirm password should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('new_cpassword')<6))
					{
						$ERRMSG = "New Confirm password length would be greater then 6 or equal 6";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('new_password')!=$request->input('new_cpassword'))
					{
						$ERRMSG = "Password does not match with confirm password.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					$hashpass = $login_detail[0]->LoginPassword;
					$pass =$request->input('old_password');

					if(Hash::check($request->input('old_password'), $login_detail[0]->LoginPassword))
					{
					$user_profile=DB::select("UPDATE tr04_login SET tr04_login_pwd='".Hash::make($request->input('new_password'))."' WHERE m11_user_contactno ='".$login_detail[0]->RegCode."'");
						$this->apiToken = uniqid(base64_encode(Str::random(30)));
					$user_profile1=DB::update("UPDATE m11_user SET m11_user_api_token='".$this->apiToken."' WHERE m11_user_contactno =".$login_detail[0]->MemberContactNo." AND m11_user_status='ACTIVE'");
					$mobileno_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('tr04_login','','tr04_login_pwd','$USER','USER S PASSWORD HAS BEEN CHANGED SUCCESSFULLY!')");
					
					$ERRMSG="USER PASSWORD HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
					}
					else
					{
						$ERRMSG="USER OLD PASSWORD NOT MATCHED!";
						$ERRCODE='success';	
					}
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}

		public function get_userkyc(Request $request)
		{
			if($request->method() == 'GET')
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
		        
		        if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($_SERVER['REQUEST_METHOD']=="GET" && $this->isError==FALSE)
				{
				    $USER=$login_detail[0]->RegId;
				    $get_useralldetail = Helper::get_useralldetail($USER);
				    $ERRMSG="USER'S KYC DETAILS HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG ,
					'KYC_DATA'=>$get_useralldetail[0]
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}

	public function get_usershop(Request $request)
		{
			if($request->method() == 'GET')
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
		        
		        if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($_SERVER['REQUEST_METHOD']=="GET" && $this->isError==FALSE)
				{
				    $USER=$login_detail[0]->RegId;
				    $get_useralldetail = Helper::get_usershopdetail($USER);
				    $ERRMSG="USER'S SHOP DETAILS HAS BEEN GET SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG ,
					'SHOP_DATA'=>$get_useralldetail[0]
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}


		public function update_userkyc(Request $request)
		{
			if($request->method() == 'POST')
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				
				$dd_quali="";$txt_pancard="";$txt_aadhar="";$txt_address="";$dd_idprooftype="";
			
				$txt_pancard=$request->has('txt_pancard')?'1':'0' ;
				$txt_aadhar=$request->has('txt_aadhar')?'1':'0' ;
				$txt_address=$request->has('txt_address')?'1':'0' ;
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					$txt_yourphoto ="";
					$txt_idproof ="";
					$txt_addressproof = "";
					if($txt_pancard==0 || $txt_aadhar==0 || $txt_address==0  )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_pancard')=='')
					{
						$ERRMSG = "Member pancard should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_aadhar')=='')
					{
						$ERRMSG = "Member aadhar should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_address')=='')
					{
						$ERRMSG = "Member address should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					if($request->file('txt_userimg')!= '')
					{
						$image = $request->file('txt_userimg');
						$name1 = $login_detail[0]->RegCode."_PHOTO_app_".time().'.'.$image->getClientOriginalExtension();
						$destinationPath = public_path('/images/USER_PHOTO/');
						$FileType = array('jpeg','png','jpg');
						if(in_array($image->getClientOriginalExtension(), $FileType)) {
							$image->move($destinationPath, $name1);
						}
						else{
							$request_data=json_encode($request->all());
							$file_type=$image->getClientOriginalName();
							$user_id=$login_detail[0]->RegId;
							$server_info=json_encode(request()->server());
							$user_info=json_encode($login_detail);
							$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
							$ERRMSG="IMAGE TYPE NOT SUPPORTED!";
							$ERRCODE='error';	
							return response()->json([
								'ERROR'=>$ERRCODE,
								'MSG' =>$ERRMSG 
							]);
						}
						$txt_yourphoto =  $name1;
					}
					else
					{
						$txt_yourphoto = trim($request->input('txt_userimghd'));
					}
					if($request->file('txt_aadharfrontimg')!= '')
					{
						$image = $request->file('txt_aadharfrontimg');
						$name1 = $login_detail[0]->RegCode."_AADHARFRONT_app_".time().'.'.$image->getClientOriginalExtension();
						$destinationPath = public_path('/images/USER_ADDRESSPROOF/');
						$FileType = array('jpeg','png','jpg');
						if(in_array($image->getClientOriginalExtension(), $FileType)) {
							$image->move($destinationPath, $name1);
						}
						else{
							$request_data=json_encode($request->all());
							$file_type=$image->getClientOriginalName();
							$user_id=$login_detail[0]->RegId;
							$server_info=json_encode(request()->server());
							$user_info=json_encode($login_detail);
							$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
							$ERRMSG="IMAGE TYPE NOT SUPPORTED!";
							$ERRCODE='error';	
							return response()->json([
								'ERROR'=>$ERRCODE,
								'MSG' =>$ERRMSG 
							]);
						}
						$txt_aadharfrontimg =  $name1;
					}
					else
					{
						$txt_aadharfrontimg = trim($request->input('txt_aadharfrontimghd'));
					}
					if($request->file('txt_aadharbackimg')!= '')
					{
						$image = $request->file('txt_aadharbackimg');
						$name1 = $login_detail[0]->RegCode."_AADHARBACK_app_".time().'.'.$image->getClientOriginalExtension();
						$destinationPath = public_path('/images/USER_ADDRESSPROOF/');
						$FileType = array('jpeg','png','jpg');
						if(in_array($image->getClientOriginalExtension(), $FileType)) {
							$image->move($destinationPath, $name1);
						}
						else{
							$request_data=json_encode($request->all());
							$file_type=$image->getClientOriginalName();
							$user_id=$login_detail[0]->RegId;
							$server_info=json_encode(request()->server());
							$user_info=json_encode($login_detail);
							$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
							$ERRMSG="IMAGE TYPE NOT SUPPORTED!";
							$ERRCODE='error';	
							return response()->json([
								'ERROR'=>$ERRCODE,
								'MSG' =>$ERRMSG 
							]);
						}
						$txt_aadharbackimg =  $name1;
					}
					else
					{
						$txt_aadharbackimg = trim($request->input('txt_aadharbackimghd'));
					}
					if($request->file('txt_panimg')!= '')
					{
						$image = $request->file('txt_panimg');
						$name1 = $login_detail[0]->RegCode."_PAN_app_".time().'.'.$image->getClientOriginalExtension();
						$destinationPath = public_path('/images/USER_IDPROOF/');
						$FileType = array('jpeg','png','jpg');
						if(in_array($image->getClientOriginalExtension(), $FileType)) {
							$image->move($destinationPath, $name1);
						}
						else{
							$request_data=json_encode($request->all());
							$file_type=$image->getClientOriginalName();
							$user_id=$login_detail[0]->RegId;
							$server_info=json_encode(request()->server());
							$user_info=json_encode($login_detail);
							$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
							$ERRMSG="IMAGE TYPE NOT SUPPORTED!";
							$ERRCODE='error';	
							return response()->json([
								'ERROR'=>$ERRCODE,
								'MSG' =>$ERRMSG 
							]);
						}
						$txt_panimg =  $name1;
					}
					else
					{
						$txt_panimg = trim($request->input('txt_panimghd'));
					}
					$USER=$login_detail[0]->RegId;    
					$CONTACTNO=$login_detail[0]->MemberContactNo;
					$pancard=$request->input('txt_pancard');
				
					$arr = array(
					'm19_uk_user_photo'=>$txt_yourphoto,
					'm19_uk_idproof_type'=>4,
					'm19_uk_uniqueid_num'=>$request->input('txt_pancard'),
					'm19_uk_idproofdoc'=>$txt_panimg,
					'm19_uk_aadhar_num'=>$request->input('txt_aadhar'),
					'm19_uk_aadhar_front'=>$txt_aadharfrontimg,
					'm19_uk_aadhar_back'=>$txt_aadharbackimg,
					'm19_uk_address'=>$request->input('txt_address'),
					'm19_uk_addressproof_type'=>1,
					'm19_uk_qualification'=>$request->input('dd_quali'),
					'm19_uk_addressproof'=>$txt_aadharfrontimg
					
					);
					DB::table('m19_user_kyc')->where('m11_user_id', $USER)->update($arr);
					$user_profile=DB::select("UPDATE m11_user SET m11_user_image='".$txt_yourphoto."' WHERE m11_user_contactno =".$CONTACTNO." and m11_user_id=". $USER." AND m11_user_status='ACTIVE'");
					$kyc_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('m11_user','','$pancard','$USER','USER S KYC HAS BEEN CHANGED SUCCESSFULLY!')");		
					$ERRMSG="USER'S KYC HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}


       public function update_userbankdetails(Request $request)
		{
			if($request->method() == 'POST')
			{

				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$txt_nameatbank="";$txt_bankname="";$txt_cbsacno="";$txt_bankbranch="";$txt_bankifsccode="";
				
				$txt_nameatbank=$request->has('txt_nameatbank')?'1':'0' ;
				$txt_bankname=$request->has('txt_bankname')?'1':'0' ;
				$txt_cbsacno=$request->has('txt_cbsacno')?'1':'0' ;
				$txt_bankbranch=$request->has('txt_bankbranch')?'1':'0' ;
				$txt_bankifsccode=$request->has('txt_bankifsccode')?'1':'0' ;
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					
					$txt_cancelchq = "";
					if($txt_nameatbank==0 || $txt_bankname==0 || $txt_cbsacno==0 || $txt_bankbranch==0 || $txt_bankifsccode ==0 )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_nameatbank')=='' )
					{
						$ERRMSG = "Member Name at Bank should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_bankname')=='')
					{
						$ERRMSG = "Member Bank Name should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_cbsacno')=='')
					{
						$ERRMSG = "Member Bank no Account should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_bankbranch')=='')
					{
						$ERRMSG = "Member Bank Branch should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_bankifsccode')=='')
					{
						$ERRMSG = "Member Bank IFSCode should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{

					if($request->file('txt_cancelchq')!= '')
					{
						$image = $request->file('txt_cancelchq');
						$name1 = $login_detail[0]->RegCode."_CANCELCHEQUE_app_".time().'.'.$image->getClientOriginalExtension();
						$destinationPath = public_path('/images/CANCEL_CHEQUE/');
						$FileType = array('jpeg','png','jpg');
						if(in_array($image->getClientOriginalExtension(), $FileType)) {
							$image->move($destinationPath, $name1);
						}
						else{
							$request_data=json_encode($request->all());
							$file_type=$image->getClientOriginalName();
							$user_id=$login_detail[0]->RegId;
							$server_info=json_encode(request()->server());
							$user_info=json_encode($login_detail);
							$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
							$ERRMSG="IMAGE TYPE NOT SUPPORTED!";
							$ERRCODE='error';	
							return response()->json([
								'ERROR'=>$ERRCODE,
								'MSG' =>$ERRMSG 
							]);
						}
						$txt_cancelchq=$name1;
					}
					else
					{
						$txt_cancelchq = trim($request->input('txt_cancelchqhd'));
					}

					$ACCOUNTNO=$request->input('txt_cbsacno');

					$USER=$login_detail[0]->RegId;

					$arr = array(
					'm23_user_nameat_bank'=>$request->input('txt_nameatbank'),
					'm23_user_cbsacno' =>$request->input('txt_cbsacno'),
					'm01_bank_name'=>$request->input('txt_bankname'),
					'm23_user_branch'=>$request->input('txt_bankbranch'),
					'm23_user_ifscode' =>$request->input('txt_bankifsccode'),
					'm23_usercancelechq'=>$txt_cancelchq
					);
			
					$response = Helper::cashfreePayoutAuthorize();

					if(isset($response->data->token))
					{
						$ben = 'MAD'.$ACCOUNTNO;

						$data = [	
									"beneId" =>  $ben,
									"name"=> $request->input('txt_nameatbank'), 
									"email" => $login_detail[0]->MemberEmail, 
									"phone" => $login_detail[0]->MemberContactNo, 
									"bankAccount" => $ACCOUNTNO, 
									"ifsc" => $request->input('txt_bankifsccode'), 
									"address1"=> $request->input('txt_bankbranch'),
									"city"=> $login_detail[0]->MemberCity,
									"state"=> $login_detail[0]->MemberState,
									"pincode"=> $login_detail[0]->MemberPostalCode
								];
								
						$Token = $response->data->token;
						$url = "https://payout-api.cashfree.com/payout/v1/addBeneficiary";
						$responses = Helper::cashfreePayoutVerifyOrder($url, $data, $Token);
						$rsdata = json_decode($responses);
						
						$arrdata = array(
							'tr11_ar_tblnm' => 'm11_user',
							'tr11_ar_old_value' => 'NA',
							'tr11_ar_new_value' => $ben,
							'tr11_ar_uid' => $USER,
							'tr11_ar_description' => $rsdata->message,
							'tr11_updated_by' => 2,
							'tr11_updated_by_id' =>  $login_detail[0]->RegId
							);

						$this->log_repo->create($arrdata);

						$bene_data = $this->profile_repo->Getbeneficiary($ben);

						if(!$bene_data)
						{
							$this->profile_repo->Insertbeneficiary(['m11_user_id' => $login_detail[0]->RegId,'m79_bene_beneficiary_id' => $ben]);
						}
					}

					DB::table('m23_user_bankdetails')->where('m11_user_id', $USER)->update($arr);
					$bank_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('m11_user','','$ACCOUNTNO','$USER','USER S BANK DETAILS HAS BEEN CHANGED SUCCESSFULLY!')");		
					$ERRMSG="USER'S BANK DETAILS HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}





		public function update_usershopdetails(Request $request)
		{
			if($request->method() == 'POST')
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				
				$txt_shopname="";$dd_shoptype="";$dd_localitytype="";$dd_population="";$txt_gstno="";$dd_state="";$dd_city="";$txt_block="";$txt_mohhalla="";$txt_landmark="";$txt_pincode="";$txt_currentlocation="";$txt_shopaddress="";
				
				$txt_shopname=$request->has('txt_shopname')?'1':'0';
				$dd_shoptype=$request->has('dd_shoptype')?'1':'0';
				$dd_localitytype=$request->has('dd_localitytype')?'1':'0';
				$dd_population=$request->has('dd_population')?'1':'0';
				$txt_gstno=$request->has('txt_gstno')?'1':'0';
				$dd_state=$request->has('dd_state')?'1':'0';
				$dd_city=$request->has('dd_city')?'1':'0';
				$txt_block=$request->has('txt_block')?'1':'0';
				$txt_mohhalla=$request->has('txt_mohhalla')?'1':'0';
				$txt_landmark=$request->has('txt_landmark')?'1':'0';
				$txt_pincode=$request->has('txt_pincode')?'1':'0';
				$txt_currentlocation=$request->has('txt_currentlocation')?'1':'0';
				$txt_shopaddress=$request->has('txt_shopaddress')?'1':'0';
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					
					$txt_shopimg = "";$txt_gstcrt = "";
					if($txt_shopname==0 || $dd_shoptype==0 || $dd_localitytype==0 || $dd_population==0 || $txt_gstno ==0 || $dd_state ==0 || $dd_city ==0 || $txt_block==0 || $txt_mohhalla==0 || $txt_landmark==0 || $txt_pincode==0 || $txt_currentlocation==0 || $txt_shopaddress==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_shopname')=='' )
					{
						$ERRMSG = "Shop Name at Bank should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_shoptype')=='' && $request->input('dd_shoptype')=='-1')
					{
						$ERRMSG = "Shop Type should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_localitytype')==''&& $request->input('dd_localitytype')=='-1')
					{
						$ERRMSG = "Shop Locality should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_population')=='' && $request->input('dd_population')=='-1')
					{
						$ERRMSG = "Shop Area Population should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_gstno')=='')
					{
						$ERRMSG = "GST No should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_state')=='' )
					{
						$ERRMSG = "State should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_city')=='' )
					{
						$ERRMSG = "City should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_shopaddress')=='' )
					{
						$ERRMSG = "Shop Address should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_block')=='')
					{
						$ERRMSG = "Block should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_mohhalla')=='')
					{
						$ERRMSG = "Mohhalla should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_landmark')=='')
					{
						$ERRMSG = "Landmark should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_pincode')=='')
					{
						$ERRMSG = "Pincode should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_currentlocation')=='')
					{
						$ERRMSG = "Cuurent Location should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
			        if($request->file('txt_shopimg')!= '')
					{
						$image = $request->file('txt_shopimg');
						$name1 = $login_detail[0]->RegCode."_SHOP_app_".time().'.'.$image->getClientOriginalExtension();
						$destinationPath = public_path('/images/SHOP_IMAGE/');
						$FileType = array('jpeg','png','jpg');
						if(in_array($image->getClientOriginalExtension(), $FileType)) {
							$image->move($destinationPath, $name1);
						}
						else{
							$request_data=json_encode($request->all());
							$file_type=$image->getClientOriginalName();
							$user_id=$login_detail[0]->RegId;
							$server_info=json_encode(request()->server());
							$user_info=json_encode($login_detail);
							$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
							$ERRMSG="IMAGE TYPE NOT SUPPORTED!";
							$ERRCODE='error';	
							return response()->json([
								'ERROR'=>$ERRCODE,
								'MSG' =>$ERRMSG 
							]);
						}
						$txt_shopimg=$name1;
					}
					else
					{
						$txt_shopimg = trim($request->input('txt_shopimghd'));
					}
					if($request->file('txt_gstcrt')!= '')
					{
						$image = $request->file('txt_gstcrt');
						$name1 = $login_detail[0]->RegCode."_GST_app_".time().'.'.$image->getClientOriginalExtension();
						$destinationPath = public_path('/images/GST_CERTIFICATE/');
						$FileType = array('jpeg','png','jpg');
						if(in_array($image->getClientOriginalExtension(), $FileType)) {
							$image->move($destinationPath, $name1);
						}
						else{
							$request_data=json_encode($request->all());
							$file_type=$image->getClientOriginalName();
							$user_id=$login_detail[0]->RegId;
							$server_info=json_encode(request()->server());
							$user_info=json_encode($login_detail);
							$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
							$ERRMSG="IMAGE TYPE NOT SUPPORTED!";
							$ERRCODE='error';	
							return response()->json([
								'ERROR'=>$ERRCODE,
								'MSG' =>$ERRMSG 
							]);
						}
						$txt_gstcrt=$name1;
					}
					else
					{
						$txt_gstcrt = trim($request->input('txt_gstcrthd'));
					}
					$GSTNO=$request->input('txt_gstno');
					$USER=$login_detail[0]->RegId; 
					$arr = array(
					'm22_shop_type'=>$request->input('dd_shoptype'),
					'm22_shop_location_type'=>$request->input('dd_localitytype'),
					'm22_shop_near_popullation' =>$request->input('dd_population'),
					'm22_seller_name'=>$login_detail[0]->MemberName,
					'm22_shop_company_name'=>$request->input('txt_shopname'),
					'm22_shop_company_display_name'=>$request->input('txt_shopname'),
					'm22_shop_mobile_no'=>$login_detail[0]->MemberContactNo,
					'm22_shop_primary_email'=>$login_detail[0]->MemberEmail,
					'm22_seller_image'=>$request->input('USER_IMG'),
					'm22_shop_image'=>$txt_shopimg,
					'm22_shop_state'=>$request->input('dd_state'),
					'm22_shop_district'=>$request->input('txt_nameatbank'),
					'm22_shop_shipping_address'=>$request->input('txt_shopaddress'),
					'm22_shop_city'=>$request->input('dd_city'),
					'm22_shop_address_block'=>$request->input('txt_block'),
					'm22_shop_address_mohhalla'=>$request->input('txt_mohhalla'),
					'm22_shop_address_landmark'=>$request->input('txt_landmark'),
					'm22_shop_address_location'=>$request->input('txt_currentlocation'),
					'm22_shop_pincode'=>$request->input('txt_pincode'),
					'm22_shop_gstin'=>$request->input('txt_gstno'),
					'm22_shop_gstin_copy'=>$txt_gstcrt
					);
					DB::table('m22_shop_info')->where('m11_user_id', $USER)->update($arr);
					$bank_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('m11_user','','$GSTNO','$USER','USER S SHOP DETAILS HAS BEEN CHANGED SUCCESSFULLY!')");		
					$ERRMSG="USER'S SHOP DETAILS HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}


		public function show_ladger(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
			

				$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
				$ladegerstatus="-1";$descrip="";
				
				$fromdate=$request->has('fromdate')?'1':'0' ;
				$todate=$request->has('todate')?'1':'0' ;
				$transid=$request->has('transid')?'1':'0' ;
				$noofrecords=$request->has('noofrecords')?'1':'0' ;
				$account=$request->has('account')?'1':'0' ;
				$ladegerstatus=$request->has('ladegerstatus')?'1':'0' ;
				$descrip=$request->has('descrip')?'1':'0' ;
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($fromdate==0 || $todate==0 || $transid==0 || $noofrecords==0 || $account==0 || $ladegerstatus==0 || $descrip==0  )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('fromdate')=='')
					{
						$ERRMSG = "Form date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('todate')=='')
					{
						$ERRMSG = "To date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('noofrecords')=='')
					{
						$ERRMSG = "No of records should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('ladegerstatus')=='')
					{
						$ERRMSG = "Ledger type should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('descrip')=='')
					{
						$ERRMSG = "Description should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					
					
					$ladger=array(
							'proc'=>'2',
							'account'=>$request->input('account'),
							'transid'=>$request->input('transid'),
							'userid'=>$login_detail[0]->RegId,
							'fromdate'=>date('Y-m-d',strtotime($request->input('fromdate'))),
							'todate'=>date('Y-m-d',strtotime($request->input('todate'))),
							'noofrecords'=>$request->input('noofrecords'),
							'ladegerstatus'=>$request->input('ladegerstatus'),
							'descrip'=>$request->input('descrip'),
							);
							$ladger_report=DB::select('CALL ledger(				
							:proc,
							:account,
							:transid,
							:userid,
							:fromdate,
							:todate,
							:noofrecords,
							:ladegerstatus,
							:descrip,
							@msg
							)',$ladger);
					$ERRMSG="USER LADGER REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'LADGER_DATA'=>$ladger_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}

		/*public function cashback_income(Request $request)
        {
             if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
			

				$fromdate="";$todate="";$queery="";
				
				$fromdate=$request->has('fromdate')?'1':'0' ;
				$todate=$request->has('todate')?'1':'0' ;
				
			
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($fromdate==0 || $todate==0 )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('fromdate')=='')
					{
						$ERRMSG = "Form date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('todate')=='')
					{
						$ERRMSG = "To date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					
					$start = date('Y-m-d',strtotime($request->input('fromdate')));
					$end = date('Y-m-d',strtotime($request->input('todate')));
					if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
					{
						$queery = $queery."DATE_FORMAT(`CASHBACK_PAYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
					}
					$queery = $queery."`USER_ID` = $USER  AND ";
					$queery = $queery." CASHBACK_STATUS=2 LIMIT 1000";

					$salary_report = $this->closing_repo->getCashbackDates($queery);
					$ERRMSG="USER CASHBACK REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'CAHBACK_DATA'=>$salary_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}*/

		public function cashback_income(Request $request)
        {
             if($_SERVER['REQUEST_METHOD']=="POST")
			{
			
				$fromdate="";$todate="";$queery="";$txt_bscaddress="";
				$recstatus="-1";$descrip="1";
				$txt_bscaddress=$request->has('txt_bscaddress')?'1':'0' ;
				
				
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					
				    if($request->input('txt_bscaddress')=="")
					{
						$ERRMSG = "wallet address should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
						$contactno=$request->input('txt_bscaddress');
					$user = Helper::get_userid_by_userbscaddress($contactno);
					$userwds =Helper::get_userwds_by_userbscaddress($contactno);
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$user = Helper::get_userid_by_userbscaddress($contactno);
					$userwds =Helper::get_userwds_by_userbscaddress($contactno);
					$start = date('Y-m-d',strtotime('2025-01-01'));
					$end = date('Y-m-d');
					
					if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
					{
						$queery = $queery."DATE_FORMAT(`CASHBACK_PAYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
					}
					$queery = $queery."`USER_ID` = $user  AND ";
					$queery = $queery." CASHBACK_STATUS=2 LIMIT 1000";

					$salary_report = $this->closing_repo->getCashbackDates($queery);
					$ERRMSG="USER CASHBACK REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'CAHBACK_DATA'=>$salary_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}

		public function direct_income(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
			
				$fromdate="";$todate="";$queery="";$txt_bscaddress="";
				$recstatus="-1";$descrip="1";
				
				$fromdate=$request->has('fromdate')?'1':'0' ;
				$todate=$request->has('todate')?'1':'0' ;
				$txt_bscaddress=$request->has('txt_bscaddress')?'1':'0' ;
				$user = [];
				$userwds = [];
				
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($txt_bscaddress==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
				    if($request->input('txt_bscaddress')=="")
					{
						$ERRMSG = "wallet address should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
						$contactno=$request->input('txt_bscaddress');
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					//$contactno='0xB161029c7d1646941f7cc1E95A78e91F501cFe5c';
					$user = Helper::get_userid_by_userbscaddress($contactno);
					$userwds =Helper::get_userwds_by_userbscaddress($contactno);
					$start = date('Y-m-d',strtotime('2025-01-01'));
					$end = date('Y-m-d');
					$USER = $user[0]->RegId??'-1';
					if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
					{
						$queery = $queery."DATE_FORMAT(`DIRECT_ENTRYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
					}
					
					$queery = $queery."`USER_ID` = $user  AND ";
					$queery = $queery." DIRECT_LEVEL=1 AND DIRECT_DESCRIP='Direct Income' AND DIRECT_ISPUBLISH=1";

					$direct_report = $this->closing_repo->directDetails($queery);
					$ERRMSG="USER DIRECT INCOME REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'DIRECT_DATA'=>$direct_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}
		
		public function level_income(Request $request)
        {
             if($_SERVER['REQUEST_METHOD']=="POST")
			{
			
				$fromdate="";$todate="";$queery="";$txt_bscaddress="";
				$recstatus="-1";$descrip="1";
				
				$fromdate=$request->has('fromdate')?'1':'0' ;
				$todate=$request->has('todate')?'1':'0' ;
				$txt_bscaddress=$request->has('txt_bscaddress')?'1':'0' ;
				
				
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($txt_bscaddress==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
				    if($request->input('txt_bscaddress')=="")
					{
						$ERRMSG = "wallet address should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					// else if($request->input('fromdate')=='')
					// {
					// 	$ERRMSG = "Form date should be valid or not blank.";
					// 	$this->isError= TRUE;
					// 	$ERRCODE="warning";
					// }
					// else if($request->input('todate')=='')
					// {
					// 	$ERRMSG = "To date should be valid or not blank.";
					// 	$this->isError= TRUE;
					// 	$ERRCODE="warning";
					// }
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
						$contactno=$request->input('txt_bscaddress');
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					//$contactno='0xB161029c7d1646941f7cc1E95A78e91F501cFe5c';
					$user = Helper::get_userid_by_userbscaddress($contactno);
					$userwds =Helper::get_userwds_by_userbscaddress($contactno);
					$start = date('Y-m-d',strtotime('2025-01-01'));
					$end = date('Y-m-d');
					$USER = $user[0]->RegId??'-1';
					
					if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
					{
						$queery = $queery." DATE_FORMAT(`DIRECT_ENTRYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND ";
					}
					
					$queery = $queery."`USER_ID` = $user  AND ";
					//$queery = $queery." DIRECT_ISPUBLISH=1";
					$queery = $queery." DIRECT_DESCRIP='Level Income' AND DIRECT_ISPUBLISH=1 ORDER BY DIRECT_ENTRYDATE DESC";
				
					$direct_report = $this->closing_repo->directDetails($queery);

					//return $direct_report;
					$ERRMSG="USER DIRECT INCOME REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'DIRECT_DATA'=>$direct_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}

public function matching_income(Request $request)
        {
             if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
			

				$fromdate="";$todate="";$cond="";
				$recstatus="-1";$descrip="1";
				
				$fromdate=$request->has('fromdate')?'1':'0' ;
				$todate=$request->has('todate')?'1':'0' ;
				
			
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($fromdate==0 || $todate==0 )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('fromdate')=='')
					{
						$ERRMSG = "Form date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('todate')=='')
					{
						$ERRMSG = "To date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					
					$cond = $cond."`tr26_closing_detail`.`m11_user_id` = $USER  AND ";
					$cond1=" 1 ";
					$start = date('Y-m-d',strtotime($request->input('fromdate')));
					$end = date('Y-m-d',strtotime($request->input('todate')));
					if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
					{
						$cond = $cond."DATE_FORMAT(`tr26_to_closing_date`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
					}
					$cond=$cond.$cond1;
					$payoutreport=array(
					'queery'=>$cond
			        );
					$payout_report=$this->closing_repo->payoutReport($payoutreport);
		
					$ERRMSG="USER MATCHING INCOME REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'MATCHING_DATA'=>$payout_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}

		public function show_recharge(Request $request)
        {
             if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
			

				$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
				$recstatus="-1";$descrip="1";
				
				$fromdate=$request->has('fromdate')?'1':'0' ;
				$todate=$request->has('todate')?'1':'0' ;
				$transid=$request->has('transid')?'1':'0' ;
				$noofrecords=$request->has('noofrecords')?'1':'0' ;
				$account=$request->has('account')?'1':'0' ;
				$recstatus=$request->has('recstatus')?'1':'0' ;
				$descrip=$request->has('descrip')?'1':'0' ;
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($fromdate==0 || $todate==0 || $transid==0 || $noofrecords==0 || $account==0 || $recstatus==0 || $descrip==0  )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('fromdate')=='')
					{
						$ERRMSG = "Form date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('todate')=='')
					{
						$ERRMSG = "To date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('noofrecords')=='')
					{
						$ERRMSG = "No of records should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('recstatus')=='')
					{
						$ERRMSG = "Ledger type should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('descrip')=='')
					{
						$ERRMSG = "Description should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					
					$recharge=array(
							'proc'=>'2',
							'account'=>$request->input('account'),
							'transid'=>$request->input('transid'),
							'userid'=>$login_detail[0]->RegId,
							'fromdate'=>date('Y-m-d',strtotime($request->input('fromdate'))),
							'todate'=>date('Y-m-d',strtotime($request->input('todate'))),
							'noofrecords'=>$request->input('noofrecords'),
							'recstatus'=>$request->input('recstatus'),
							'descrip'=>$request->input('descrip')
							);
				
							$recharge_report=DB::select('CALL recharge_report(				
							:proc,
							:account,
							:transid,
							:userid,
							:fromdate,
							:todate,
							:noofrecords,
							:recstatus,
							:descrip,
							@msg
							)',$recharge);
					$ERRMSG="USER RECHARGE REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'REC_DATA'=>$recharge_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}


		/**
			* Method name	: recharge
			* @description 	: Used to Recharge Prepaid,DTH,Datacard 
			* @param		: Request data  
			* @return		: Get Recharge data array with response message
		*/
		public function transaction(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$res_format="json";$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="remark";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";$xmlarray ="";	$circlecode="";$opcircle_id ="";$circleid="0";
				$status1="PENDING";
				$status2=2;$method='GET';$mbal=0.00;$auto_switch='false';$hit_count=1;$auto_status='1';$next_api='';
				$ERRCODE="warning";
				$mobileno1="";$amount1="";$opt1="";
				$mobileno1=$request->has('mobile')?'1':'0' ;
				$amount1=$request->has('amount')?'1':'0' ;
				$opt1=$request->has('opt')?'1':'0' ;
				
				
				$agentid ='123456789';
				$format  ='json';
				$ip=$request->server('REMOTE_ADDR');
				$fullurl=$request->fullUrl();
				$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('$token','$agentid','$ip','$fullurl','',1)");
				$incmghit_record_id=DB::select("SELECT LAST_INSERT_ID() As id");
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($this->isError== FALSE)
					{
						if($mobileno1==0 || $amount1==0 || $opt1==0)
						{
							$ERRMSG = "Parameter missing or not blank.";
							$this->isError= TRUE;
							$ERRCODE="warning";

						}
						else if($request->input('mobile')=='')
						{
							$ERRMSG = "Mobile no should be valid.";
							$this->isError= TRUE;
							$ERRCODE="success";
							$userData ='';
						}
						else if(!$this->valid_phone_number($request->input('mobile')))
						{
							$ERRMSG = "Mobile no should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($request->input('amount')) == '' || trim(floatval($request->input('amount')))<=0.00)
						{
							$ERRMSG = "Amount should be valid or not blank.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($request->input('opt')) == '')
						{
							$ERRMSG = "Operator Code should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($agentid) == '')
						{
							$ERRMSG = "Agent id should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($format) == '')
						{
							$ERRMSG = "Format should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else
						{
		$url='http://planapi.in/api/Mobile/OperatorFetchNew?ApiUserID=3889&ApiPassword=123456&Mobileno='.$request->input('mobile').'';
		$host = '';    
	   
			$options = array(
			CURLOPT_SSL_VERIFYHOST => 0,
			CURLOPT_SSL_VERIFYPEER => 0
			);
			$defaults = array(
			CURLOPT_URL => $url,
			CURLOPT_HEADER => 0,
			CURLOPT_RETURNTRANSFER => TRUE,
			CURLOPT_TIMEOUT =>60
			);

			$ch = curl_init();
			curl_setopt_array($ch, ($options + $defaults));
			$result = curl_exec($ch);
			$json=json_decode($result);
			if(!$result)
			{
				$result=trigger_error(curl_error($ch));
				curl_close($ch);
						$ERRMSG = "DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
			}
		    else
			{
		    	if($json->Operator!=''){
						$opcode	=$json->Operator;
						$circlecode=$json->CircleCode;
		    	}
			}
		    curl_close($ch);
		
							$mobileno=$request->input('mobile');
							$amount  =$request->input('amount');
							$opcode  =$request->input('opt');
						if($circlecode!='' && $circlecode!=0){
						$opcircle_id = DB::select("SELECT IFNULL(`CIRCLE_ID`,'') as CIRCLE_ID FROM `op_circle` WHERE `CIRCLE_CODE`=".$circlecode." LIMIT 1");
						$circleid=$opcircle_id[0]->CIRCLE_ID;
						}
						$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_code`='".$opcode."' AND `m04_tc_brand_status`='Active' LIMIT 1");
							$brand_id=$opcode_id[0]->BRAND_ID;
							$service_id=$opcode_id[0]->SERVICE_ID;
							$ERRMSG = "D.";
							$this->isError= FALSE;
							$ERRCODE="success";
							$userData =$opcode_id[0]->BRAND_ID.'_'.$service_id;
						}
					}
					if($this->isError== FALSE)
					{
						
						$rechreq=array(
						'proc'=>'1',
						'user_id'=>$login_detail[0]->RegId,
						'mobile'=>$mobileno,
						'operator'=>$brand_id,
						'amount'=>$amount,
						'requesttype'=>2,
						'servicetype'=>$service_id,
						'agentid'=>'',
						'format'=>$circleid,
						'timelimit'=>(config('INTERVAL_RECHARGE')*60),
						'defaultstatus'=>'2'
						);	
						$rechreq_report=DB::select('CALL dorecharge(				
						:proc,
						:user_id,
						:mobile,
						:operator,
						:amount,
						:requesttype,
						:servicetype,
						:agentid,
						:format,
						:timelimit,
						:defaultstatus,
						@msg,
						@msg2
						)',$rechreq);
						
						$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
						$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
						
						if($DB_ERROR[0]->ERROR!="Error")
						{
							$transid=$DB_ERRMSG[0]->ERR_MSG;
							foreach($rechreq_report as $row)
							{						
								break;
							}
							$next_api=$row->next_api;
							$url=$row->url_address;	
							$operatorcode=$row->oper_code;
							$apiid=$row->apiid;
							$method='GET';
							$param1=$service_id;
							$param2="0";
							if($operatorcode==4)
							$param2="s";
							$res_format=$row->RES_FORMAT;$status=$row->RES_PARAM;$opid=$row->LIVEID;$rbid=$row->APITXNID;
							$res_success=$row->SUCCESS_VALUE;$res_fail=$row->FAILED_VALUE;$res_pending=$row->PENDING_VALUE;$mbal=$row->MAINWALLET;
							if($apitoken!="")
							$url=str_replace('@apitoken',$apitoken,$url);
							if($userid!="")
							$url=str_replace('@userid',$userid,$url);
							if($password!="")
							$url=str_replace('@password',$password,$url);
							if($mobileno!="")
							$url=str_replace('@account',$mobileno,$url);
							if($amount!="")
							$url=str_replace('@amount',$amount,$url);
							if($operatorcode!="")
							$url=str_replace('@operatorcode',$operatorcode,$url);
							if($DB_ERROR[0]->ERROR!="Error")
							$url=str_replace('@refrence',$DB_ERRMSG[0]->ERR_MSG,$url);
							if($format!="")
							$url=str_replace('@format',$format,$url);
							if($param1!="")
							$url=str_replace('@param1',$param1,$url);
							if($param2!="")
							$url=str_replace('@param2',$param2,$url);
							//echo $url.'</br>';
							//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
							$response=Helper::_curl_execute($method,$url,'');
						$outgoinghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
			        	VALUES ('','$transid','$operatorcode','$url','$response',2)");	
                                 $res_rbid="2598223";
								if($res_format=="string")
								{
									$status1="PENDING";
									$status2=2;
									$ERRCODE="warning";
									$pr=explode('=',$result);
										for($t=0;count($pr)>$t;$t++)
										{
											if($t==0)
											{
												$rstatus=$pr[$t];
											}
										}
												if($status!="")
												{
													$res_status=$rstatus;
												}
												if($opid!='')
												{
													$res_opid='';
												}
												if($rbid!='')
												{
													$res_rbid='';
												}
						}
						if($res_format=="JSON")
						{
							$json=json_decode($response,true);
							if($status!="")
							{
							    if(!empty($json[$status]))
								$res_status=$json[$status];
								else
								{
								$is_error=$json['error'];
								if($is_error=='true')
								$res_status="FAILED";
								}
								if($res_status==$res_fail || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						$auto_switch='true';
							}
							if($opid!='')
							{
							    if(!empty($json[$opid]))
								$res_opid=$json[$opid];
							}
							if($rbid!='')
							{
							    if(!empty($json[$rbid]))
								$res_rbid=$json[$rbid];
							}
							if($msg!='' && $msg!="remark")
							{
							    if(!empty($json[$msg]))
								$res_msg=$json[$msg];
							}
						}
						if($res_format=="xml" || $res_format=="XML" )
						{
							$array = XmlToArray::convert($response);
							$json = json_encode($array);
							$xmlarray = json_decode($json,TRUE);
							if($status!="")
							{
								$res_status=$xmlarray[$status];
								
							}
							if($opid!='' && $res_status=="SUCCESS" )
							{
							    if(!empty($xmlarray[$opid]))
								$res_opid=$xmlarray[$opid];
							}
							if($rbid!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$rbid]))
								$res_rbid=$xmlarray[$rbid];
						
							}
							if($msg!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$msg]))
								$res_msg=$xmlarray[$msg];
								
							}
							if($res_status=="FAILED" || $res_status=="REFUND") 
							{
							    $auto_switch='true';
							}
						}
						$arr = array(
						    'tr05_api_txnid'=>$res_rbid,
							'tr05_remarks' =>trim($response)
						);
					    DB::table('tr05_recharge_detail')->where('tr05_trans_id',$transid)->update($arr);
						if($auto_switch=='true' && $next_api!=0)
						{
							do{ 
								$auto_response=$this->auto_switch_api($login_detail[0]->RegId,$transid,$brand_id,$hit_count);
								if($auto_response=='')
								$hit_count=$hit_count+1;
								else
								break;
							}while (($status=='' || $hit_count<6));
							    if($auto_response!='')
								{
								    $arr = array(
							'tr09_apihit_response' =>trim($auto_response)
						);
				     	DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
									return $auto_response;
								}
								
						}
						else
						{
						    $auto_switch='false';$auto_status='1';
						}
					
						if($auto_switch=='false' && $auto_status!='')
						{
						    	if($res_status==$res_success || $res_status=="SUCCESS" || $res_status=="Success" )
        						{
        							$status1="SUCCESS";
        							$status2=1;
        							$ERRCODE="success";
        						}
        						if($res_status==$res_pending || $res_status=="PENDING" || $res_status=="Pending")
        						{
        							$status1="PENDING";
        							$status2=2;
        							$ERRCODE="warning";
        						}
        						if($res_status==$res_fail || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						{
        							$status1="FAILED";
        							$status2=4;
        							$ERRCODE="error";
        						}
							
							$respreport=array(
							'proc'=>1,
							'userid'=>$login_detail[0]->RegId,
							'account'=>$mobileno,
							'transid'=>$transid,
							'liveid'=>$res_opid,
							'amt'=>$amount,
							'recstatus'=>$status2,
							'descrip'=>1							
							);
							$resquery = DB::select('CALL recharge_statusupdate(
							:proc,
							:userid,
							:account,
							:transid,
							:liveid,
							:amt,
							:recstatus,
							:descrip,
							@resmsg)',$respreport);
							$ERRMSG = "RECHARGE IS ".$status1." TRANSACTION ID- ".$DB_ERRMSG[0]->ERR_MSG;
							$this->isError= FALSE;
							$ERRCODE="success";
							$userData =$DB_ERRMSG[0]->ERR_MSG;
							}
						 $response_inc=response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'STATUS'=>trim($status1),
							'MOBILE'=>trim($mobileno),
							'AMOUNT'=>trim($amount),
							'AGENTID'=>trim($agentid),
							'OPID'=>trim($res_opid),
							'TID'=>trim($DB_ERRMSG[0]->ERR_MSG),
							'BAL'=>trim(floatval(0.00))
							]);
							$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
				    	DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
						return $response_inc;
						}
						else
						{	
							$ERRMSG = $DB_ERRMSG[0]->ERR_MSG;
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';	
						$response_inc= response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
								$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
					DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
						return $response_inc;	
						}
					}
					else
					{
					$response_inc=  response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
								$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
					DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
						return $response_inc;	
					}
				}
						$response_inc= response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
						$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
					DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
						return $response_inc;	
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				$response_inc=response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
				DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
				return $response_inc;

			}
			
		}

		/**
			* Method name	: dth_transaction
			* @description 	: Used to Recharge DTH
			* @param		: Request data  
			* @return		: Get Recharge data array with response message
		*/
		public function dth_transaction(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$res_format="json";$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="remark";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";$xmlarray ="";$circlecode="";$opcircle_id ="";$circleid="0";
				$status1="PENDING";
				$status2=2;$method='GET';$mbal=0.00;$auto_switch='false';$hit_count=1;$auto_status='1';$next_api='';
				$ERRCODE="warning";
				$cardnumber="";$cardnumber1="";$amount1="";$opt1="";
				$cardnumber1=$request->has('cardnumber')?'1':'0' ;
				$amount1=$request->has('amount')?'1':'0' ;
				$opt1=$request->has('opt')?'1':'0' ;
				
				
				$agentid ='123456789';
				$format  ='json';
				$ip=$request->server('REMOTE_ADDR');
				$fullurl=$request->fullUrl();
				$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('$token','$agentid','$ip','$fullurl','',1)");
					$incmghit_record_id=DB::select("SELECT LAST_INSERT_ID() As id");
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($this->isError== FALSE)
					{
						if($cardnumber1==0 || $amount1==0 || $opt1==0)
						{
							$ERRMSG = "Parameter missing or not blank.";
							$this->isError= TRUE;
							$ERRCODE="warning";

						}
						else if($request->input('cardnumber')=='')
						{
							$ERRMSG = "Card number should be valid.";
							$this->isError= TRUE;
							$ERRCODE="success";
							$userData ='';
						}
						else if(trim($request->input('amount')) == '' || trim(floatval($request->input('amount')))<=0.00)
						{
							$ERRMSG = "Amount should be valid or not blank.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($request->input('opt')) == '')
						{
							$ERRMSG = "Operator Code should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($agentid) == '')
						{
							$ERRMSG = "Agent id should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($format) == '')
						{
							$ERRMSG = "Format should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else
						{
							$cardnumber=$request->input('cardnumber');
							$amount  =$request->input('amount');
							$opcode  =$request->input('opt');
							$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_code`='".$opcode."' AND `m04_tc_brand_status`='Active' LIMIT 1");
							$brand_id=$opcode_id[0]->BRAND_ID;
							$service_id=$opcode_id[0]->SERVICE_ID;
							$ERRMSG = "D.";
							$this->isError= FALSE;
							$ERRCODE="success";
							$userData =$opcode_id[0]->BRAND_ID.'_'.$service_id;
						}
					}
					if($this->isError=== FALSE)
					{
						$rechreq=array(
						'proc'=>'1',
						'user_id'=>$login_detail[0]->RegId,
						'mobile'=>$cardnumber,
						'operator'=>$brand_id,
						'amount'=>$amount,
						'requesttype'=>2,
						'servicetype'=>$service_id,
						'agentid'=>'',
						'format'=>1,
						'timelimit'=>(config('INTERVAL_RECHARGE')*60),
						'defaultstatus'=>'2'
						);	
						$rechreq_report=DB::select('CALL dorecharge(				
						:proc,
						:user_id,
						:mobile,
						:operator,
						:amount,
						:requesttype,
						:servicetype,
						:agentid,
						:format,
						:timelimit,
						:defaultstatus,
						@msg,
						@msg2
						)',$rechreq);
						
						$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
						$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
						
						if($DB_ERROR[0]->ERROR!="Error")
						{
							$transid=$DB_ERRMSG[0]->ERR_MSG;
							foreach($rechreq_report as $row)
							{						
								break;
							}
							$next_api=$row->next_api;
							$url=$row->url_address;	
							$operatorcode=$row->oper_code;
							$apiid=$row->apiid;
							$method='GET';
							$param1=$service_id;
							$param2="0";
							if($operatorcode==4)
							$param2="s";
							$res_format=$row->RES_FORMAT;$status=$row->RES_PARAM;$opid=$row->LIVEID;$rbid=$row->APITXNID;
							$res_success=$row->SUCCESS_VALUE;$res_fail=$row->FAILED_VALUE;$res_pending=$row->PENDING_VALUE;$mbal=$row->MAINWALLET;
							if($apitoken!="")
							$url=str_replace('@apitoken',$apitoken,$url);
							if($userid!="")
							$url=str_replace('@userid',$userid,$url);
							if($password!="")
							$url=str_replace('@password',$password,$url);
							if($cardnumber!="")
							$url=str_replace('@account',$cardnumber,$url);
							if($amount!="")
							$url=str_replace('@amount',$amount,$url);
							if($operatorcode!="")
							$url=str_replace('@operatorcode',$operatorcode,$url);
							if($DB_ERROR[0]->ERROR!="Error")
							$url=str_replace('@refrence',$DB_ERRMSG[0]->ERR_MSG,$url);
							if($format!="")
							$url=str_replace('@format',$format,$url);
							if($param1!="")
							$url=str_replace('@param1',$param1,$url);
							if($param2!="")
							$url=str_replace('@param2',$param2,$url);
							//echo $url.'</br>';
							//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
							$response=Helper::_curl_execute($method,$url,'');
						    $outgoinghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				            VALUES ('','$transid','$operatorcode','$url','$response',2)");	
                                $res_rbid="2598223";
								if($res_format=="string")
								{
									$status1="PENDING";
									$status2=2;
									$ERRCODE="warning";
									$pr=explode('=',$result);
										for($t=0;count($pr)>$t;$t++)
										{
											if($t==0)
											{
												$rstatus=$pr[$t];
											}
										}
												if($status!="")
												{
													$res_status=$rstatus;
												}
												if($opid!='')
												{
													$res_opid='';
												}
												if($rbid!='')
												{
													$res_rbid='';
												}
						        }
				      	if($res_format=="JSON")
						{
							$json=json_decode($response,true);
							if($status!="")
							{
							    if(!empty($json[$status]))
								$res_status=$json[$status];
								else
								{
								$is_error=$json['error'];
								if($is_error=='true')
								$res_status="FAILED";
								}
								if($res_status==$res_fail || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						$auto_switch='true';
							}
							if($opid!='')
							{
							    if(!empty($json[$opid]))
								$res_opid=$json[$opid];
							}
							if($rbid!='')
							{
							    if(!empty($json[$rbid]))
								$res_rbid=$json[$rbid];
							}
							if($msg!='' && $msg!="remark")
							{
							    if(!empty($json[$msg]))
								$res_msg=$json[$msg];
							}
						}
						if($res_format=="xml" || $res_format=="XML" )
						{
							$array = XmlToArray::convert($response);
							$json = json_encode($array);
							$xmlarray = json_decode($json,TRUE);
							if($status!="")
							{
								$res_status=$xmlarray[$status];
								
							}
							if($opid!='' && $res_status=="SUCCESS" )
							{
							    if(!empty($xmlarray[$opid]))
								$res_opid=$xmlarray[$opid];
							}
							if($rbid!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$rbid]))
								$res_rbid=$xmlarray[$rbid];
						
							}
							if($msg!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$msg]))
								$res_msg=$xmlarray[$msg];
								
							}
							if($res_status=="FAILED" || $res_status=="REFUND") 
							{
							    $auto_switch='true';
							}
						}
						$arr = array(
						    'tr05_api_txnid'=>$res_rbid,
							'tr05_remarks' =>trim($response)
						);
					    DB::table('tr05_recharge_detail')->where('tr05_trans_id',$transid)->update($arr);
						if($auto_switch=='true' && $next_api!=0)
						{
							do{ 
								$auto_response=$this->auto_switch_api($login_detail[0]->RegId,$transid,$brand_id,$hit_count);
								if($auto_response=='')
								$hit_count=$hit_count+1;
								else
								break;
							}while (($status=='' || $hit_count<6));
							if($auto_response!='')
							{
    							$arr = array(
    							'tr09_apihit_response' =>trim($auto_response)
    						     );
    				     	     DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
    							return $auto_response;
							}
								
						}
						else
						{
						    $auto_switch='false';$auto_status='1';
						}
					
						if($auto_switch=='false' && $auto_status!='')
						{
						    	if($res_status==$res_success || $res_status=="SUCCESS" || $res_status=="Success" )
        						{
        							$status1="SUCCESS";
        							$status2=1;
        							$ERRCODE="success";
        						}
        						if($res_status==$res_pending || $res_status=="PENDING" || $res_status=="Pending")
        						{
        							$status1="PENDING";
        							$status2=2;
        							$ERRCODE="warning";
        						}
        						if($res_status==$res_fail || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						{
        							$status1="FAILED";
        							$status2=4;
        							$ERRCODE="error";
        						}
							
							$respreport=array(
							'proc'=>1,
							'userid'=>$login_detail[0]->RegId,
							'account'=>$cardnumber,
							'transid'=>$transid,
							'liveid'=>$res_opid,
							'amt'=>$amount,
							'recstatus'=>$status2,
							'descrip'=>1							
							);
							$resquery = DB::select('CALL recharge_statusupdate(
							:proc,
							:userid,
							:account,
							:transid,
							:liveid,
							:amt,
							:recstatus,
							:descrip,
							@resmsg)',$respreport);
							$ERRMSG = "RECHARGE IS ".$status1." TRANSACTION ID- ".$DB_ERRMSG[0]->ERR_MSG;
							$this->isError= FALSE;
							$ERRCODE="success";
							$userData =$DB_ERRMSG[0]->ERR_MSG;
							}
							
							$response_inc= response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'STATUS'=>trim($status1),
							'MOBILE'=>trim($cardnumber),
							'AMOUNT'=>trim($amount),
							'AGENTID'=>trim($agentid),
							'OPID'=>trim($res_opid),
							'TID'=>trim($DB_ERRMSG[0]->ERR_MSG),
							'BAL'=>trim(floatval(0.00))
							]);
							$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
					DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
					return $response_inc;
						}
						else
						{	
							$ERRMSG = $DB_ERRMSG[0]->ERR_MSG;
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';	
							$response_inc= response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
							$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
					DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
					return $response_inc;
						}
					}
					else
					{
					$response_inc= response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
							$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
					DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
					return $response_inc;
					}
				}
					$response_inc= response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
					$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
					DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
					return $response_inc;
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				$response_inc= response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				$arr = array(
							'tr09_apihit_response' =>trim($response_inc)
						);
				DB::table('tr09_smsvalue')->where('tr09_apihit_id',$incmghit_record_id[0]->id)->update($arr);
				return $response_inc;

			}
			
		}


		/**
			* Method name	: Complaint
			* @description 	: Used to raise complaint
			* @param		: Request data  
			* @return		: Raise complaint data array with response message
		*/
		public function complaint(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
			$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
			
			$txt_forrefundtxnid=""; $txt_rechid=""; $dd_complaintreason=""; 
			
			$txt_forrefundtxnid=$request->has('txt_forrefundtxnid')?'1':'0' ;
			$txt_rechid=$request->has('txt_rechid')?'1':'0' ;
			$dd_complaintreason=$request->has('dd_complaintreason')?'1':'0' ;
			
			
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($txt_forrefundtxnid==0 || $txt_rechid==0 || $dd_complaintreason==0 )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
    				else if($request->input('txt_forrefundtxnid')=="")
    				{
    					$ERRMSG = "Recharge transaction id  should be valid or not blank.";
    					$this->isError = TRUE;
    					$ERRCODE="warning";
    				}
    			    else if($request->input('txt_rechid')=="")
    				{
    					$ERRMSG = "Recharge Id for complaint should be valid or not blank.";
    					$this->isError = TRUE;
    					$ERRCODE="warning";
    				}
    				else if($request->input('dd_complaintreason')=="" || $request->input('dd_complaintreason')=="-1")
    				{
    					$ERRMSG = "Complaint reason should be valid or not blank.";
    					$this->isError = TRUE;
    					$ERRCODE="warning";
    				}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}

				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					
					$TRANSID=$request->input('txt_forrefundtxnid');
					$RECHID=$request->input('txt_rechid');
					$REASON=$request->input('dd_complaintreason');
							$respreport=array(
										'proc'=>1,
										'recharge_id'=>$RECHID,
										'descrip'=>$REASON,
										'defaultstatus'=>1
									);
							$resp_report = DB::select('CALL refund(
								 :proc,
								 :recharge_id,
								 :descrip, 
								 :defaultstatus,
								 @msg,
								 @msg1
							 )',$respreport);
				$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
				$ERRCODE=DB::select('SELECT @msg1 as ERR_MSG1');
				return response()->json([
					'ERROR'=>$ERRCODE[0]->ERR_MSG1,
					'MSG' =>$ERRMSG[0]->ERR_MSG
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}
		
		/**
			* Method name	: NEWS
			* @description 	: Used to Get News
			* @param		: Request data  
			* @return		: Get News data array with response message
		*/
		public function news(Request $request)
		{
			
			if($_SERVER['REQUEST_METHOD']=="GET")
			{	
				$status=$request->has('status')?'1':'0' ;
				$userid=$request->has('affiliate_id')?'1':'0' ;
				if($status==0 || $userid==0)
				{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
				}
				else if($request->get('affiliate_id')=='')
				{
					$ERRMSG = "Affiliate Id should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					
				}
				else if($request->get('status')=='')
				{
					$ERRMSG = "Status should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					
				}
				else
				{
					if($request->get('affiliate_id')==-1)
					{
					  $news_detail = DB::select("SELECT * FROM `news` WHERE NewsStatus='".$request->get('status')."'");
					}
					else 
					{
					  $news_detail = DB::select("SELECT * FROM `news` WHERE `AffID`=".$request->get('affiliate_id')." AND NewsFor IN (2,3) AND  NewsStatus=".$request->get('status')."");
					}
					
					if($news_detail)
					{
							$ERRMSG = "NEWS GET SUCCESSFULLY";
							$ERRCODE="success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'NEWS'=>$news_detail
							]);
					}
					else
					{
						$ERRMSG = "NEWS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
		}
		/**
			* Method name	: Bank Account
			* @description 	: Used to Get Bank Account 
			* @param		: Request data  
			* @return		: Get Bank Account data array with response message
		*/
		public function bank_account(Request $request)
		{
			
			if($_SERVER['REQUEST_METHOD']=="GET")
			{	
				$status=$request->has('status')?'1':'0' ;
				$userid=$request->has('affiliate_id')?'1':'0' ;
				if($status==0 || $userid==0)
				{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
				}
				else if($request->get('affiliate_id')=='')
				{
					$ERRMSG = "Affiliate Id should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					
				}
				else if($request->get('status')=='')
				{
					$ERRMSG = "Status should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					
				}
				else
				{
					if($request->get('affiliate_id')==-1)
					{
					  $bank_account = DB::select("SELECT * FROM `company_bank_account` WHERE BANK_STATUS='".$request->get('status')."'");
					}
					else 
					{
					  $bank_account = DB::select("SELECT * FROM `company_bank_account` WHERE `USER_ID`=".$request->get('affiliate_id')." AND BANK_STATUS=".$request->get('status')."");
					}
					if($bank_account)
					{
							$ERRMSG = "BANK ACCOUNT DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'BANKACCOUNT'=>$bank_account
							]);
					}
					else
					{
						$ERRMSG = "BANK ACCOUNT DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
		}
		
		
	public function user_fundrequestto_admin(Request $request)
		{
		
		 if($_SERVER['REQUEST_METHOD']=="POST")
			{
			$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
			$dd_wallet=""; $dd_depositedbank=""; $dd_paymentmethod=""; $txt_amount=""; $txt_bankutrn=""; 
			
			$dd_wallet=$request->has('dd_wallet')?'1':'0' ;
			$dd_depositedbank=$request->has('dd_depositedbank')?'1':'0' ;
			$dd_paymentmethod=$request->has('dd_paymentmethod')?'1':'0' ;
			$txt_amount=$request->has('txt_amount')?'1':'0' ;
			$txt_bankutrn=$request->has('txt_bankutrn')?'1':'0' ;
			
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($dd_wallet==0 || $dd_depositedbank==0 || $dd_paymentmethod==0 || $txt_amount==0 || $txt_bankutrn==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_wallet')=='' || $request->input('dd_wallet')=='-1')
					{
						$ERRMSG = "Wallet type should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_depositedbank')=='' || $request->input('dd_depositedbank')=='-1')
					{
						$ERRMSG = "Bank Account should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_paymentmethod')=='' || $request->input('dd_paymentmethod')=='-1')
					{
						$ERRMSG = "Payment method should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
					{
						$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_amount'))<0.00)
					{
						$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_bankutrn')=='')
					{
						$ERRMSG = "Refrence/Bank UTRNO should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				//dd($ERRMSG);
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					$AFFILIATE_CODE=$login_detail[0]->Affid;
				
					$fundreq=array(
						'proc'=>2,
						'm27_adminbank_id'=>$request->input('dd_depositedbank'),
						'm11_user_id'=>$USER,
						'tr01_fr_towallet'=>$request->input('dd_wallet'),
						'tr01_fr_mode'=>intval($request->input('dd_paymentmethod')),
						'tr01_fr_utrno'=>$request->input('txt_bankutrn'),
						'tr01_fr_amount'=>floatval($request->input('txt_amount')),
						'tr01_fr_transid'=>'',
						'tr01_fr_des'=>"FUND REQUEST",
						'tr01_fr_admin_res'=>'',
						'tr01_fr_status'=>1,
						'tr01_fr_toadmin'=>1,
						'm11_user_referral_code'=>0,
						'm22_affiliate_id'=>$AFFILIATE_CODE
					);
					$fund_request=DB::select('CALL fund_request(				
					:proc,
					:m27_adminbank_id,
					:m11_user_id,
					:tr01_fr_towallet,
					:tr01_fr_mode,
					:tr01_fr_utrno,
					:tr01_fr_amount,
					:tr01_fr_transid,
					:tr01_fr_des,
					:tr01_fr_admin_res,
					:tr01_fr_status,
					:tr01_fr_toadmin,
					:m11_user_referral_code,
					:m22_affiliate_id,
					@status_code,
					@status_msg
					)',$fundreq);
				   $DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                   $DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				   $ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
                   $ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
				   return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}
		
		
		public function user_fundtransferto_team(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
			$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
			
			$ladger=""; $baltype=""; $txt_mobileno=""; $txt_amount=""; $txt_cashcolledted=""; 
			$txt_remark=""; $txt_ccremark="";
			$ladger=$request->has('ladger')?'1':'0' ;
			$baltype=$request->has('baltype')?'1':'0' ;
			$txt_mobileno=$request->has('txt_mobileno')?'1':'0' ;
			$txt_amount=$request->has('txt_amount')?'1':'0' ;
			$txt_cashcolledted=$request->has('txt_cashcolledted')?'1':'0' ;
			$txt_remark=$request->has('txt_remark')?'1':'0' ;
			$txt_ccremark=$request->has('txt_ccremark')?'1':'0' ;
			
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					$user = Helper::get_userid_by_mobile($request->input('txt_mobileno'));

					if($ladger==0 || $baltype==0 || $txt_mobileno==0 || $txt_amount==0 || $txt_cashcolledted==0 || 
			$txt_remark==0 || $txt_ccremark==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('ladger')=="")
					{
						$ERRMSG = "Ledger should be valid.Please Select Ledger Type ";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}	
					else if($request->input('baltype')=="")
					{
						$ERRMSG = "Balance type should be valid.Please Select Balance Type ";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}	
					else if($request->input('txt_mobileno')=='')
					{
						$ERRMSG = "Member contact number should be valid or not blank.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('txt_mobileno'))!=10)
					{
						$ERRMSG = "Member contact number should be equal to 10 digit.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
					else if(empty($user))
					{
						$ERRMSG = "Member should be valid";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
					else if($login_detail[0]->RegId==$user)
					{
						$ERRMSG = "Same account has not been transferable.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
					{
						$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}				
					else if(floatval($request->input('txt_amount')) < config('MIN_FUN_TRANSFER'))
					{
						$ERRMSG = "Amount should be greater than ".config('MIN_FUN_TRANSFER')." or not be negative.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_amount')) > config('MAX_FUND_TRANSFER'))
					{
						$ERRMSG = "Amount should be less than ".config('MAX_FUND_TRANSFER'). " or not be negative.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
					else
					{
						
					    $this->isError = FALSE;
						$ERRCODE="success";
						$ERRMSG = "";
					}
					}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				//dd($ERRMSG);
				if(request()->method() == 'POST' && $this->isError == FALSE)
				{
					$USER=$login_detail[0]->RegId;
			
					$fundtransfer_data=array(
					'proc'=>1,
					'to_user_id'=>$user,
					'from_user_id'=>$USER,
					'amount'=>floatval($request->input('txt_amount')),
					'collected_amount'=>floatval($request->input('txt_cashcolledted')),
					'requesttype'=>1,
					'balfor'=>$request->input('baltype'),
					'transtype'=>1,
					'timelimit'=>(config('FUND_INTERVAL')*60),
					'defaultstatus'=>1,
					'remark'=>$request->input('txt_remark'),
					'collected_remark'=>$request->input('txt_ccremark')
					);

					$fundtransfer = DB::SELECT('CALL wallettransfer(
					:proc, 
					:to_user_id,
					:from_user_id,
					:amount, 
					:collected_amount,
					:requesttype,
					:balfor,:transtype,
					:timelimit,
					:defaultstatus,
					:remark,
					:collected_remark,
					@status_code,
					@status_msg)'
					,$fundtransfer_data);
					$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					$ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
					$ERRCODE=$DB_ERRCODE[0]->ERR_CODE;

					if($ERRCODE=="success")
					{
					$ERRMSGS="You Have Received Recharge Amount Of Rs ".floatval($request->input('txt_amount'))." From Sender  ".$login_detail[0]->MemberName. " With Txn ID , Transaction id-". $DB_ERRMSG[0]->ERR_MSG ." ";
					$ERRMSG="Amount ".floatval($request->input('txt_amount'))." TRANSFER to ".$request->input('txt_mobileno').", Transaction id-". $DB_ERRMSG[0]->ERR_MSG ." .";
						
						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = $request->input('txt_mobileno');
						$sms_data['SUBJECT'] = 'Fund TRANSFER IN APP ';
						$sms_data['MESSAGE'] = $ERRMSGS;
						$sms_data['TYPE'] = 6;
						$sms_data['SEND_BY'] = 2;
						$sms_data['SEND_BY_ID'] = $USER;
						Helper::send_sms_or_log($sms_data);
						//SMS SEND END 

					}
					else
					{
						$ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
					}

				return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}




        public function user_margin(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$margin_for=$request->has('margin_for')?'1':'0';	
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($margin_for==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('margin_for')=="")
					{
						$ERRMSG = "Margin for sholud be valid or not blank. ";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}	
					else if($request->input('margin_for')!="9" && $request->input('margin_for')!="10" && $request->input('margin_for')!="14")
					{
						$ERRMSG = "Please ask margin/surcharge for be valid service. ";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}	
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->GroupId;
					$slabmargin=array(
					'proc'=>$request->input('margin_for'),
					'userid'=>$USER,
					'telecombrandid'=>1,
					'desig'=>'',
					'apiid'=>'' 
					);
					$slab_margin=DB::select('CALL slab_margin(				
						:proc,
						:userid,
						:telecombrandid,
						:desig,
						:apiid,
						@msg
						)',$slabmargin);
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$ERRCODE="success";
					$ERRMSG==$DB_ERRMSG[0]->ERR_MSG;
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'MARGIN_DATA'=>$slab_margin
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}




		public function user_dailypurchase(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
				$ladegerstatus="-1";$descrip="";
				
				$fromdate=$request->has('fromdate')?'1':'0' ;
				$todate=$request->has('todate')?'1':'0' ;
				$transid=$request->has('transid')?'1':'0' ;
				$noofrecords=$request->has('noofrecords')?'1':'0' ;
				$account=$request->has('account')?'1':'0' ;
				$descrip=$request->has('descrip')?'1':'0' ;
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($fromdate==0 || $todate==0 || $transid==0 || $noofrecords==0 || $account==0 || $descrip==0  )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('fromdate')=='')
					{
						$ERRMSG = "Form date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('todate')=='')
					{
						$ERRMSG = "To date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('noofrecords')=='')
					{
						$ERRMSG = "No of records should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('descrip')=='')
					{
						$ERRMSG = "Description should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					$ladger=array(
							'proc'=>'2',
							'account'=>$request->input('account'),
							'transid'=>$request->input('transid'),
							'userid'=>$USER,
							'fromdate'=>date('Y-m-d',strtotime($request->input('fromdate'))),
							'todate'=>date('Y-m-d',strtotime($request->input('todate'))),
							'noofrecords'=>$request->input('noofrecords'),
							'ladegerstatus'=>1,
							'descrip'=>$request->input('descrip'),
							);
							$ladger_report=DB::select('CALL ledger(				
							:proc,
							:account,
							:transid,
							:userid,
							:fromdate,
							:todate,
							:noofrecords,
							:ladegerstatus,
							:descrip,
							@msg
							)',$ladger);
					$ERRMSG="USER PURCHASE_DATA REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'PURCHASE_DATA'=>$ladger_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}
		
		public function user_operatorwise(Request $request)
		{
		
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
				$ladegerstatus="-1";$descrip="";
				
				$fromdate=$request->has('fromdate')?'1':'0' ;
				$todate=$request->has('todate')?'1':'0' ;
				$descrip=$request->has('descrip')?'1':'0' ;
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($fromdate==0 || $todate==0 || $descrip==0  )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('fromdate')=='')
					{
						$ERRMSG = "Form date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('todate')=='')
					{
						$ERRMSG = "To date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('descrip')=='')
					{
						$ERRMSG = "Description should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					$dailyoperator=array(
							'proc'=>1,
							'userid'=>$USER,
							'fromdate'=>$request->input('fromdate'),
							'todate'=>$request->input('todate'),
							'descrip'=>$request->input('descrip')
						);
					  $rec_report = $this->rech_reprt_repo->dailyOperatorSales($dailyoperator);
					$ERRMSG="USER SALE_DATA REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'DAILYSALE_DATA'=>$rec_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}

		public function show_team(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$fromdate="";$todate="";$queery="";$txt_bscaddress="";
				$recstatus="-1";$descrip="1";
				$cond ="";
			
				$txt_bscaddress=$request->has('txt_bscaddress')?'1':'0' ;
				$user = [];
				$userwds = [];
				
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($txt_bscaddress==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
				    if($request->input('txt_bscaddress')=="")
					{
						$ERRMSG = "wallet address should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
						$contactno=$request->input('txt_bscaddress');
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					//$contactno='0x18a7589c8C1ee88F77f18E5875989D25929Ef26a';
					$user = Helper::get_userid_by_userbscaddress($contactno);
					$userwds =Helper::get_userwds_by_userbscaddress($contactno);
					$start = date('Y-m-d',strtotime('2025-01-01'));
					$cond = $cond."`m11_user`.`m11_user_referral_code`=". $user." AND 1 ORDER BY `m11_user`.`m11_user_role` ,`m11_user`.`m11_user_onadd`";
					$user=array(
					'proc'=>1,
					'userid'=> $cond
					);
					$user_report=DB::select('CALL enrolluser(				
					:proc,
					:userid,
					@msg
					)',$user);
					$ERRMSG="USER TEAM FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'TEAM_DATA'=>$user_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}

		public function show_totalteam(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$fromdate="";$todate="";$queery="";$txt_bscaddress="";
				$recstatus="-1";$descrip="1";
				$cond ="";
				
				$txt_bscaddress=$request->has('txt_bscaddress')?'1':'0' ;
				$user = [];
				$userwds = [];
				
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($txt_bscaddress==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
				    if($request->input('txt_bscaddress')=="")
					{
						$ERRMSG = "wallet address should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
						$contactno=$request->input('txt_bscaddress');
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					//$contactno='0x18a7589c8C1ee88F77f18E5875989D25929Ef26a';
					$user = Helper::get_userid_by_userbscaddress($contactno);
					$userwds =Helper::get_userwds_by_userbscaddress($contactno);
					$start = date('Y-m-d',strtotime('2025-01-01'));
					
					$end = date('Y-m-d');
				
					$pos=$request->input('dd_position');
					if($pos!=''){
						 $this->team_repo->getDownline($user,$pos);
					}
					else
					{
				    $this->team_repo->getIntroDownline($user);
					}
				    $level= $this->team_repo->getTmpDownline();

					$cond ='`m11_user`.`m11_user_id` IN (SELECT member_id FROM tmp_downline) AND ';
					$cond1='';
				    $cond = $cond." 1 ORDER BY `m11_user`.`m11_user_role` ,`m11_user`.`m11_user_onadd` ";
					$user=array(
					'proc'=>1,
					'userid'=> $cond
					
					);
					$user_report=DB::select('CALL enrolluser(				
					:proc,
					:userid,
					@msg
					)',$user);
						//dd($cond,$user,$user_report);
					$ERRMSG="USER TEAM FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'TEAM_DATA'=>$user_report,
					'LEVEL'=>$level
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}

        public function show_fundrequest(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
			

				$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
				$recstatus="-1";$descrip="1";
				
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->MemberContactNo;
					$fund_req_toadmin=DB::select("SELECT * FROM fund_request WHERE FUNDREQ_TO=1 AND MEMBER_CONTACT=".$USER);
					$ERRMSG="USER RECHARGE REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'FUNDREQUEST_DATA'=>$fund_req_toadmin
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}



		public function show_compliant(Request $request)
        {
             if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->MemberContactNo;
					
					$refund_report = DB::select("SELECT * FROM refund_report WHERE MEMBERID=".$USER." ORDER BY REFUND_ID DESC ");
					$ERRMSG="USER RECHARGE COMPLAINT REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'COMPLAINT_DATA'=>$refund_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}
			/**
			* Method name	: Check Bill
			* @description 	: Used to Check Bill
			* @param		: Request data  
			* @return		: Get Check Bill array with response message
		*/
		public function check_bill(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token1=explode('_',$authrization); 
				$token=$token1[0];
				$device_id=$token1[1];
				$apitoken="";$userid="";$url="";
				$password="";$number="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				
				$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;
				$customer_num1="";$account1="";$number1="";$amount1="";$opt1="";
				$customer_num1=$request->has('customer_number')?'1':'0';
				$account1=$request->has('account')?'1':'0';
				$number1=$request->has('number')?'1':'0';
				$amount1=$request->has('amount')?'1':'0';
				
				$opt1=$request->has('opt')?'1':'0';
				$agentid ='123456789';
				$format  ='json';
				$ip=$request->server('REMOTE_ADDR');
				$fullurl=$request->fullUrl();
				$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('$token','$agentid','$ip','$fullurl','',1)");		
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select(	"SELECT * FROM `m11_user` WHERE `m11_user_api_token`='".$token."' AND `m11_user_device_token`='".$device_id."' AND `m11_user_status`='ACTIVE'");
					
					if($this->isError== FALSE)
					{
						if($number1==0 || $opt1==0)
						{
							$ERRMSG = "Parameter missing or not blank.";
							$this->isError= TRUE;
							$ERRCODE="warning";

						}
						else if($request->input('number')=='')
						{
							$ERRMSG = "Number should be valid.";
							$this->isError= TRUE;
							$ERRCODE="success";
							$userData ='';
						}
						else if(trim($request->input('opt')) == '')
						{
							$ERRMSG = "Operator Code should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($agentid) == '')
						{
							$ERRMSG = "Agent id should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($format) == '')
						{
							$ERRMSG = "Format should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else
						{
							$number=$request->input('number');
							$account=$request->input('account');
							$amount =$request->input('amount');
							$customer_number =$request->input('customer_number');
							$opcode  =$request->input('opt');
							$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_code`='".$opcode."' AND `m04_tc_brand_status`='Active' LIMIT 1");
							$brand_id=$opcode_id[0]->BRAND_ID;
							$service_id=$opcode_id[0]->SERVICE_ID;
							$ERRMSG = "D.";
							$this->isError= FALSE;
							$ERRCODE="success";
							$userData =$opcode_id[0]->BRAND_ID.'_'.$service_id;
						}
					}
					if($this->isError== FALSE)
					{
						/*$rechreq=array(
						'proc'=>'5','user_id'=>$login_detail[0]->RegId,'mobile'=>$account,'operator'=>$brand_id,'amount'=>$amount,'requesttype'=>2,'servicetype'=>$service_id,'agentid'=>'','format'=>'json','timelimit'=>'900','defaultstatus'=>'2'
						);	
						$rechreq_report=DB::select('CALL dorecharge(				
						:proc,:user_id,:mobile,:operator,:amount,:requesttype,:servicetype,:agentid,:format,:timelimit,:defaultstatus,@msg,@msg2
						)',$rechreq);
						$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
						$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
						$DB_ERROR[0]->ERROR*/
						if("Success"!="Error")
						{
							/*$transid=$DB_ERRMSG[0]->ERR_MSG;
							foreach($rechreq_report as $row)
							{						
								break;
							}
									$operatorcode=$row->oper_code;*/
									$operatorcode="PSPCL";
									$res_rbid="2598223";
								/*	if($operatorcode==235 || $operatorcode==241 || $operatorcode==319 || $operatorcode==332 || $operatorcode==334 || $operatorcode==342 || $operatorcode==344 || $operatorcode==503 || $operatorcode==505 || $operatorcode== 504|| $operatorcode==522 || $operatorcode==523 || $operatorcode==542 || $operatorcode==543 || $operatorcode==544 ||$operatorcode==548 )
									{
										$make_str ="SESSION=$transid\r\nNUMBER=$number\r\nACCOUNT=$account\r\nAuthenticator3=LLI\r\nAMOUNT=$amount\r\nAMOUNT_ALL=$amount\r\nCOMMENT=Utility Bill Payment";
									}
									else
									{
									     $make_str ="SESSION=$transid\r\nNUMBER=$number\r\nAMOUNT=$amount\r\nAMOUNT_ALL=$amount\r\nCOMMENT=Utility Bill Payment";
									}
							 $operatorcode;
						     $querString = CyberPlat::post_data($make_str);
							 $get_response = CyberPlat::bill_hitting_url($querString,$operatorcode);
							 $ERROR =  CyberPlat::response_extract($get_response,'ERROR');
							 $RESULT =  CyberPlat::response_extract($get_response,'RESULT');
							if($ERROR!="" && $ERROR!=null)
							{
								if(($ERROR==0 && $RESULT==0 ))
								{
									$PRICE = CyberPlat::response_extract($get_response,'PRICE'); 
									$ERRMSG =$PRICE;
									$ERRCODE="success";
									$this->isError= FALSE;
									$status1="SUCCESS";
								}
								else if(($ERROR==23 && $RESULT==1))
								{
									$ERRMSG =CyberPlat::response_extract($get_response,'ERRMSG'); 
									$ERRCODE="error";
									$this->isError= FALSE;
									$status1="FAILED";

								}
								else if(($ERROR==7 && $RESULT==1) || ($ERROR==0 && $RESULT==0 ))
								{
									
									$PRICE = CyberPlat::response_extract($get_response,'PRICE'); 
									$ERRMSG =$PRICE;
									$ERRCODE="success";
									$this->isError= FALSE;
									$status1="SUCCESS";
								}
								else
								{
									$ERRMSG=CyberPlat::response_extract($get_response,'errmsg');
									$this->isError= TRUE;
									$ERRCODE="error";
								}
							}
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>"BILL DATA" ,
							'STATUS'=>trim($status1),
							'ACCOUNT'=>trim($account),
							'NUMBER'=>trim($number),
							'AGENTID'=>trim($agentid),
							'BILL_AMOUNT'=>trim($ERRMSG),
							'TID'=>trim($DB_ERRMSG[0]->ERR_MSG)
							
							]);*/
							$url = 'https://www.mplan.in/api/electricinfo.php';
                    		$params = array(
                    			'apikey'=>'6360068463b3dc88cad9ef6ab942f889',
                    			'offer'=>'roffer',
                    			'tel'=>$number,
                    			'operator'=>$opcode
                    		);
                         	$response=Helper::_curl_execute('GET',$url,$params);
                         	$json=json_decode($response,true);
                         	
                                if($json['records'][0]['status']==1)
                                {
                                     		return response()->json([
                                							'ERROR'=>'SUCCESS',
                                							'MSG' =>"BILL DATA" ,
                                							'STATUS'=>trim($json['records'][0]['status']),
                                							'ACCOUNT'=>trim($json['tel']),
                                							'NUMBER'=>trim($json['records'][0]['CustomerName']),
                                							'BILLNO'=>trim($json['records'][0]['BillNumber']),
                                							'BILL_AMOUNT'=>triM($json['records'][0]['Billamount']),
                                							'DUEDATE'=>trim($json['records'][0]['Duedate'])
                                							]);
                                }
                                else
                                {
                                    	return response()->json([
                                							'ERROR'=>'SUCCESS',
                                							'MSG' =>"BILL DATA" ,
                                							'STATUS'=>trim($json['records'][0]['status']),
                                							'ACCOUNT'=>trim($json['tel']),
                                							'DESC'=>trim($json['records'][0]['desc'])
                                							]);
                                    
                                }
						}
						else
						{	
							$ERRMSG = $DB_ERRMSG[0]->ERR_MSG;
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';	
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
						}
					}
					else
					{
					return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
			
		}

	/**
			* Method name	: check_roffer
			* @description 	: Used to Get Roffer on user number
			* @param		: Request data  
			* @return		: Get ROffer Details data array with response message
		*/
		public function check_roffer(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$details="";
				$device_id='';$userData="";
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$apitoken="0035e12b2628d608fe38f5c8456e8536";
				$mobileno1="";$amount1="";$opt1="";$opcode="";$mobileno="";
				$mobileno1=$request->has('mobile')?'1':'0' ;
				$opt1=$request->has('opt')?'1':'0' ;
				$opcode=$request->input('opt');
				$mobileno=$request->input('mobile');
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError== FALSE)
				{
					if($request->input('mobile')=='')
					{
						$ERRMSG = "Mobile no should be valid.";
						$this->isError= TRUE;
						$ERRCODE="success";
						$userData ='';
					}
					else if(!$this->valid_phone_number($request->input('mobile')))
					{
						$ERRMSG = "Mobile no should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else if(trim($opcode) == '')
					{
						$ERRMSG = "Operator Code should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else
					{
						$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_code`='".$opcode."' AND `m04_tc_brand_status`='Active' LIMIT 1");
						$brand_id=$opcode_id[0]->BRAND_ID;
						$service_id=$opcode_id[0]->SERVICE_ID;
						$ERRMSG = "D.";
						$this->isError= FALSE;
						$ERRCODE="success";
						$userData =$opcode_id[0]->BRAND_ID.'_'.$service_id;
						$details = DB::select("CALL recharge_report(2,'".$mobileno."','','','1970-01-01','1970-01-01',5,1,'1',@msg)");
					}
				}
				if($this->isError=== FALSE)
				{
					$rechreq=array(
					'proc'=>'3',
					'user_id'=>$login_detail[0]->RegId,
					'mobile'=>$mobileno,
					'operator'=>$brand_id,
					'amount'=>0.000,
					'requesttype'=>1,
					'servicetype'=>1,
					'agentid'=>'123456789',
					'format'=>'json',
					'timelimit'=>(config('INTERVAL_RECHARGE')*60),
					'defaultstatus'=>'2'
					);	
					$rechreq_report=DB::select('CALL dorecharge(				
					:proc,
					:user_id,
					:mobile,
					:operator,
					:amount,
					:requesttype,
					:servicetype,
					:agentid,
					:format,
					:timelimit,
					:defaultstatus,
					@msg,
					@msg2
					)',$rechreq);
					
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
				
					if($DB_ERROR[0]->ERROR!="Error")
					{
						$transid=$DB_ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($mobileno!="")
						$url=str_replace('@account',$mobileno,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						//echo $url.'</br>';
						//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
						$result=Helper::_curl_execute('GET',$url,'');
						$json=json_decode($result,true);

						if(isset($json['records']))
						{
							$userData =$json['records'];
						}
						else
						{
							$userData =array();
						}
			
						$ERRMSG = "ROFFER FETCH SUCCESSFULLY";
						$this->isError= FALSE;
						$ERRCODE="success";
					}
					
						return response()->json([
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG,
									'ROFFER'=>$userData,
									'LAST5TRANSACTION'=>$details,
									]);							
				}
				
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}	
			
		}
		
		/**
			* Method name	: dth_info
			* @description 	: Used to Get DTH Customer Details 
			* @param		: Request data  
			* @return		: Get Customer Details data array with response message
		*/
		public function check_dthinfo(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$apitoken="0035e12b2628d608fe38f5c8456e8536";
				$mobileno1="";$amount1="";$opt1="";$opcode="";$cardnumber="";
				$mobileno1=$request->has('mobile')?'1':'0' ;
				$opt1=$request->has('opt')?'1':'0' ;
				$opcode=$request->input('opt');
				$cardnumber=$request->input('cardnumber');
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError== FALSE)
				{
					if($request->input('cardnumber')=='')
					{
						$ERRMSG = "Card Number should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else if(trim($opcode) == '')
					{
						$ERRMSG = "Operator Code should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else
					{
						$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_code`='".$opcode."' AND `m04_tc_brand_status`='Active' LIMIT 1");
						$brand_id=$opcode_id[0]->BRAND_ID;
						$service_id=$opcode_id[0]->SERVICE_ID;
						$ERRMSG = "D.";
						$this->isError= FALSE;
						$ERRCODE="success";
						$userData =$opcode_id[0]->BRAND_ID.'_'.$service_id;
					}
				}
				if($this->isError === FALSE)
				{
					
					$rechreq=array(
					'proc'=>'5',
					'user_id'=>$login_detail[0]->RegId,
					'mobile'=>$cardnumber,
					'operator'=>$brand_id,
					'amount'=>0.000,
					'requesttype'=>1,
					'servicetype'=>$service_id,
					'agentid'=>'123456789',
					'format'=>'json',
					'timelimit'=>(config('INTERVAL_RECHARGE')*60),
					'defaultstatus'=>'2'
					);	
					$rechreq_report=DB::select('CALL dorecharge(				
					:proc,
					:user_id,
					:mobile,
					:operator,
					:amount,
					:requesttype,
					:servicetype,
					:agentid,
					:format,
					:timelimit,
					:defaultstatus,
					@msg,
					@msg2
					)',$rechreq);
					
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					//dd($DB_ERRMSG[0]->ERR_MSG);
					if($DB_ERROR[0]->ERROR!="Error")
					{
						$transid=$DB_ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($cardnumber!="")
						$url=str_replace('@account',$cardnumber,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						//echo $url.'</br>';
						//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
						$result=Helper::_curl_execute('GET',$url,'');
						$json=json_decode($result,true);
						$userData =$json['records'];
						$ERRMSG = "DTH INFO FETCH SUCCESSFULLY";
						$this->isError= FALSE;
						$ERRCODE="success";
					}
						if(!array_key_exists('status',$userData))
						{
						return response()->json([
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG,
									'DTHINFO'=>$userData
									]);					
						}
						else
						{
										$ERRMSG = "CARD NUMBER IS NOT VALID";
										$ERRCODE="error";
										return response()->json([
										'ERROR'=>$ERRCODE,
										'MSG' =>$ERRMSG 
										]);
						}
				}
				
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}	
			
		}
		
		
		
		
		/**
			* Method name	: Pay Bill
			* @description 	: Used to Pay Bill
			* @param		: Request data  
			* @return		: Get Pay Bill array with response message
		*/
		public function pay_bill(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$apitoken="";$userid="";$url="";
				$password="";$number="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				
				$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;
				$customer_num1="";$account1="";$number1="";$amount1="";$opt1="";
				$customer_num1=$request->has('customer_number')?'1':'0';
				$account1=$request->has('account')?'1':'0';
				$number1=$request->has('number')?'1':'0';
				$amount1=$request->has('amount')?'1':'0';
				$opt1=$request->has('opt')?'1':'0';
				$agentid ='123456789';
				$format  ='json';
				$ip=$request->server('REMOTE_ADDR');
				$fullurl=$request->fullUrl();
				$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('$token','$agentid','$ip','$fullurl','',1)");		
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					
					if($this->isError== FALSE)
					{
						if($customer_num1==0 || $account1==0 || $number1==0 || $amount1==0 || $opt1==0)
						{
							$ERRMSG = "Parameter missing or not blank.";
							$this->isError= TRUE;
							$ERRCODE="warning";

						}
						else if(!$this->valid_phone_number($request->input('customer_number')))
						{
							$ERRMSG = "Customer Mobile no should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if($request->input('account')=='')
						{
							$ERRMSG = "Account should be valid.";
							$this->isError= TRUE;
							$ERRCODE="success";
							$userData ='';
						}
						/*else if($request->input('number')=='')
						{
							$ERRMSG = "Number should be valid.";
							$this->isError= TRUE;
							$ERRCODE="success";
							$userData ='';
						}*/
						else if(trim($request->input('amount')) == '' || trim(floatval($request->input('amount')))<=0.00)
						{
							$ERRMSG = "Amount should be valid or not blank.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($request->input('opt')) == '')
						{
							$ERRMSG = "Operator Code should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($agentid) == '')
						{
							$ERRMSG = "Agent id should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($format) == '')
						{
							$ERRMSG = "Format should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else
						{
							$number=$request->input('number');
							$account=$request->input('account');
							$amount =$request->input('amount');
							$customer_number =$request->input('customer_number');
							$opcode  =$request->input('opt');
							$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_code`='".$opcode."' AND `m04_tc_brand_status`='Active' LIMIT 1");
							$brand_id=$opcode_id[0]->BRAND_ID;
							$service_id=$opcode_id[0]->SERVICE_ID;
							$ERRMSG = "D.";
							$this->isError= FALSE;
							$ERRCODE="success";
							$userData =$opcode_id[0]->BRAND_ID.'_'.$service_id;
						}
					}
					if($this->isError== FALSE)
					{
						
						$rechreq=array(
						'proc'=>'1',
						'user_id'=>$login_detail[0]->RegId,
						'mobile'=>$number,
						'account'=>$account,
						'operator'=>$brand_id,
						'amount'=>$amount,
						'requesttype'=>2,
						'servicetype'=>$service_id,
						'agentid'=>'',
						'format'=>'json',
						'timelimit'=>(config('INTERVAL_RECHARGE')*60),
						'defaultstatus'=>'2'
						);	
						$rechreq_report=DB::select('CALL pay_bill(				
						:proc,
						:user_id,
						:mobile,
						:account,
						:operator,
						:amount,
						:requesttype,
						:servicetype,
						:agentid,
						:format,
						:timelimit,
						:defaultstatus,
						@msg,
						@msg2
						)',$rechreq);
						//print_r( $rechreq);
						//dd();
						$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
						$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
						
						if($DB_ERROR[0]->ERROR!="Error")
						{
							$transid=$DB_ERRMSG[0]->ERR_MSG;
							foreach($rechreq_report as $row)
							{						
								break;
							}
							$url=$row->url_address;	
							$operatorcode=$row->oper_code;
							$apiid=$row->apiid;
							if($apitoken!="")
							$url=str_replace('@apitoken',$apitoken,$url);
							if($userid!="")
							$url=str_replace('@userid',$userid,$url);
							if($password!="")
							$url=str_replace('@password',$password,$url);
							if($account!="")
							$url=str_replace('@account',$account,$url);
							if($amount!="")
							$url=str_replace('@amount',$amount,$url);
							if($operatorcode!="")
							$url=str_replace('@operatorcode',$operatorcode,$url);
							if($DB_ERROR[0]->ERROR!="Error")
							$url=str_replace('@refrence',$DB_ERRMSG[0]->ERR_MSG,$url);
							if($format!="")
							$url=str_replace('@format',$format,$url);
							if($param1!="")
							$url=str_replace('@param1',$param1,$url);
							if($param2!="")
							$url=str_replace('@param2',$param2,$url);
							//echo $url.'</br>';
							//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
							$response=Helper::_curl_execute('GET',$url,'');
                            $res_rbid="2598223";
							//PRINT_R($ERRMSG[0]->ERR_MSG);
							
							
							$rechres=array(
							'proc'=>'2',
							'user_id'=>$login_detail[0]->RegId,
							'mobile'=>$transid,
							'account'=>$account,
							'operator'=>$response,
							'amount'=>$amount,
							'requesttype'=>2,
							'servicetype'=>$service_id,
							'agentid'=>$res_rbid,
							'format'=>'json',
							'timelimit'=>(config('INTERVAL_RECHARGE')*60),
							'defaultstatus'=>'2'
							);
							$rechres_report=DB::select('CALL pay_bill(				
							:proc,
							:user_id,
							:mobile,
							:account,
							:operator,
							:amount,
							:requesttype,
							:servicetype,
							:agentid,
							:format,
							:timelimit,
							:defaultstatus,
							@msg,
							@msg2
							)',$rechres);
							if($res_status=="SUCCESS" || $res_status=="Success" )
							{
								$status1="SUCCESS";
								$status2=1;
							}
							if($res_status=="PENDING" || $res_status=="Pending")
							{
								$status1="PENDING";
								$status2=2;
							}
							if($res_status=="FAILED" || $res_status=="Failed")
							{
								$status1="FAILED";
								$status2=4;
							}
							$respreport=array(
							'proc'=>1,
							'userid'=>$login_detail[0]->RegId,
							'account'=>$account,
							'transid'=>$transid,
							'liveid'=>$res_opid,
							'amt'=>$amount,
							'recstatus'=>$status2,
							'descrip'=>1							
							);
							$resquery = DB::select('CALL recharge_statusupdate(
							:proc,
							:userid,
							:account,
							:transid,
							:liveid,
							:amt,
							:recstatus,
							:descrip,
							@resmsg)',$respreport);
							$ERRMSG = "BILL PAYMENT IS ".$status1." TRANSACTION ID- ".$DB_ERRMSG[0]->ERR_MSG;
							$this->isError= FALSE;
							$ERRCODE="success";
							$userData =$DB_ERRMSG[0]->ERR_MSG;
							
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'STATUS'=>trim($status1),
							'ACCOUNT'=>trim($account),
							'NUMBER'=>trim($number),
							'AMOUNT'=>trim($amount),
							'AGENTID'=>trim($agentid),
							'OPID'=>trim($res_opid),
							'TID'=>trim($DB_ERRMSG[0]->ERR_MSG),
							'BAL'=>trim(floatval(0.00))
							]);
						}
						else
						{	
							$ERRMSG = $DB_ERRMSG[0]->ERR_MSG;
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';	
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
						}
					}
					else
					{
					return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
			
		}

		public function show_downlineladger(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
			
				$downline_mobileno="";
				$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
				$ladegerstatus="-1";$descrip="";
				
				$fromdate=$request->has('fromdate')?'1':'0' ;
				$todate=$request->has('todate')?'1':'0' ;
				$downline_mobileno=$request->has('contact_no')?'1':'0' ;
				
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($fromdate==0 || $todate==0 || $downline_mobileno==0 )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('contact_no')=='')
					{
						$ERRMSG = "Downline Mobile no should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=Helper::get_userid($request->input('contact_no'));
					
					
					$ladger=array(
							'proc'=>'2',
							'account'=>'',
							'transid'=>'',
							'userid'=>$USER,
							'fromdate'=>date('Y-m-d',strtotime($request->input('fromdate'))),
							'todate'=>date('Y-m-d',strtotime($request->input('todate'))),
							'noofrecords'=>100,
							'ladegerstatus'=>1,
							'descrip'=>1,
							);
							$ladger_report=DB::select('CALL ledger(				
							:proc,
							:account,
							:transid,
							:userid,
							:fromdate,
							:todate,
							:noofrecords,
							:ladegerstatus,
							:descrip,
							@msg
							)',$ladger);
					$ERRMSG="USER LADGER REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'LADGER_DATA'=>$ladger_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}
		public function show_downlinerecharge(Request $request)
        {
             if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
			
				$downline_mobileno="";
				$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
				$recstatus="-1";$descrip="1";
				$fromdate=$request->has('fromdate')?'1':'0' ;
				$todate=$request->has('todate')?'1':'0' ;
				$downline_mobileno=$request->has('contact_no')?'1':'0' ;
				$account=$request->has('account')?'1':'0' ;
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($fromdate==0 || $todate==0 || $account==0 || $downline_mobileno==0 )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('contact_no')=='')
					{
						$ERRMSG = "Downline Mobile no should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=Helper::get_userid($request->input('contact_no'));
					
					$recharge=array(
							'proc'=>'3',
							'account'=>$request->input('account'),
							'transid'=>'',
							'userid'=>$USER,
							'fromdate'=>date('Y-m-d',strtotime($request->input('fromdate'))),
							'todate'=>date('Y-m-d',strtotime($request->input('todate'))),
							'noofrecords'=>100,
							'recstatus'=>-1,
							'descrip'=>1
							);
							$recharge_report=DB::select('CALL recharge_report(				
							:proc,
							:account,
							:transid,
							:userid,
							:fromdate,
							:todate,
							:noofrecords,
							:recstatus,
							:descrip,
							@msg
							)',$recharge);
					$ERRMSG="USER RECHARGE REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'REC_DATA'=>$recharge_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}


		public function buy_coin(Request $request)
		{

			$user = Helper::get_userbscaddress_by_usercode($request->txt_bscaddress);

			if(!empty($user))
			{
				$request->merge(['m11_user_id' => (int)$user]);
			}

			$request->merge(['trans_id' => 'TXN-' .$request->m11_user_id. time()]);
			$validation = Validator::make($request->all(),[
	            'm11_user_id' => 'required|integer|exists:m11_user,m11_user_id',
	            // 'service_id' => 'required|in:BUY,SELL',
	            // 'txn_number' => 'required|string|max:20',
	            // 'txn_coin_unit' => 'required|numeric|min:1',
	            // 'txn_coin_current_amount' => 'required|numeric|min:0',
	            'txn_amount' => 'required|numeric|min:1',
	            // 'txn_mode' => 'required|in:SELF API,P2P',
	            // 'm12_api_id' => 'required|in:Api1,KMPAISA,UNIQUEEBAZAAR,A1RECHARGE,ROCKET SOFTECH,POWERMONEY,Api6,Api7,Api8,Api9,Api10,Api11,Api12,Api13,Api14,Api15,Api16,Api17,Api18,Api19,Api20',
	            // 'tr53_txn_status' => 'required|in:SUCCESS,PENDING,FOR REFUND,FAILED,REFUNDED,REJECT,RSUCCESS',
	            'trans_id' => 'required|string|unique:tr53_coin_buysell_detail,tr53_trans_id',
	            'api_txnid' => 'required|string|unique:tr53_coin_buysell_detail,tr53_txn_number',
	            // 'tr53_refre_id' => 'nullable|string',
	            // 'tr53_oper_id' => 'nullable|string',
	            // 'tr53_request_type' => 'nullable|in:Via Panel,Via MobileApp,Via API,Via SMS',
	            // 'tr53_amount_for' => 'nullable|in:CREDIT,DEBIT,RECHARGE,REFUND,REFUNDED,REJECT,RSUCCESS,OPENING,CLOSING',
	            'remarks' => 'nullable|string',
	            // 'm22_affiliate_id' => 'nullable|integer',
	            // 'tr53_txn_apicommision' => 'nullable|numeric',
	            // 'tr53_txn_sdcommision' => 'nullable|numeric',
	            // 'tr53_txn_mdcommision' => 'nullable|numeric',
	            // 'tr53_txn_dcommision' => 'nullable|numeric',
	            // 'tr53_txn_rtcommision' => 'nullable|numeric',
	            // 'tr53_txn_commision' => 'nullable|numeric',
	            // 'tr53_txn_commisionby_api' => 'nullable|numeric',
	            // 'tr53_txn_prebal' => 'nullable|numeric',
	            // 'tr53_txn_postbal' => 'nullable|numeric',
	            // 'tr53_txn_iscircle_route' => 'nullable|integer',
	            // 'tr53_txn_isdenomination_route' => 'nullable|integer',
	            // 'm30_employee_id' => 'nullable|integer',
		    ],[
		    	'm11_user_id.required' => 'wallet address not registered.',
		    	'm11_user_id.integer' => 'wallet address not registered.',
		    	'm11_user_id.exists' => 'wallet address not registered.',
		    ]);

		    if($validation->fails()){
		    	
				return response()->json([
						'ERROR'=>"warning",
						'MSG' =>$validation->messages()->first(),
						'ERRORS' => $validation->errors(),
						]);
		    } else{

		      	$check = DB::table('tr53_coin_buysell_detail')->insert([
														    'm22_affiliate_id' => 1,
														    'tr53_trans_id' => $request->trans_id,
														    'tr53_api_txnid' => $request->api_txnid,
														    // 'tr53_refre_id' => 'REF123',
														    // 'tr53_oper_id' => 'OPER001',
														    'm11_user_id' => $request->m11_user_id,
														    'tr53_request_type' => 'Via API',
														    'tr53_service_id' => 'BUY',
														    'm98_cy_coin_id' => 1,
														    'm99_currency_id' => 1,
														    'tr53_txn_number' => $request->api_txnid,
														    'tr53_amount_for' => 'CREDIT',
														    'tr53_txn_coin_unit' => $request->txn_amount,
														    'tr53_txn_coin_current_amount' => $request->txn_amount,
														    'tr53_txn_amount' => $request->txn_amount,
														    'tr53_txn_mode' => 'SELF API',
														    'm12_api_id' => 1,
														    'tr53_txn_status' => 'SUCCESS',
														    'tr53_remarks' => 'Buy coin transaction completed',
														    'tr53_txn_iscircle_route' => 0,
														    'tr53_txn_isdenomination_route' => 0,
														    'm30_employee_id' => 0,
														]);
      			if($check) {
		      		return response()->json([
						'ERROR'=>"success",
						'MSG' =>"Your transaction ".$request->api_txnid." was successful.." 
					]);
		      	} else {
		      		return response()->json([
						'ERROR'=>"error",
						'MSG' =>"Transaction failed. Please try again." 
					]);
		      	}
		    }
		}

		public function sell_coin(Request $request)
		{

			$user = Helper::get_userbscaddress_by_usercode($request->txt_bscaddress);

			if(!empty($user))
			{
				$request->merge(['m11_user_id' => (int)$user]);
			}

			$request->merge(['trans_id' => 'TXN-' .$request->m11_user_id. time()]);
			$validation = Validator::make($request->all(),[
	            'm11_user_id' => 'required|integer|exists:m11_user,m11_user_id',
	            // 'service_id' => 'required|in:BUY,SELL',
	            // 'txn_number' => 'required|string|max:20',
	            // 'txn_coin_unit' => 'required|numeric|min:1',
	            // 'txn_coin_current_amount' => 'required|numeric|min:0',
	            'txn_amount' => 'required|numeric|min:1',
	            // 'txn_mode' => 'required|in:SELF API,P2P',
	            // 'm12_api_id' => 'required|in:Api1,KMPAISA,UNIQUEEBAZAAR,A1RECHARGE,ROCKET SOFTECH,POWERMONEY,Api6,Api7,Api8,Api9,Api10,Api11,Api12,Api13,Api14,Api15,Api16,Api17,Api18,Api19,Api20',
	            // 'tr53_txn_status' => 'required|in:SUCCESS,PENDING,FOR REFUND,FAILED,REFUNDED,REJECT,RSUCCESS',
	            'trans_id' => 'required|string|unique:tr53_coin_buysell_detail,tr53_trans_id',
	            // 'api_txnid' => 'required|string|unique:tr53_coin_buysell_detail,tr53_txn_number',
	            // 'tr53_refre_id' => 'nullable|string',
	            // 'tr53_oper_id' => 'nullable|string',
	            // 'tr53_request_type' => 'nullable|in:Via Panel,Via MobileApp,Via API,Via SMS',
	            // 'tr53_amount_for' => 'nullable|in:CREDIT,DEBIT,RECHARGE,REFUND,REFUNDED,REJECT,RSUCCESS,OPENING,CLOSING',
	            'remarks' => 'nullable|string',
	            // 'm22_affiliate_id' => 'nullable|integer',
	            // 'tr53_txn_apicommision' => 'nullable|numeric',
	            // 'tr53_txn_sdcommision' => 'nullable|numeric',
	            // 'tr53_txn_mdcommision' => 'nullable|numeric',
	            // 'tr53_txn_dcommision' => 'nullable|numeric',
	            // 'tr53_txn_rtcommision' => 'nullable|numeric',
	            // 'tr53_txn_commision' => 'nullable|numeric',
	            // 'tr53_txn_commisionby_api' => 'nullable|numeric',
	            // 'tr53_txn_prebal' => 'nullable|numeric',
	            // 'tr53_txn_postbal' => 'nullable|numeric',
	            // 'tr53_txn_iscircle_route' => 'nullable|integer',
	            // 'tr53_txn_isdenomination_route' => 'nullable|integer',
	            // 'm30_employee_id' => 'nullable|integer',
		    ],[
		    	'm11_user_id.required' => 'wallet address not registered.',
		    	'm11_user_id.integer' => 'wallet address not registered.',
		    	'm11_user_id.exists' => 'wallet address not registered.',
		    ]);

		    if($validation->fails()){
		    	
				return response()->json([
						'ERROR'=>"warning",
						'MSG' =>$validation->messages()->first(),
						'ERRORS' => $validation->errors(),
						]);
		    } else{

		    	$amount = DB::table('tr53_coin_buysell_detail')
							    ->where('m11_user_id', $request->m11_user_id)
							    ->selectRaw("
							        SUM(CASE WHEN tr53_amount_for = 'CREDIT' AND tr53_txn_status = 'SUCCESS' THEN tr53_txn_amount ELSE 0 END) -
							        SUM(CASE WHEN tr53_amount_for = 'DEBIT' AND tr53_txn_status IN ('SUCCESS', 'PENDING') THEN tr53_txn_amount ELSE 0 END) AS remaining_balance
							    ")->value('remaining_balance');

		    	if((float)$amount >= (float)$request->txn_amount) {
			      	$check = DB::table('tr53_coin_buysell_detail')->insert([
															    'm22_affiliate_id' => 1,
															    'tr53_trans_id' => $request->trans_id,
															    'tr53_api_txnid' => '',
															    // 'tr53_refre_id' => 'REF123',
															    // 'tr53_oper_id' => 'OPER001',
															    'm11_user_id' => $request->m11_user_id,
															    'tr53_request_type' => 'Via API',
															    'tr53_service_id' => 'SELL',
															    'm98_cy_coin_id' => 1,
															    'm99_currency_id' => 1,
															    'tr53_txn_number' => '',
															    'tr53_amount_for' => 'DEBIT',
															    'tr53_txn_coin_unit' => (float)$request->txn_amount,
															    'tr53_txn_coin_current_amount' => $request->txn_amount,
															    'tr53_txn_amount' => $request->txn_amount,
															    'tr53_txn_mode' => 'SELF API',
															    'm12_api_id' => 1,
															    'tr53_txn_status' => 'PENDING',
															    'tr53_remarks' => 'Buy coin transaction completed',
															    'tr53_txn_iscircle_route' => 0,
															    'tr53_txn_isdenomination_route' => 0,
															    'm30_employee_id' => 0,
															]);
			      	if($check) {
			      		return response()->json([
							'ERROR'=>"success",
							'MSG' =>"Thank you. Your transaction ".$request->trans_id." has been processed." 
						]);
			      	} else {
			      		return response()->json([
							'ERROR'=>"error",
							'MSG' =>"Transaction failed. Please try again." 
						]);
			      	}
		    	} else {
					return response()->json([
						'ERROR'=>"error",
						'MSG' =>"Transaction failed. Reason: Coin unit is too low." 
					]);
		    	}

		    }
		}

		public function buy_subscription(Request $request)
		{
            if($_SERVER['REQUEST_METHOD']=="POST")
            {
				
				$token='';
				$device_id='';
				
				$ddfor_wallet=0;$txt_balance="";$for_wallet="";$mobileno="";$dd_package="";$packageamt="";
				$txt_balance=$request->has('txt_balance')?'1':'0' ;
				$for_wallet=$request->has('dd_user_forwallet')?'1':'0' ;
				$mobileno=$request->has('txt_mobileno')?'1':'0' ;
				$dd_package=$request->has('dd_package')?'1':'0' ;
				$packageamt=$request->has('txt_packageamt')?'1':'0' ;
				
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($txt_balance==0 || $for_wallet==0||$mobileno==0||$dd_package==0||$packageamt==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_bscaddress')=="")
					{
						$ERRMSG = "wallet address should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					$contactno=$request->input('txt_bscaddress');
					// if(strlen($contactno)!=10)
					// {
					// 	$ERRMSG = "Member contact number should be equal to 10 digit.";
					// 	$isError = TRUE;
					// 	$ERRCODE="warning";
					// }
					$user = Helper::get_userbscaddress_by_userid($contactno);
					if(empty($user))
					{
						$ERRMSG = "wallet address not registered.";
						$isError = TRUE;
						$ERRCODE="warning";
					}
					// else if($request->input('dd_user_forwallet')=="" || $request->input('dd_user_forwallet')=='-1' )
					// {
					// 	$ERRMSG = "Please select user for wallet deduction.";
					// 	$this->isError= TRUE;
					// 	$ERRCODE="warning";
					// }
					// else if((floatval($request->input('txt_balance'))=="" || floatval($request->input('txt_balance'))<0.00) && $request->input('dd_user_forwallet')==0 )
					// {
					// 	$ERRMSG = "Member balance should be valid";
					// 	$this->isError= TRUE;
					// 	$ERRCODE="warning";
					// }
					// else if($request->input('dd_package')=="" || $request->input('dd_package')==-1 )
					// {
					// 	$ERRMSG = "Package should be valid";
					// 	$this->isError= TRUE;
					// 	$ERRCODE="warning";
					// }
					else if(floatval($request->input('txt_packageamt'))=="" || floatval($request->input('txt_packageamt'))==0.00 )
					{
						$ERRMSG = "Package amount be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError= FALSE;
						$ERRCODE="success";
					}
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					// if($request->input('dd_user_forwallet')!=0)
					// {
					// 	$ddfor_wallet=$login_detail[0]->RegId;
					// }
//$request->input('txt_packageamt')

						$topup=array(
						  	'proc'=>1,
							'txt_userid'=>$user,
							'dd_package'=>$request->input('dd_package'),
							'package_amt'=>$request->input('txt_packageamt'),
							'dd_user_forwallet'=>1,
							'dd_wallet'=>1,
							'txt_remark'=>$request->input('hash'),
							'dd_mode'=>1
						);
	                 
					  $topup_report = DB::select('CALL topup(:proc,:txt_userid,:dd_package,:package_amt,:dd_user_forwallet,:dd_wallet,:txt_remark,:dd_mode,@status_code,@status_msg)',$topup);
					  $DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
	                  $DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					  $ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
					  $ERRMSG=$DB_ERRMSG[0]->ERR_MSG;

					// $topup=array(
					// 'proc'=>1,
					// 'txt_userid'=>$contactno,
					// 'dd_package'=>$request->input('dd_package'),
					// 'dd_user_forwallet'=>$ddfor_wallet,
					// 'dd_wallet'=>1,
					// );
					// $topup_report = DB::select('CALL topup(:proc,:txt_userid,:dd_package,:dd_user_forwallet,:dd_wallet,@status_code,@status_msg)',$topup);
					// $DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					// $DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					// $ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
					// $ERRMSG=$DB_ERRMSG[0]->ERR_MSG;

					if($ERRCODE=='success'){
						return response()->json([
						'ERROR'=>$ERRCODE,
						'STATUS'=>'SUCCESS',
						'MSG' =>$ERRMSG 
						]);
					}
					else
					{
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
					
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				
			}
		}
		
		public function renew_subscription(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$ddfor_wallet=0;$txt_balance="";$for_wallet="";$mobileno="";$dd_package="";$packageamt="";
				$txt_balance=$request->has('txt_balance')?'1':'0' ;
				$for_wallet=$request->has('dd_user_forwallet')?'1':'0' ;
				$mobileno=$request->has('txt_mobileno')?'1':'0' ;
				$dd_package=$request->has('dd_package')?'1':'0' ;
				$packageamt=$request->has('txt_packageamt')?'1':'0' ;
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($txt_balance==0|| $for_wallet==0||$mobileno==0||$dd_package==0||$packageamt==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_mobileno')=="")
					{
						$ERRMSG = "Mobile no should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					$contactno=explode(' ',$request->input('txt_mobileno'));
					if(strlen($contactno[0])!=10)
					{
						$ERRMSG = "Member contact number should be equal to 10 digit.";
						$isError = TRUE;
						$ERRCODE="warning";
					}
					$user = Helper::get_userid($contactno[0]);
					if(empty($user))
					{
						$ERRMSG = "Member should be valid";
						$isError = TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_user_forwallet')=="" || $request->input('dd_user_forwallet')=='-1' )
					{
						$ERRMSG = "Please select user for wallet deduction.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if((floatval($request->input('txt_balance'))=="" || floatval($request->input('txt_balance'))<0.00) && $request->input('dd_user_forwallet')==0 )
					{
						$ERRMSG = "Member balance should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_package')=="" || $request->input('dd_package')==-1 )
					{
						$ERRMSG = "Package should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_packageamt'))=="" || floatval($request->input('txt_packageamt'))==0.00 )
					{
						$ERRMSG = "Package amount be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError= FALSE;
						$ERRCODE="success";
					}
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					if($request->input('dd_user_forwallet')!=0)
					{
					$ddfor_wallet=$login_detail[0]->RegId;
					}
					$topup=array(
					'proc'=>1,
					'txt_userid'=>$contactno[0],
					'dd_package'=>$request->input('dd_package'),
					'dd_user_forwallet'=>$ddfor_wallet
					);
					$topup_report = DB::select('CALL retopup(:proc,:txt_userid,:dd_package,:dd_user_forwallet,@status_code,@status_msg)',$topup);
					$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					$ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
					$ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
					
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				
			}
		}	
		
		public function show_topup(Request $request)
        {
			
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
				$recstatus="-1";$descrip="1";
				
				$txt_bscaddress=$request->has('txt_bscaddress')?'1':'0' ;
				
				if($this->isError==FALSE)
				{
					if($txt_bscaddress==0 )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_bscaddress')=="")
					{
						$ERRMSG = "wallet address should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$contactno=$request->input('txt_bscaddress');
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					
					$USER= Helper::get_userbscaddress_by_usercode($contactno);
					
					$recharge=array(
					'proc'=>'1',
					'userid'=>$USER,
					'fromdate'=>date('Y-m-d',strtotime('2025-01-01')),
					'todate'=>date('Y-m-d'),
					'noofrecords'=>1000,
					'topstatus'=>1,
					'descrip'=>'`tr19_user_topup`.`m11_user_id`='.$USER.' AND 1'
					);
					
					$recharge_report=DB::select('CALL topup_report(				
					:proc,
					:userid,
					:fromdate,
					:todate,
					:noofrecords,
					:topstatus,
					:descrip,
					@msg
					)',$recharge);
					$ERRMSG="USER TOPUP REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'TOPUP_DATA'=>$recharge_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}
		
	
		
		
		public function user_downline(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					DB::select("CALL get_intro_downline(".$login_detail[0]->RegId.")");
					$level= DB::select("SELECT member_id,level_id FROM tmp_downline");
					$userrec=array(
					'proc'=>7,
					'userid'=>'`m11_user`.`m11_user_id` IN (SELECT member_id FROM tmp_downline)',
					);
					$user_rec= DB::select('CALL enrolluser(:proc,:userid,@msg)',$userrec);
					return response()->json([
					'ERROR'=>'succress',
					'MSG' =>'Downline fetch Successfully',
					'DOWNLINE_DATA'=>$user_rec
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
					
				}
			
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				
			}
		}

	public function dmt_login(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$mobileno="";
				$mobileno=$request->has('contact_no')?'1':'0' ;
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($mobileno==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('contact_no')=='')
					{
						$ERRMSG = "Mobile no should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(!$this->valid_phone_number($request->input('contact_no')))
					{
						$ERRMSG = "Mobile no should be valid or numeric.";
						$this->isError= TRUE;
						$ERRCODE="error";
						
					}
					else if(strlen($request->input('contact_no'))<10)
					{
						$ERRMSG = "Mobile no should be sequal to 10 digit.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('contact_no'))>10)
					{
						$ERRMSG = "Mobile no should be equal to 10 digit.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError= FALSE;
						$ERRCODE="success";
					}
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$dmt_user = "";
					$get_useralldetail ="";
					$userid = Helper::get_dmtuser_by_mobile($request->input('contact_no'));
					if($userid!=FALSE)
					{
						$dmt_user = Helper::get_dmtuserdetail($userid);
						$get_useralldetail = Helper::get_user_bene_detail($userid);
						$ERRMSG = "USER DMT DETAILS";
						$ERRCODE="success";
						return response()->json([
										'ERROR'=>$ERRCODE,
										'MSG' =>$ERRMSG,
										'DMT_DETAILS'=>$dmt_user,
										'BENEFICIARY'=>$get_useralldetail
							]);
					}
					else
					{
						$ERRMSG = "Mobile no is not registered with us.Please check mobile no.";
						$this->isError=TRUE;
						$ERRCODE="warning";
							return response()->json([
											'ERROR'=>$ERRCODE,
											'MSG' =>$ERRMSG
								]);
					}
					
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				
			}
		}
		public function dmt_userregister(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$Firstname="";$Lastname="";$contactno="";$email="";$dob="";$location="";$pincode="";$bankproof="";$gstno ="";
				$Firstname=$request->has('Firstname')?'1':'0';
				$Lastname=$request->has('Lastname')?'1':'0';
				$contactno=$request->has('contact_no')?'1':'0';
				$dob=$request->has('DateofBirh')?'1':'0';
				$location=$request->has('Address')?'1':'0';	
				$pincode=$request->has('Pincode')?'1':'0';
				if($token=='')
				{
					$ERRMSG ="Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
				if($this->isError==FALSE)
				{
					if($Firstname==0 || $Lastname==0 || $contactno==0 ||  $dob==0 || $location==0 || $pincode==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('Firstname')=='')
					{
						$ERRMSG = "First Name should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('Lastname')=='')
					{
						$ERRMSG = "First Name should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('contact_no')=='')
					{
						$ERRMSG = "User Contact should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					
					else if($request->input('DateofBirh')=='')
					{
						$ERRMSG = "User Date of birth should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('Address')=='')
					{
						$ERRMSG = "Location should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('Pincode')=='')
					{
						$ERRMSG = "Pincode should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
				
					$pass=rand(100000,999999);
					$pinpass=rand(100000,999999);
					$signup_data=array(
						'proc'=>1,
						'm57_remitter_id'=>0,
						'm57_remitter_code'=>'',
						'm22_affiliate_id'=>1,
						'm57_first_name'=> $request->input('Firstname'),
						'm57_last_name'=> $request->input('Lastname'),
						'm57_remitter_name'=> $request->input('Firstname').' '.$request->input('Lastname'),
						'm57_remitter_dob'=>date('Y-m-d',strtotime($request->input('DateofBirh'))),
						'm57_remitter_gender'=> 1,
						'm57_remitter_email'=>'',
						'm57_remitter_contactno'=> $request->input('contact_no'),
						'm57_remitter_location'=> $request->input('Pincode').'-'.$request->input('Address'),
						'm57_remitter_state'=> '',
						'm57_remitter_city'=> '',
						'm57_remitter_postalcode'=> '',
						'm57_remitter_status'=>1,
						'm57_remitter_islogin'=> 2,
						'm57_remitter_referral_code'=>$login_detail[0]->RegId
					);
					$response= $this->dmt_proc_repo->create($signup_data); 
					return response()->json([
						'ERROR'=>$response['err_code'],
						'MSG' =>$response['err_msg']
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
	    }
		public function add_beneficiary(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$mobileno="";$txt_nameatbank=""; $txt_bankname=""; $txt_cbsacno=""; $txt_bankbranch=""; $txt_bankifsccode="";
				$mobileno=$request->has('contact_no')?'1':'0' ;
				$txt_nameatbank=$request->has('txt_nameatbank')?'1':'0' ;
				$txt_bankname=$request->has('txt_bankname')?'1':'0' ;
				$txt_cbsacno=$request->has('txt_cbsacno')?'1':'0' ;
				$txt_bankbranch=$request->has('txt_bankbranch')?'1':'0' ;
				$txt_bankifsccode=$request->has('txt_bankifsccode')?'1':'0' ;
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($mobileno==0 || $txt_nameatbank==0 || $txt_bankname==0 || $txt_cbsacno==0 || $txt_bankbranch==0 || $txt_bankifsccode==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					
					}
					else if($request->input('contact_no')=='')
					{
						$ERRMSG = "Mobile no should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(!$this->valid_phone_number($request->input('contact_no')))
					{
						$ERRMSG = "Mobile no should be valid or numeric.";
						$this->isError= TRUE;
						$ERRCODE="error";
						
					}
					else if(strlen($request->input('contact_no'))<10)
					{
						$ERRMSG = "Mobile no should be sequal to 10 digit.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('contact_no'))>10)
					{
						$ERRMSG = "Mobile no should be equal to 10 digit.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_nameatbank')=='' )
					{
						$ERRMSG = "Member Name at Bank should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_bankname')=='')
					{
						$ERRMSG = "Member Bank Name should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_cbsacno')=='')
					{
						$ERRMSG = "Member Bank no Account should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_bankbranch')=='')
					{
						$ERRMSG = "Member Bank Branch should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_bankifsccode')=='')
					{
						$ERRMSG = "Member Bank IFSCode should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
				
					else
					{
						$ERRMSG = "";
						$this->isError= FALSE;
						$ERRCODE="success";
					}
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$dmt_user = "";
					$get_useralldetail ="";
					$ACCOUNTNO=$request->input('txt_cbsacno');
					$userid = Helper::get_dmtuser_by_mobile($request->input('contact_no'));
					if($userid!=FALSE)
					{
						
						$arr = array(
						'm57_remitter_id'=>$userid,
						'm28_bene_nameat_bank'=>$request->input('txt_nameatbank'),
						'm28_bene_cbsacno' =>$request->input('txt_cbsacno'),
						'm01_bank_name'=>$request->input('txt_bankname'),
						'm28_bene_branch'=>$request->input('txt_bankbranch'),
						'm28_bene_ifscode' =>$request->input('txt_bankifsccode')
						);
						DB::table('m28_b2cuser_beneficiary')->insert($arr);
						$bank_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('m11_user','','$ACCOUNTNO','$userid','USER S BENEFICIARY HAS BEEN ADDED SUCCESSFULLY!')");	
						$dmt_user = Helper::get_dmtuserdetail($userid);
						$get_useralldetail = Helper::get_user_bene_detail($userid);
						$ERRMSG="USER'S BENEFICIARY HAS BEEN ADDED  SUCCESSFULLY!";
						$ERRCODE='success';	
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG,
							'DMT_DETAILS'=>$dmt_user,
							'BENEFICIARY'=>$get_useralldetail
						]);
					}
					else
					{
						$ERRMSG = "Mobile no is not registered with us.Please check mobile no.";
						$this->isError=TRUE;
						$ERRCODE="warning";
						return response()->json([
											'ERROR'=>$ERRCODE,
											'MSG' =>$ERRMSG
								]);
					}
					
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				
			}
		}
		
		public function payto_bank(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$beneficiaryname=""; $contactno="";$amount="";$orderId="";
				$beneficiaryAccount="";$beneficiaryIFSC="";$purpose="";
				$callbackUrl="";$comments="";$agentid="";
				
				$beneficiaryname	=$request->has('beneficiaryname')?'1':'0';
				$contactno			=$request->has('contactno')?'1':'0';
				$amount			    =$request->has('amount')?'1':'0';
				$beneficiaryAccount	=$request->has('beneficiaryAccount')?'1':'0';
				$beneficiaryIFSC	=$request->has('beneficiaryIFSC')?'1':'0';
				$purpose			=$request->has('purpose')?'1':'0';	
				$callbackUrl		=$request->has('callbackUrl')?'1':'0';
				$agentid            =$request->has('agentid')?'1':'0';
				
				if($token=='')
				{
					$ERRMSG ="Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$this->isError=FALSE;
						    $ERRCODE="success";
							
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($this->isError==FALSE)
				{
					if($beneficiaryname==0 || $contactno==0 || $beneficiaryAccount==0 || $beneficiaryIFSC==0 || $purpose==0 ||$agentid==0 || $callbackUrl==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneficiaryname')=='')
					{
						$ERRMSG = "Beneficiary Name should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('contactno')=='')
					{
						$ERRMSG = "User Contact should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('amount')=='')
					{
						$ERRMSG = "Amount should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneficiaryAccount')=='')
					{
						$ERRMSG = "Beneficiary Account should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneficiaryIFSC')=='')
					{
						$ERRMSG = "Beneficiary IFSCODE should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('purpose')=='')
					{
						$ERRMSG = "Purpose should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('callbackUrl')=='')
					{
						$ERRMSG = "Call backurl should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$dmr_req=array(
					'proc'=>'1',
					'm11_user_id'=>$login_detail[0]->RegId,
					'trans_id'=>'',
					'refre_id'=>'',
					'request_no'=>'',
					'mobile_no'=>$request->input('contactno'),
					'amount'=>$request->input('amount'),
					'payment_id'=>'',
					'payment_status'=>'',
					'impsrefno'=>'',
					'message'=>'',
					'remarks'=>'',
					'account_number'=>$request->input('beneficiaryAccount'),
					'beneficiary_code'=>'',
					'beneficiary_name'=>$request->input('beneficiaryname'),
					'account_type'=>'',
					'ifsc'=>$request->input('beneficiaryIFSC'),
					'bank_name'=>'',
					'branch_name'=>'',
					'address'=>'',
					'state'=>'',
					'city'=>'',
					'agentid'=>$request->input('agentid'),
					'payctransid'=>'',
					'topup_charge'=>'0.00',
					'transfer_status'=>'2'
					);	
					$dmrreq_response=DB::select('CALL doremmitance(				
					:proc,
					:m11_user_id,
					:trans_id,
					:refre_id,
					:request_no,
					:mobile_no,
					:amount,
					:payment_id,
					:payment_status,
					:impsrefno,
					:message,
					:remarks,
					:account_number,
					:beneficiary_code,
					:beneficiary_name,
					:account_type,
					:ifsc,
					:bank_name,
					:branch_name,
					:address,
					:state,
					:city,
					:agentid,
					:payctransid,
					:topup_charge,
					:transfer_status,
					@msg,
					@msg2
					)',$dmr_req);
					
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					if($DB_ERROR[0]->ERROR!="error")
					{
						$transid=$DB_ERRMSG[0]->ERR_MSG;
						$token=""; 
								$dmr_req=array(
								'proc'=>'3',
								'm11_user_id'=>$login_detail[0]->RegId,
								'trans_id'=>'',
								'refre_id'=>'',
								'request_no'=>'',
								'mobile_no'=>$request->input('contactno'),
								'amount'=>$request->input('amount'),
								'payment_id'=>'',
								'payment_status'=>'',
								'impsrefno'=>'',
								'message'=>'',
								'remarks'=>'',
								'account_number'=>$request->input('beneficiaryAccount'),
								'beneficiary_code'=>'',
								'beneficiary_name'=>$request->input('beneficiaryname'),
								'account_type'=>'',
								'ifsc'=>$request->input('beneficiaryIFSC'),
								'bank_name'=>'',
								'branch_name'=>'',
								'address'=>'',
								'state'=>'',
								'city'=>'',
								'agentid'=>$request->input('agentid'),
								'payctransid'=>'',
								'topup_charge'=>'0.00',
								'transfer_status'=>'2'
								);	
								$dmrreq_response=DB::select('CALL doremmitance(				
								:proc,
								:m11_user_id,
								:trans_id,
								:refre_id,
								:request_no,
								:mobile_no,
								:amount,
								:payment_id,
								:payment_status,
								:impsrefno,
								:message,
								:remarks,
								:account_number,
								:beneficiary_code,
								:beneficiary_name,
								:account_type,
								:ifsc,
								:bank_name,
								:branch_name,
								:address,
								:state,
								:city,
								:agentid,
								:payctransid,
								:topup_charge,
								:transfer_status,
								@msg,
								@msg2
								)',$dmr_req);

								$DB_ERRMSG1=DB::select('SELECT @msg as ERR_MSG');
								$DB_ERROR1=DB::select('SELECT @msg2 as ERROR');
								
								return response()->json([
									'ERROR'=>$DB_ERROR1[0]->ERROR,
									'MSG' =>$DB_ERRMSG1[0]->ERR_MSG,
									'REMARK'=>$transid
								]);
					}
					else
					{
						return response()->json([
						'ERROR'=>$DB_ERROR[0]->ERROR,
						'MSG' =>$DB_ERRMSG[0]->ERR_MSG 
						]);
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
	    }

/*public function verify_account(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$beneficiaryname=""; $contactno="";$amount="";$orderId="";
				$beneficiaryAccount="";$beneficiaryIFSC="";$purpose="";
				$callbackUrl="";$comments="";$agentid="";

				$beneficiaryAccount	=$request->has('beneficiaryAccount')?'1':'0';
				$beneficiaryIFSC	=$request->has('beneficiaryIFSC')?'1':'0';
	
				if($token=='')
				{
					$ERRMSG ="Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$this->isError=FALSE;
						    $ERRCODE="success";
							
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($this->isError==FALSE)
				{
					if($beneficiaryAccount==0 || $beneficiaryIFSC==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					
					
					else if($request->input('beneficiaryAccount')=='')
					{
						$ERRMSG = "Beneficiary Account should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneficiaryIFSC')=='')
					{
						$ERRMSG = "Beneficiary IFSCODE should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
						$transid='202002200152338872';
						$ACCOUNTNO=$request->input('beneficiaryAccount');
						$IFSCODE=$request->input('beneficiaryIFSC');
						$token=""; 
						$url="https://uniqueestore.in//public/"; 
						//$url=$url."api/v1/apiverify_account";
						$data=json_encode(array(
								 'beneficiaryAccount'=>	$ACCOUNTNO,
								 'beneficiaryIFSC'=>$IFSCODE
							 ));
						$header_data=array(
														"Content-Type:application/json",
														"Authorization:".$token.""
													);
					$method="POST";
					if($method=="POST")
					{
						$curl = curl_init();
							curl_setopt_array($curl, array
							(
							CURLOPT_URL => $url,
							CURLOPT_RETURNTRANSFER => true,
							CURLOPT_ENCODING => "",
							CURLOPT_MAXREDIRS => 10,
							CURLOPT_TIMEOUT => 30,
							CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
							CURLOPT_CUSTOMREQUEST => "POST",
							CURLOPT_POSTFIELDS =>$data,
							CURLOPT_HTTPHEADER =>$header_data
							));
						$result = curl_exec($curl);
						if(!$result)
						{
							$result=trigger_error(curl_error($curl));
							curl_close($curl);
							print_r($result);
						}
						else
						{	                
							curl_close($curl);
						   // print_r($result);
						}
							$json=json_decode($result,true);
							if($json['ERROR']!="error")
							{
							$ACCOUNTNO=$request->input('txt_cbsacno');
								$userid = Helper::get_userid($request->input('contact_no'));
								if($userid!=FALSE)
								{
									
									$arr = array(
									'm11_user_id'=>$userid,
									'm28_bene_nameat_bank'=>$json['MSG'],
									'm28_bene_cbsacno' =>$request->input('txt_cbsacno'),
									'm01_bank_name'=>$request->input('txt_bankname'),
									'm28_bene_branch'=>$request->input('txt_bankbranch'),
									'm28_bene_ifscode' =>$request->input('txt_bankifsccode')
									);
									DB::table('m28_b2cuser_beneficiary')->insert($arr);
									$bank_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('m11_user','','$ACCOUNTNO','$userid','USER S BENEFICIARY HAS BEEN ADDED SUCCESSFULLY!')");	
									$dmt_user = Helper::get_userdetail($userid);
									$get_useralldetail = Helper::get_user_bene_detail($userid);
									 $ERRMSG=$json['MSG'];
									$ERRCODE=$json['ERROR'];
									return response()->json([
										'ERROR'=>$ERRCODE,
										'MSG' =>$ERRMSG,
										'DMT_DETAILS'=>$dmt_user,
										'BENEFICIARY'=>$get_useralldetail
									]);
								}
								else
								{
									$ERRMSG = "Mobile no is not registered with us.Please check mobile no.";
									$this->isError=TRUE;
									$ERRCODE="warning";
									return response()->json([
														'ERROR'=>$ERRCODE,
														'MSG' =>$ERRMSG
											]);
								}	
					        

								return response()->json([
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG,
									'REMARK'=>$ERRMSG
								]);
							}
							else
							{
								$ERRMSG=$json['MSG'];
								$ERRCODE=$json['ERROR'];
								return response()->json([
								'ERROR'=>$ERRCODE,
								'MSG' =>$ERRMSG 
								]);
							}
				}
				else
				{
					return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
	    }}*/


public function show_dmr(Request $request)
{
             if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
			

				$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
				$recstatus="-1";$descrip="1";
				
				$fromdate=$request->has('fromdate')?'1':'0' ;
				$todate=$request->has('todate')?'1':'0' ;
				$transid=$request->has('transid')?'1':'0' ;
				$noofrecords=$request->has('noofrecords')?'1':'0' ;
				$account=$request->has('account')?'1':'0' ;
				$recstatus=$request->has('recstatus')?'1':'0' ;
				$descrip=$request->has('descrip')?'1':'0' ;
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($fromdate==0 || $todate==0 || $transid==0 || $noofrecords==0 || $account==0 || $recstatus==0 || $descrip==0  )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('fromdate')=='')
					{
						$ERRMSG = "Form date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('todate')=='')
					{
						$ERRMSG = "To date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('noofrecords')=='')
					{
						$ERRMSG = "No of records should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('recstatus')=='')
					{
						$ERRMSG = "Ledger type should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('descrip')=='')
					{
						$ERRMSG = "Description should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					
					$dmr=array(
							'proc'=>'2',
							'account'=>$request->input('account'),
							'transid'=>$request->input('transid'),
							'userid'=>$USER,
							'fromdate'=>date('Y-m-d',strtotime($request->input('fromdate'))),
							'todate'=>date('Y-m-d',strtotime($request->input('todate'))),
							'noofrecords'=>$request->input('noofrecords'),
							'recstatus'=>$request->input('recstatus'),
							'descrip'=>$request->input('descrip')
							);
							$dmr_report=DB::select('CALL dmr_report(				
							:proc,
							:account,
							:transid,
							:userid,
							:fromdate,
							:todate,
							:noofrecords,
							:recstatus,
							:descrip,
							@msg
							)',$dmr);
					$ERRMSG="USER DMR REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'DMT_DATA'=>$dmr_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}

		public function delete_beneficiary(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$remmiterId=""; $contactno="";
				$callbackUrl="";$comments="";$agentid="";
				$remmiterId	=$request->has('remmiterId')?'1':'0';
				$beneId			=$request->has('beneId')?'1':'0';
				if($token=='')
				{
					$ERRMSG ="Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$this->isError=FALSE;
						    $ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($this->isError==FALSE)
				{
					if($remmiterId==0 || $beneId==0 )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('remmiterId')=='')
					{
						$ERRMSG = "Remitter Id should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('beneId')=='')
					{
						$ERRMSG = "Beneficiary Id should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$request->input('remmiterId');
					$BENEID=$request->input('beneId');
					DB::select("UPDATE m28_b2cuser_beneficiary SET `m28_bene_status`=3 WHERE m28_bene_id=".$BENEID." and m57_remitter_id=".$USER."");
					$bank_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('m28_b2cuser_beneficiary','$USER','','$BENEID','USER S BENEFICIARY HAS BEEN DELETED SUCCESSFULLY!')");		
					$ERRMSG="USER'S BENEFICIARY HAS BEEN DELETE SUCCESSFULLY!";
					$ERRCODE='success';	
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				}
				else
				{
					return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
	    }
		
		
		
		
		
	public function forget_password(Request $request)
    {

        if(request()->method() == 'POST')
        {
					if(trim($request->input('txt_username')) == '')
					{
					    $ERRMSG = "Mobile no should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else
					{
						$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `RegCode`='".$request->input('txt_username')."' AND MemberStatus='Active'");
						if($login_detail)
						{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							$this->isError= FALSE;
						}
						else
						{
							$ERRMSG = "USER DETAILS NOT FIND.";
							$ERRCODE="error";
							$this->isError= TRUE;
						}
					}
					if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
					{
							/*$message=rand(10000,99999);*/
											$message='123456';
						$msg="Please submit this code ".$message." to verify your account.";
						$user_logindetails=DB::update("UPDATE `tr04_login` SET `tr04_otp` =".$message." WHERE `m11_user_contactno`='".$request->input('txt_username')."'");
						if($user_logindetails==1)
						{
											// SMS SEND OR INSERT
											$sms_data['MOBILE_NO'] = $login_detail[0]->MemberContactNo;
											$sms_data['SUBJECT'] = 'App forget password';
											$sms_data['MESSAGE'] = $msg;
											$sms_data['TYPE'] = 2;
											$sms_data['SEND_BY'] = 2;
											$sms_data['SEND_BY_ID'] = $login_detail[0]->RegId;
											Helper::send_sms_or_log($sms_data);
											//SMS SEND END 

							$ERRMSG = "Please check your E-mail account OR Mobile No to verify OTP.";
							$ERRCODE = "success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG,
							'MOBILE'=>trim($request->input('txt_username'))
							]);
						}
						else
						{
							$ERRMSG = "USER DETAILS NOT FIND.";
							$ERRCODE="error";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG
							
							]);
							
						}
					}
					else
					{
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG
							
							]);
					}
		}
        else 
        {	
		return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>"Invalid Method , Please try again."
							]);
        }
    }
	
		public function verify_fpotp(Request $request)
		{

			if(request()->method() == 'POST')
			{
				if(trim($request->input('txt_username')) == '')
				{
					$ERRMSG = "Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if($request->input('txt_otp')=='')
				{
					$ERRMSG = "OTP should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `RegCode`='".$request->input('txt_username')."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
						$this->isError= FALSE;
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
					
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$otp_detail = DB::select("SELECT `tr04_otp` as Token FROM `tr04_login` WHERE `m11_user_contactno` ='".$request->input('txt_username')."'");
					if($otp_detail)
					{
						if($request->input('txt_otp')==$otp_detail[0]->Token)
						{
							$message=rand(10000,999999);
							$pssin = Hash::make($message);
							$msg="Your account password has been reset successfully. Please login to your account with Member Code :".$request->input('txt_username')." Password : ".$message ." .";
							$user_logindetails=DB::update("UPDATE `tr04_login` SET `tr04_login_pwd` ='".$pssin."' WHERE `m11_user_contactno`='".$request->input('txt_username')."'");
							if($user_logindetails==1)
							{
							
											// SMS SEND OR INSERT
											$sms_data['MOBILE_NO'] = $login_detail[0]->MemberContactNo;
											$sms_data['SUBJECT'] = 'Forgot password in App';
											$sms_data['MESSAGE'] = $msg;
											$sms_data['TYPE'] = 2;
											$sms_data['SEND_BY'] = 2;
											$sms_data['SEND_BY_ID'] = $login_detail[0]->RegId;
											Helper::send_sms_or_log($sms_data);
											//SMS SEND END 

								$ERRMSG = "Password Reset Successfully .Please login you account..";
								$ERRCODE = "success";
								return response()->json([
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG,
									'MOBILE'=>trim($request->input('txt_username'))
									]);
							}
							else
							{
								$ERRMSG = "USER DETAILS NOT FIND.";
								$ERRCODE="error";
								return response()->json([
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG
								]);
							}
						}
						else
						{
							$ERRMSG = "OTP NOT VALID.";
							$ERRCODE="error";
							$this->isError= TRUE;
							return response()->json([
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG
								]);
						}
					}
					else
					{
							$ERRMSG = "OTP HAS NOT BEEN GENERATES FOR THIS USER.PLEASE TRY AGAIN";
							$ERRCODE="error";
							$this->isError= TRUE;
							return response()->json([
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG
								]);
					}
					
				}
				else
				{
					return response()->json([
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG
								]);
				}
			}
			else 
			{	
				return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>"Invalid Method , Please try again."
							]);
			}
		}
		

	public function send_sms($mob,$msg)
	{
		$url = Config('SMS_SEND_URL');
		$params = array(
			'user'=>Config('SMS_AUTH'),
			'password'=>Config('SMS_PWD'),
			'msisdn'=>$mob,
			'sid'=>Config('SMS_SENDERID'),
			'msg'=>$msg, 	 	 
			'fl'=>0,	 	 	 
			'gwid'=>2	 	 
		);
     	Helper::_curl_execute('GET',$url,$params);
	}


		public function show_content(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$content_for=$request->has('content_for')?'1':'0';	
		        $cond ="";
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($content_for==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('content_for')=="")
					{
						$ERRMSG = "Content for sholud be valid or not blank. ";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}	
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					$content=$request->input('content_for');
					$cond = $cond."`m11_user`.`m11_user_referral_code`=". $USER." AND 1 ORDER BY `m11_user`.`m11_user_role` ,`m11_user`.`m11_user_onadd`";
					$static_content=DB::select("SELECT * FROM `m10_static_content` WHERE `m10_staticcnt_variable`= '".$content."' AND m10_affilate_id =".$login_detail[0]->Affid);
					$ERRMSG="STATIC CONTENT SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'CONTENT_DATA'=>(!empty($static_content[0]->m10_staticcnt_content))?$static_content[0]->m10_staticcnt_content:''
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}

		
		public function show_aeps(Request $request)
        {
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				
				
				$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
				$recstatus="-1";$descrip="1";
				
				$fromdate=$request->has('fromdate')?'1':'0' ;
				$todate=$request->has('todate')?'1':'0' ;
				$transid=$request->has('transid')?'1':'0' ;
				$noofrecords=$request->has('noofrecords')?'1':'0' ;
				$account=$request->has('account')?'1':'0' ;
				$recstatus=$request->has('recstatus')?'1':'0' ;
				$descrip=$request->has('descrip')?'1':'0' ;
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($fromdate==0 || $todate==0 || $transid==0 || $noofrecords==0 || $account==0 || $recstatus==0 || $descrip==0  )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('fromdate')=='')
					{
						$ERRMSG = "Form date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('todate')=='')
					{
						$ERRMSG = "To date should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('noofrecords')=='')
					{
						$ERRMSG = "No of records should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('recstatus')=='')
					{
						$ERRMSG = "Ledger type should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('descrip')=='')
					{
						$ERRMSG = "Description should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					
					$aeps=array(
					'proc'=>1,
					'account'=>$request->input('account'),
					'transid'=>$request->input('transid'),
					'userid'=>$login_detail[0]->RegId,
					'fromdate'=>date('Y-m-d',strtotime($request->input('fromdate'))),
					'todate'=>date('Y-m-d',strtotime($request->input('todate'))),
					'noofrecords'=>$request->input('noofrecords'),
					'recstatus'=>$request->input('recstatus'),
					'descrip'=>$request->input('descrip')
					);
					$aeps_report=DB::select('CALL aeps_report(				
					:proc,
					:account,
					:transid,
					:userid,
					:fromdate,
					:todate,
					:noofrecords,
					:recstatus,
					:descrip,
					@msg
					)',$aeps);
					$ERRMSG="USER AEPS REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'AEPS_DATA'=>$aeps_report
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}


public function show_aeps_settelment(Request $request)
        {
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				
				
				$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
				$recstatus="-1";$descrip="1";
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;
					
					$team=DB::select("SELECT get_family_tree($USER) AS TEAM");
					$withdraw_req_toadmin=DB::select("SELECT * FROM withdraw_request WHERE FUNDREQ_TO=1 AND USER_ID IN(".$team[0]->TEAM.")");
					$ERRMSG="USER AEPS SETTLEMENT REPORT FETCH SUCCESSFULLY!";
					$ERRCODE='success';	
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG,
					'AEPS_DATA'=>$withdraw_req_toadmin
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}

		public function aeps_amount_settelment(Request $request)
        {
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				
				
				$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
				$recstatus="-1";$descrip="1";

				$amount=$request->has('txt_amount')?'1':'0' ;
				$baltypeto=$request->has('baltypeto')?'1':'0' ;
				
				
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00 || floatval($request->input('txt_amount'))<300.00)
					{
						$ERRMSG = "Amount should be greater than 300.00 or not be blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_amount'))<0.00)
					{
						$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('baltypeto')=='')
					{
						$wr_mode=1;
					}
					else
					{
						$wr_mode=$request->input('baltypeto');
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{

				$userinfo = Helper::get_useralldetail($login_detail[0]->RegId);
				$ben_id = 'MAD'.$userinfo[0]->CBSACno;
				$dmr_req=array(
				'proc'=>'1',
				'm11_user_id'=>$login_detail[0]->RegId,
				'trans_id'=>'',
				'refre_id'=>'',
				'request_no'=>'',
				'mobile_no'=>$login_detail[0]->MemberContactNo,
				'amount'=>$request->input('txt_amount'),
				'payment_id'=>'',
				'payment_status'=>'',
				'impsrefno'=>'',
				'message'=>'',
				'remarks'=>'',
				'account_number'=>$userinfo[0]->CBSACno,
				'beneficiary_code'=>$ben_id,
				'beneficiary_name'=>$userinfo[0]->NAMEatBANK,
				'account_type'=>'',
				'ifsc'=>$userinfo[0]->IFSCode,
				'bank_name'=>$userinfo[0]->BANK_NAME,
				'branch_name'=>$userinfo[0]->Branch,
				'address'=>'',
				'state'=>'',
				'city'=>'',
				'agentid'=>'',
				'payctransid'=>'',
				'topup_charge'=>'0.00',
				'transfer_status'=>'2');
			
				$dmrreq_response=$this->dmt_proc_repo->doRemmitance($dmr_req);
				
				$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
				$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
				$ERRCODE=$DB_ERROR[0]->ERROR;
				$ERRMSG =$DB_ERRMSG[0]->ERR_MSG;

				if($ERRCODE=="success")
				{
					$response = Helper::cashfreePayoutAuthorize();
					
					if(isset($response->data->token))
					{
						$data = [	
									"beneId" =>  $ben_id,
									"amount"=> $request->input('txt_amount'), 
									"transferId" => $ERRMSG,
									"remarks" => $ben_id." YOUR WITHDRAW REQUEST SUCCESS"
								];
								
						$Token = $response->data->token;
						$url = "https://payout-api.cashfree.com/payout/v1/requestTransfer";
						$responses = Helper::cashfreePayoutVerifyOrder($url, $data, $Token);
						$response = json_decode($responses);

						$accountId = 0;
						if(isset($response->data->referenceId))
						{
							$accountId = $response->data->referenceId;
						}
						$liveid = 0;
						if(isset($response->data->utr))
						{
							$liveid = $response->data->utr;
						}

						$txt_status=$response->status;

						if($txt_status=="SUCCESS")
						{
							$status1="SUCCESS";
							$status2=1;
						}
						if($txt_status=="PENDING")
						{
							$status1="PENDING";
							$status2=2;
						}
						if($txt_status=="ERROR")
						{
							$status1="ERROR";
							$status2=4;
						}
						
						$respreport=array(
									'proc'=>2,
									'userid'=>$login_detail[0]->RegId,
									'account'=>$accountId,
									'transid'=>$ERRMSG,
									'liveid'=>$liveid,
									'amt'=>round(floatval($request->input('txt_amount'))),
									'recstatus'=>$status2,
									'descrip'=>$responses
								);

						$resquery = $this->dmt_proc_repo->dmrStatusUpdate($respreport);

						if($txt_status == 'SUCCESS')
						{
							$ERRCODE=strtolower($txt_status);
							$ERRMSG =$response->message.' Txn : '.$ERRMSG;
						}
						else
						{
							$ERRCODE=strtolower($txt_status);
							$ERRMSG =$response->message;
						}
					}
				}
				
				return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);

	/*				$USER=$login_detail[0]->RegId;
					$AFFid=$login_detail[0]->Affid;
					$fundreq=array('proc'=>2,
					'm23_user_bnkid'=>0,
					'm11_user_id'=>$USER,
					'tr26_wr_towallet'=>3,
					'tr26_wr_mode'=>$wr_mode,
					'tr26_wr_utrno'=>'',
					'tr26_wr_amount'=>floatval($request->input('txt_amount')),
					'tr26_wr_transid'=>'',
					'tr26_wr_des'=>'',
					'tr26_wr_admin_res'=>'',
					'tr26_wr_status'=>1,
					'tr26_wr_toadmin'=>1,
					'm11_user_referral_code'=>0,
					'm22_affiliate_id'=>$AFFid
					);
					$fund_request=DB::select('CALL withdraw_request(:proc,:m23_user_bnkid,:m11_user_id,:tr26_wr_towallet,:tr26_wr_mode,:tr26_wr_utrno,:tr26_wr_amount,:tr26_wr_transid,:tr26_wr_des,:tr26_wr_admin_res,:tr26_wr_status,:tr26_wr_toadmin,:m11_user_referral_code,:m22_affiliate_id,@status_code,@status_msg
					)',$fundreq);
					$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					$ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
					$ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG
					]);*/
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}

/**
			* Method name	: Bank Account
			* @description 	: Used to Get Bank Account 
			* @param		: Request data  
			* @return		: Get Bank Account data array with response message
		*/
		public function bank_list(Request $request)
		{
			
			if($_SERVER['REQUEST_METHOD']=="GET")
			{	
				$bank_list = DB::select("SELECT * FROM `bank` WHERE BANK_STATUS=1");
					if($bank_list)
					{
							$ERRMSG = "BANK LIST DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'BANKLIST'=>$bank_list
							]);
					}
					else
					{
						$ERRMSG = "BANK LIST DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
		}

/**
			* Method name	: TopUp Package
			* @description 	: Used to Get TopUp Package
			* @param		: Request data  
			* @return		: Get TopUp Packagedata array with response message
		*/
		public function package_list(Request $request)
		{
			$type = (int)$request->type??'1'; 
			if($_SERVER['REQUEST_METHOD']=="GET")
			{	
				$bank_list = DB::select("SELECT * FROM `package` WHERE PACKAGE_STATUS=1 AND PACKAGE_TYPE = $type");
					if($bank_list)
					{
							$ERRMSG = "PACKAGE LIST DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'PACKAGELIST'=>$bank_list
							]);
					}
					else
					{
						$ERRMSG = "PACKAGE LIST DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
		}


        public function user_upipay(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
			 
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}
				$ladger=""; $baltype=""; $txt_mobileno=""; $txt_amount=""; $txt_cashcolledted=""; 
				$txt_remark=""; $txt_ccremark="";
				$baltype=$request->has('baltype')?'1':'0' ;
				$txt_mobileno=$request->has('txt_mobileno')?'1':'0' ;
				$txt_amount=$request->has('txt_amount')?'1':'0' ;
				$Status=$request->has('Status')?'1':'0' ;
				$txnId=$request->has('txnId')?'1':'0' ;
				$responseCode=$request->has('responseCode')?'1':'0' ;
				$txnRef=$request->has('txnRef')?'1':'0' ;
			
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				//echo $ERRMSG;dd();
				if($this->isError==FALSE)
				{
					if($baltype==0 || $txt_mobileno==0 || $txt_amount==0 || $Status==0 || $txnId==0 || $responseCode==0 || $txnRef==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}	
					else if($request->input('baltype')=="")
					{
						$ERRMSG = "Balance type should be valid.Please Select Balance Type ";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}	
					else if($request->input('txt_mobileno')=='')
					{
						$ERRMSG = "Member contact number should be valid or not blank.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
				    else if(strlen($request->input('txt_mobileno'))!=10)
					{
						$ERRMSG = "Member contact number should be equal to 10 digit.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
					{
						$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_amount'))<0.00)
					{
						$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
						$this->isError = TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>"0".$ERRCODE,
					'MSG' =>'hhh' 
					]);
				}
				if(request()->method() == 'POST' && $this->isError==FALSE && $request->input('Status')=='SUCCESS')
				{
					$USER=$login_detail[0]->RegId;
					
					$fundtransfer_data=array(
					'proc'=>2,
					'to_user_id'=>$USER,
					'from_user_id'=>0,
					'amount'=>floatval($request->input('txt_amount')),
					'collected_amount'=>floatval($request->input('txt_amount')),
					'requesttype'=>4,
					'balfor'=>$request->input('baltype'),
					'transtype'=>1,
					'timelimit'=>(config('INTERVAL_RECHARGE')*60),
					'defaultstatus'=>1,
					'remark'=>$request->input('txnRef'),
					'collected_remark'=>$request->input('txt_mobileno').' Mobile no ,UPI TXNID-'.$request->input('txnId').'and bank Refrence id id-'.$request->input('txnRef')
					);
					$fundtransfer = DB::SELECT('CALL wallettransfer(
					:proc, 
					:to_user_id,
					:from_user_id,
					:amount, 
					:collected_amount,
					:requesttype,
					:balfor,:transtype,
					:timelimit,
					:defaultstatus,
					:remark,
					:collected_remark,
					@status_code,
					@status_msg)'
					,$fundtransfer_data);
					$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					$ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
				//	echo $DB_ERRMSG[0]->ERR_MSG;
					//dd();
					if($ERRCODE=="success")
					{
					$ERRMSG="Your wallet refilled successfully with this amount  ".floatval($request->input('txt_amount'))." by UPI TRANSFER, Transaction id-". $DB_ERRMSG[0]->ERR_MSG ." .";
					}
					else
					{
					$ERRMSG==$DB_ERRMSG[0]->ERR_MSG;
					}
				
				return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}




  public function verify_loginotp(Request $request)
		{

			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				if(trim($request->input('usercode')) == '')
				{
					$ERRMSG = "Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if($request->input('txt_otp')=='')
				{
					$ERRMSG = "OTP should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
				}
				else if($request->input('txt_errorcode')=='')
				{
					$ERRMSG = "Error Code should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `RegCode`='".$request->input('usercode')."'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
						$this->isError= FALSE;
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
					
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					 if($request->input('txt_errorcode')=='103')
					 {
					$otp_detail = DB::select("SELECT `tr04_lb_otp` as Token FROM `tr04_login` WHERE `m11_user_contactno` ='".$request->input('usercode')."'");
					}
					 if($request->input('txt_errorcode')=='104')
					 {
					$otp_detail = DB::select("SELECT `tr04_device_otp` as Token FROM `tr04_login` WHERE `m11_user_contactno` ='".$request->input('usercode')."'");
					}
					if($otp_detail)
					{
						if($request->input('txt_otp')==$otp_detail[0]->Token)
						{   
								 if($request->input('txt_errorcode')=='104')
									$user_logindetails=DB::update("UPDATE `m11_user` SET `m11_user_status` =1 ,`m11_user_device_token`='".$request->input('imei_no')."' WHERE `m11_user_code`='".$request->input('usercode')."'");
									 if($request->input('txt_errorcode')=='103')
									$user_logindetails=DB::update("UPDATE `m11_user` SET `m11_user_status` =1 WHERE `m11_user_code`='".$request->input('usercode')."'");
							
									return response()->json([
												'ERROR_CODE'=>'100',
												'ERROR'=>$ERRCODE,
												'MSG' =>"LOGIN SUCCESSFULLY! WELCOME ".$login_detail[0]->FirstName.' '.$login_detail[0]->LastName,
												'TOKEN'=>trim($login_detail[0]->MemberApiToken)
												]);
						}
						else
						{
							$ERRMSG = "OTP NOT VALID.";
							$ERRCODE="error";
							$this->isError= TRUE;
							return response()->json([
									'ERROR_CODE'=>'000',	
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG
								]);
						}
					}
					else
					{
							$ERRMSG = "OTP HAS NOT BEEN GENERATES FOR THIS USER.PLEASE TRY AGAIN";
							$ERRCODE="error";
							$this->isError= TRUE;
							return response()->json([
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG
								]);
					}
					
				}
				else
				{
					return response()->json([
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG
								]);
				}
			}
			else 
			{	
				return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>"Invalid Method , Please try again."
							]);
			}
		}








    public function get_operators_show(request $request)
    {
    	$phone = '91'.$request->customer_number;
		$countryIsos = 'IN';
		$opcode='';$circlecode='';

		if($request->customer_number == null){ 	
							$ERRMSG = "Customer Number  Required";
							$ERRCODE="error";
							$this->isError= TRUE;
							 }

				if($this->isError==FALSE && $request->method() == 'POST')
					{	
		
		//$url = 'https://api.dingconnect.com/api/V1/GetProviders?countryIsos='.$countryIsos.'&accountNumber='.$phone.'';	CURLOPT_HTTPHEADER=>$request_headers,
		$url='http://planapi.in/api/Mobile/OperatorFetchNew?ApiUserID=3889&ApiPassword=123456&Mobileno='.$request->customer_number.'';
		$host = '';    
	    $request_headers = array("api_key:3945q8QDszn6bTGaMrOVj0");

			$options = array(
			CURLOPT_SSL_VERIFYHOST => 0,
			CURLOPT_SSL_VERIFYPEER => 0
			);
			$defaults = array(
			CURLOPT_URL => $url,
		
			CURLOPT_HEADER => 0,
			CURLOPT_RETURNTRANSFER => TRUE,
			CURLOPT_TIMEOUT =>60
			);

			$ch = curl_init();
			curl_setopt_array($ch, ($options + $defaults));
			$result = curl_exec($ch);
			$json=json_decode($result);

			if(!$result)
			{
				$result=trigger_error(curl_error($ch));
				curl_close($ch);

						$ERRMSG = "DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
			}
			elseif($json->Operator!='')
			{
			$opcode	=$json->OpCode;
			$circlecode=$json->CircleCode;
			curl_close($ch);
		    $opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m07_service_id`,'') as SERVICE_ID FROM `m15_service_provider` WHERE `m15_sp_code`='".$opcode."' AND `m12_api_id`=7 LIMIT 1");
		    $opcode_name = DB::select("SELECT IFNULL(`m04_tc_brand_name`,'') as BRAND_NAME FROM `m04_telecom_brand` WHERE `m04_tc_brand_id`=".$opcode_id[0]->BRAND_ID." LIMIT 1");
					
			$ERRMSG = "DETAILS GET SUCCESSFULLY";
			$ERRCODE="success";
				return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG ,
						'RESPONSE'=>strtoupper($opcode_name[0]->BRAND_NAME),
					]);
			}
			else
			{	                
				curl_close($ch);
						$ERRMSG = "DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
			}
		}else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
    }



		/**
			* Method name	: get last recharge
			* @description 	: Used to Getget last recharge
			* @param		: Request data  
			* @return		: get last recharge Data array with response message
		*/
		public function get_last_recharge(Request $request)
		{

			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}

				$customer_number=$request->customer_number;

				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				elseif($customer_number=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{

					$detail = DB::select("CALL recharge_report(2,'".$customer_number."','','','1970-01-01','1970-01-01',5,1,'1',@msg)");
					if(count($detail) > 0)
					{
							$ERRMSG = "DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'RESPONES'=>$detail
							]);
					}
					else
					{
						$ERRMSG = "DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
		}





		/**
			* Method name	: get content
			* @description 	: Used to Get content
			* @param		: Request data  
			* @return		: get content Data array with response message
		*/
		public function get_content(Request $request)
		{

			if($_SERVER['REQUEST_METHOD']=="POST")
			{

				$ContentType=$request->ContentType;
				$AffilateId=$request->AffilateId;

				if($ContentType=='')
				{
					$ERRMSG = "Content Type should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				elseif($AffilateId=='')
				{
					$ERRMSG = "AffilateId should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$detail = DB::select("SELECT `STCNT_TITLE`,`STCNT_CONTENT` FROM `static_content` WHERE `STCNT_VAR` = '".$ContentType."' AND `STCNT_AFFID` = '".$AffilateId."' AND `STCNT_STATUS` = 'Active'");
					if(count($detail) > 0)
					{
							$ERRMSG = "DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'RESPONES'=>$detail
							]);
					}
					else
					{
						$ERRMSG = "DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				}
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
		}


/**
			* Method name	: Auto Switch
			* @description 	: Used to Status_check Prepaid,DTH,Datacard 
			* @param		: Request data  
			* @return		: Get status_check data array with response message
		*/
		public function auto_switch_api($user_id,$transid,$brand_id,$hit_count)
		{
				$auto_switch='true';
				$ip='';$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$res_format="json";$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="remark";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;$method='GET';$status3="";$next_api='';
			        $rechreq=array(
					'proc'=>'6',
					'user_id'=>$user_id,
					'mobile'=>$transid,
					'operator'=>$brand_id,
					'amount'=>10,
					'requesttype'=>$hit_count,
					'servicetype'=>1,
					'agentid'=>1,
					'format'=>1,
					'timelimit'=>900,
					'defaultstatus'=>2
					);	
					$rechreq_report=DB::select('CALL dorecharge(				
					:proc,
					:user_id,
					:mobile,
					:operator,
					:amount,
					:requesttype,
					:servicetype,
					:agentid,
					:format,
					:timelimit,
					:defaultstatus,
					@msg,
					@msg2
					)',$rechreq);
					
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					//dd($rechreq,$rechreq_report,$DB_ERROR[0]->ERROR);
					if($DB_ERROR[0]->ERROR!="Error")
					{
						//$transid=$DB_ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$next_api=$row->next_api;
						$user_id=$row->user_id;
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						$apiid=$row->apiid;
						$mobileno=$row->account;
						$amount=$row->amount;
						$agentid=$row->agentid;
						$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_id`=".$brand_id." AND `m04_tc_brand_status`='Active' LIMIT 1");
						$service_id=$opcode_id[0]->SERVICE_ID;
						$param1=$service_id;
						$res_format=$row->RES_FORMAT;$status=$row->RES_PARAM;$opid=$row->LIVEID;$rbid=$row->APITXNID;
						$res_success=$row->SUCCESS_VALUE;$res_fail=$row->FAILED_VALUE;$res_pending=$row->PENDING_VALUE;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($userid!="")
						$url=str_replace('@userid',$userid,$url);
						if($password!="")
						$url=str_replace('@password',$password,$url);
						if($mobileno!="")
						$url=str_replace('@account',$mobileno,$url);
						if($amount!="")
						$url=str_replace('@amount',$amount,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						if($DB_ERROR[0]->ERROR!="Error")
						$url=str_replace('@refrence',$DB_ERRMSG[0]->ERR_MSG,$url);
						if($format!="")
						$url=str_replace('@format',$format,$url);
						if($param1!="")
						$url=str_replace('@param1',$param1,$url);
						if($param2!="")
						$url=str_replace('@param2',$param2,$url);
						//echo $url.'</br>';
						//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
						$response=Helper::_curl_execute('GET',$url,'');
						//echo $response;
						//echo $hit_count;	
						  $arr = array(
							'tr05_remarks' =>trim("HIT count-".$hit_count."-".$response)
						);
						DB::table('tr05_recharge_detail')->where('tr05_trans_id',$transid)->update($arr);
						$response=str_replace("\xEF\xBB\xBF",'',$response); 
						$outgoinghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				        VALUES ('','$transid','$ip','$url','$response',2)");
                        $res_rbid=$transid;
                        
						if($res_format=="JSON")
						{
							$json=json_decode($response,true);
							$error_exist=array_key_exists('error',$json);
							$status_exist=array_key_exists('status',$json);
							$res_error='false';
							if($status!="" && $error_exist)
							{
								if($status_exist)
								{
								    $res_status=$json[$status];
									//$res_status='success';
									if($res_status==$res_fail && $error_exist)
									{
										$res_error=$json['error'];
										$auto_switch='true';
									}
									if($opid!='' && $res_status==$res_success)
									{
										$res_opid=$json[$opid];
										//$res_opid='';
										$auto_switch='false';
									}
									if($rbid!='' && $res_status!=$res_fail)
									{
										$res_rbid=$json[$rbid];
										//$res_rbid='';
									}
								}
								else
								{
									$res_error=$json['error'];
									$res_status="FAILED";
								}
								if($res_error=='true')
								{
									$auto_switch='true';
								}
							}
							else
							{
									if($status!="")
									{
										$res_status=$json[$status];
									}
									if($res_status==$res_fail )
									{
										$auto_switch='true';
									}
									if($opid!='' && $res_status==$res_success)
									{
										$res_opid=$json[$opid];
										$auto_switch='false';
									}
									if($rbid!='' && $res_status!=$res_fail)
									{
										$res_rbid=$json[$rbid];
									}
							}
							
						}
						if($res_format=="xml" || $res_format=="XML" )
						{
							$array = XmlToArray::convert($response);
							$json = json_encode($array);
							$xmlarray = json_decode($json,TRUE);
							if($status!="")
							{
								$res_status=$xmlarray[$status];
							}
							if($opid!='' && $res_status=="SUCCESS" )
							{
								$res_opid=$xmlarray[$opid];
								$auto_switch='false';
							}
							if($rbid!='' && ($res_status!="FAILED" || $res_status!="REFUND")  )
							{
								$res_rbid=$xmlarray[$rbid];
								$auto_switch='false';
							}
							if($msg!='' && ($res_status=="FAILED" || $res_status=="REFUND") )
							{
								$auto_switch='true';
							}
						}
						 					
						if($hit_count==5)
						{
							$auto_switch='false';
						}
						if($auto_switch=='false' || $next_api==0 )
						{
							if($res_status == $res_success || $res_status=="SUCCESS" || $res_status=="Success" )
							{	
								$status1="SUCCESS";
								$status2=1;
							}
							if($res_status==$res_pending || $res_status=="PENDING" || $res_status=="Pending")
							{
								$status1="PENDING";
								$status2=2;
							}
							if($res_status==$res_fail || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
							{
								$status1="FAILED";
								$status2=4;
							}
							$respreport=array(
							'proc'=>1,
							'userid'=>$user_id,
							'account'=>$mobileno,
							'transid'=>$transid,
							'liveid'=>$res_opid,
							'amt'=>$amount,
							'recstatus'=>$status2,
							'descrip'=>1							
							);
							$resquery = DB::select('CALL recharge_statusupdate(
							:proc,
							:userid,
							:account,
							:transid,
							:liveid,
							:amt,
							:recstatus,
							:descrip,
							@resmsg)',$respreport);
							$ERRMSG = "RECHARGE IS ".$status1."-".$hit_count;
							$this->isError= FALSE;
							$ERRCODE="success";
						     $response_inc=response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG ,
						'STATUS'=>trim($status1),
						'MOBILE'=>trim($mobileno),
						'AMOUNT'=>trim($amount),
						'AGENTID'=>trim($agentid),
						'OPID'=>trim($res_opid),
						'TID'=>trim($transid),
						'BAL'=>trim(floatval(0.00))
						]);
						return $response_inc;
						
						}
					
						if($hit_count<6)
                          return $status3;
					}
			
		}


	public function update_transpassword(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}

				$new_password="";$old_password="";$new_cpassword="";
				$old_password=$request->has('old_password')?'1':'0' ;
				$new_password=$request->has('new_password')?'1':'0' ;
				$new_cpassword=$request->has('new_cpassword')?'1':'0' ;
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($old_password==0 || $new_password==0 || $new_cpassword==0 )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('old_password')=='')
					{
						$ERRMSG = "Old password should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('old_password')<6))
					{
						$ERRMSG = "Old password length would be greater then 6 or equal 6";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('new_password')=='')
					{
						$ERRMSG = "New password should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('new_password')<6))
					{
						$ERRMSG = "New password length would be greater then 6 or equal 6";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('new_cpassword')=='')
					{
						$ERRMSG = "New Confirm password should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(strlen($request->input('new_cpassword')<6))
					{
						$ERRMSG = "New Confirm password length would be greater then 6 or equal 6";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('new_password')!=$request->input('new_cpassword'))
					{
						$ERRMSG = "Password does not match with confirm password.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$USER=$login_detail[0]->RegId;

					if(Hash::check($request->input('old_password'), $login_detail[0]->PinPassword))
					{
					$user_profile=DB::select("UPDATE tr04_login SET tr04_pin_pwd='".Hash::make($request->input('new_password'))."' WHERE m11_user_contactno ='".$login_detail[0]->RegCode."'");
						$this->apiToken = uniqid(base64_encode(Str::random(30)));
					$user_profile1=DB::update("UPDATE m11_user SET m11_user_api_token='".$this->apiToken."' WHERE m11_user_contactno =".$login_detail[0]->MemberContactNo." AND m11_user_status='ACTIVE'");
					$mobileno_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('tr04_login','','tr04_pin_pwd','$USER','USER S TRANSACTION PASSWORD HAS BEEN CHANGED SUCCESSFULLY!')");
					
					$ERRMSG="USER TRANSACTION PASSWORD HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
					}
					else
					{
						$ERRMSG="USER OLD PASSWORD NOT MATCHED!";
						$ERRCODE='success';	
					}
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
		}



		public function razorpayapp(Request $request)
        {
            if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$authrization = $request->header('Authorization');
				$token='';
				$device_id='';
				$token1=explode('_',$authrization); 
				if(count($token1)==2)
				{
				$token=$token1[0];
				$device_id=$token1[1];
				}

				$txt_amount="0.000";
				$txt_amount=$request->has('txt_amount')?'1':'0' ;
				if($token=='')
				{
					$ERRMSG = "Api Token should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				if($this->isError==FALSE)
				{
					if($txt_amount==0 )
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_amount')=='')
					{
						$ERRMSG = "Old password should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
				//$USER=$login_detail[0]->RegId;
				//$user = Helper::get_userdetail($USER);
				$data[1] =  Helper::razorpay($request,$login_detail[0]);
				$data[2] = $request->all();
				return $data;
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}


        public function get_invite(request $request)
        {

			if($request->device_type == '')
			{
				$ERRMSG = "Device type required";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			elseif($request->device_id == '')
			{
				$ERRMSG = "Device id required";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			else
			{
				
				$data = DB::table('app_refral')->where('device_id', $request->device_id)->first();
			
				if($data)
				{
					$ERRMSG = "";
					$ERRCODE="success";
					return response()->json([
					'USER_ID'=>$data->user_id,
					'USER_CODE'=>$data->user_code,
					'NEW_USER_ID'=>$data->new_user,
					'NEW_USER_CODE'=>$data->new_user_code,
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				else
				{
					$ERRMSG = 'Data Not Found';
					$ERRCODE="error";
					return response()->json([
					'USER_ID'=>'',
					'USER_CODE'=>'',
					'NEW_USER_ID'=>'',
					'NEW_USER_CODE'=>'',
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}

		}




   /**
			* Method name	: Testing uplode image
			* @description 	: Testing uplode image
			* @param		: Testing uplode image 
			* @return		:Testing uplode image
		*/
		public function upload_image(Request $request)
		{
				$image="";
				
				$image=$request->has('image')?'1':'0' ;

					if($image==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->file('image')=='' )
					{
						$ERRMSG = "image should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}

				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
						$image = $request->file('image');
						$name1 = "IMAGE".time().'.'.$image->getClientOriginalExtension();
						$destinationPath = public_path('/images/TESTINGIMAGE/');
						$FileType = array('jpeg','png','jpg');
						if(in_array($image->getClientOriginalExtension(), $FileType)) {
							$image->move($destinationPath, $name1);}

						$ERRMSG = 'http://103.149.165.65/public/images/TESTINGIMAGE/'.$name1;
						$ERRCODE="success";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
		}




	public function spin_data()
	{
		$part_size = number_format(config('SPINDIVIDE_VAL'),2);
		$min_limit = number_format(config('SPINMIN_VAL'),2);
		$max_limit = number_format(config('SPINMAX_VAL'),2);
		$divideval = ($max_limit/$part_size);
       	$a = $max_limit+$divideval;

		$color =   ['#ee1c24', '#3cb878','#f6989d','#00aef0','#f26522', '#e70697', '#fff200', '#f6989d', '#ee1c15', '#3cb878','#f26522', '#a186be','#fff200','#00aef0', '#ee1c04','#f6989d', '#f26522', '#3cb878', '#a186be', '#fff200', '#00aef0', '#ffffff', '#f26522', '#e70697', '#fff200', '#f6989d', '#ee1c15','#ee1c24', '#3cb878','#f6989d','#00aef0','#f26522', '#e70697', '#fff200', '#f6989d', '#ee1c15', '#3cb878','#f26522', '#a186be','#fff200','#00aef0', '#ee1c04','#f6989d', '#f26522', '#3cb878', '#a186be', '#fff200', '#00aef0', '#ffffff', '#f26522', '#e70697', '#fff200', '#f6989d', '#ee1c15'];

		$data = [];
		if($min_limit == '' || $min_limit == '' || config('SPIN') == 'NO')
		{
			$data = [['fillStyle'=> '#eae56f', 'text' => '']];
			$spin_data['segments'] = json_encode($data);
			$spin_data['numSegments'] = '0';
			return response()->json([
				'ERROR'=>'warning',
				'MSG' =>'',
				'DATA' =>  $spin_data
			]);
		}
			$c = 0;
			for($i=$min_limit;$i<=$a;$i=$i+$divideval)
			{
				$j = number_format($i,2);
			 
			    array_push($data, ['fillStyle'=> $color[$c], 'text' => (string)$j.' %' ]);
			    ++$c;
			}

		if(count($data) > 0)
		{
			$spin_data['segments'] = $data;
			$spin_data['numSegments'] = count($data);
			return response()->json([
				'ERROR'=>'success',
				'MSG' =>'',
				'DATA' =>  $spin_data
				]);
		}
		else
		{
			$data = [['fillStyle'=> '#eae56f', 'text' => '']];
			$spin_data['segments'] = $data;
			$spin_data['numSegments'] = '0';
			return response()->json([
				'ERROR'=>'warning',
				'MSG' =>'',
				'DATA' =>  $spin_data
			]);
		}
	}


	public function create_win_data(request $request)
	{
	    if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$authrization = $request->header('Authorization');
			$token='';
			$device_id='';
			$token1=explode('_',$authrization); 
			if(count($token1)==2)
			{
			$token=$token1[0];
			$device_id=$token1[1];
			}

			$win_spin="";
			$win_spin=$request->has('win_spin')?'1':'0' ;
		
			if($token=='')
			{
				$ERRMSG = "Api Token should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="error";
				$userData ='';
			}
			elseif($request->input('win_spin')=='')
			{
				$ERRMSG = "Spin data should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");

				if($login_detail)
				{
					$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
					$ERRCODE="success";
					$this->isError==FALSE;
				}
				else
				{
					$ERRMSG = "USER DETAILS NOT FIND.";
					$ERRCODE="error";
					$this->isError= TRUE;
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
			}
			
			if($this->isError==FALSE)
			{
				
				$check = DB::select("SELECT * FROM `tr43_spin_pints` WHERE `m11_user_id`= ".$login_detail[0]->RegId." AND `tr43_win_datetime` = DATE_FORMAT(NOW(), '%Y-%m-%d') LIMIT 1");

				if(count($check) == 0)
				{
					$data = DB::table('tr43_spin_pints')->insert(['tr43_win' => str_replace(' %','',$request->win_spin), 'm11_user_id' => $login_detail[0]->RegId, 'tr43_win_datetime' => date('Y-m-d'), 'tr43_status' => 2]);

					if($data)
					{
						DB::select("call cb_afterspin(". $login_detail[0]->RegId.",".str_replace(' %','',$request->win_spin).",@msg,@msg2)");

						$ERRMSG = "Win Percentage";
						$ERRCODE="success";
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
					else
					{
						$ERRMSG = "Already use spin";
						$ERRCODE="warning";
					}
				}

					$ERRMSG = "Already use spin";
					$ERRCODE="warning";

				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			else
			{
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}
		else
		{
			$ERRMSG = "REQUEST IS NOT VALID";
			$ERRCODE="error";
			return response()->json([
			'ERROR'=>$ERRCODE,
			'MSG' =>$ERRMSG 
			]);
		}

	}




	public function withdraw_vet(Request $request)
		{
            if($_SERVER['REQUEST_METHOD']=="POST")
            {
				
				$token='';
				$device_id='';
				$ddfor_wallet=0;$txt_balance="";$for_wallet="";$mobileno="";$dd_package="";$packageamt="";

				$txt_for=$request->has('txt_for')?'1':'0';
				$txt_bscaddress=$request->has('txt_bscaddress')?'1':'0' ;
				$txt_vet=$request->has('txt_vet')?'1':'0' ;
				$txt_amount=$request->has('txt_amount')?'1':'0' ;

				
				
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($txt_for==0 || $txt_bscaddress==0 || $txt_vet==0 || $txt_amount==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
				    if($request->input('txt_bscaddress')=="")
					{
						$ERRMSG = "wallet address should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					$contactno=$request->input('txt_bscaddress');
					$user = Helper::get_userid_by_userbscaddress($contactno);
					$userwds =Helper::get_userwds_by_userbscaddress($contactno);
						$CB_AMT=0.000;
				        $avail_bal=0.000;
				        $user_id=$user;
				        $INVESTMENT = Helper::get_user_investment($user,1);
				        $avail_bal=DB::select("SELECT GET_AVAILABLE_BAL(".$user.",5) AS BAL");
						$CB_AMT=$avail_bal[0]->BAL;
						//dd($userwds);
					if(empty($user))
					{
						$ERRMSG = "Wallet address not registered.";
						$isError = TRUE;
						$ERRCODE="warning";
					}
					else if(empty($userwds))
					{
						$ERRMSG = "Wallet address not registered.";
						$isError = TRUE;
						$ERRCODE="warning";
					}
					else if($userwds==0)
					{
						$ERRMSG = "Wallet address not registeredddd.";
						$isError = TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($CB_AMT-floatval($request->input('txt_amount')))<0)
					{
						$ERRMSG = "Amount should be less than $".$CB_AMT." or not be negative.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00 || floatval($request->input('txt_amount'))<9.00)
					{
						//dd($CB_AMT-floatval($request->input('txt_amount')));
						$ERRMSG = "Amount should be greater than $9 or not be blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_amount'))<9.00)
					{
						$ERRMSG = "Amount should be greater than $9 or not be negative.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_amount'))>1001.00)
					{
						$ERRMSG = "Amount should be less than $1001 or not be negative.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_vet'))=="" || floatval($request->input('txt_vet'))==0.00 )
					{
						$ERRMSG = "VET amount should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_for'))=="" || floatval($request->input('txt_for'))==0.00 )
					{
						$ERRMSG = "Withdraw should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError= FALSE;
						$ERRCODE="success";
					}
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$userinfo = Helper::get_useralldetail(Session()->get('USER_ID'));
				$dmr_req=array(
					'proc'=>'1',
					'm11_user_id'=>$user,
					'trans_id'=>2,
					'refre_id'=>'',
					'request_no'=>'',
					'mobile_no'=>Helper::get_usermobile_by_userbscaddress($contactno),
					'amount'=>$request->input('txt_amount'),
					'payment_id'=>'',
					'payment_status'=>'',
					'impsrefno'=>'',
					'message'=>'',
					'remarks'=>'',
					'account_number'=>$request->input('txt_bscaddress'),
					'beneficiary_code'=> '',
					'beneficiary_name'=>'',
					'account_type'=>$request->input('txt_for'),
					'ifsc'=>'',
					'bank_name'=>'',
					'branch_name'=>'',
					'address'=>'',
					'state'=>'',
					'city'=>'',
					'agentid'=>'',
					'payctransid'=>'',
					'topup_charge'=>'0.00',
					'transfer_status'=>'2');
				$dmrreq_response=$this->dmt_proc_repo->doRemmitance($dmr_req);
				
				$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
				$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
				$ERRCODE=$DB_ERROR[0]->ERROR;
				$ERRMSG =$DB_ERRMSG[0]->ERR_MSG;
				//dd($ERRCODE,$ERRMSG);
				

					if($ERRCODE=='success'){
						return response()->json([
						'ERROR'=>$ERRCODE,
						'STATUS'=>'PENDING',
						'MSG' =>$ERRMSG 
						]);
					}
					else
					{
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
					
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				
			}
		}
		
		public function withdraw_trade(Request $request)
		{
            if($_SERVER['REQUEST_METHOD']=="POST")
            {
				
				$token='';
				$device_id='';
				$ddfor_wallet=0;$txt_balance="";$for_wallet="";$mobileno="";$dd_package="";$packageamt="";

				$txt_for=$request->has('txt_for')?'1':'0';
				$txt_bscaddress=$request->has('txt_bscaddress')?'1':'0' ;
				$txt_vet=$request->has('txt_vet')?'1':'0' ;
				$txt_amount=$request->has('txt_amount')?'1':'0' ;

				
				
				if($this->isError==FALSE && $request->method() == 'POST')
				{
					if($txt_for==0 || $txt_bscaddress==0 || $txt_vet==0 || $txt_amount==0)
					{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
				    if($request->input('txt_bscaddress')=="")
					{
						$ERRMSG = "wallet address should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					$contactno=$request->input('txt_bscaddress');
					$user = Helper::get_userid_by_userbscaddress($contactno);
					$userwds =Helper::get_userwds_by_userbscaddress($contactno);
						$CB_AMT=0.000;
				        $avail_bal=0.000;
				        $user_id=$user;
				        $INVESTMENT = Helper::get_user_investment($user,1);
				        $avail_bal=DB::select("SELECT GET_AVAILABLE_BAL(".$user.",8) AS BAL");
						$CB_AMT=$avail_bal[0]->BAL;
						//dd($userwds);
					if(empty($user))
					{
						$ERRMSG = "Wallet address not registered.";
						$isError = TRUE;
						$ERRCODE="warning";
					}
					else if(empty($userwds))
					{
						$ERRMSG = "Wallet address not registered.";
						$isError = TRUE;
						$ERRCODE="warning";
					}
					else if($userwds==0)
					{
						$ERRMSG = "Wallet address not registeredddd.";
						$isError = TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($CB_AMT-floatval($request->input('txt_amount')))<0)
					{
						$ERRMSG = "Amount should be less than $".$CB_AMT." or not be negative.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00 || floatval($request->input('txt_amount'))<10.00)
					{
						//dd($CB_AMT-floatval($request->input('txt_amount')));
						$ERRMSG = "Amount should be greater than $10 or not be blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_amount'))>9.00 && floatval($request->input('txt_amount')%10.00)!=0.00 )
					{
							$ERRMSG = "Amount should be multiple of $10.00";
							$this->isError= TRUE;
							$ERRCODE="warning";
					}
					/*else if(floatval($request->input('txt_amount'))<9.00)
					{
						$ERRMSG = "Amount should be greater than $9 or not be negative.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}*/
					else if(floatval($request->input('txt_amount'))>201.00)
					{
						$ERRMSG = "Amount should be less than $201 or not be negative.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_vet'))=="" || floatval($request->input('txt_vet'))==0.00 )
					{
						$ERRMSG = "VET amount should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(floatval($request->input('txt_for'))=="" || floatval($request->input('txt_for'))==0.00 )
					{
						$ERRMSG = "Withdraw should be valid";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError= FALSE;
						$ERRCODE="success";
					}
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$userinfo = Helper::get_useralldetail(Session()->get('USER_ID'));
				$dmr_req=array(
					'proc'=>'1',
					'm11_user_id'=>$user,
					'trans_id'=>4,
					'refre_id'=>'',
					'request_no'=>'',
					'mobile_no'=>Helper::get_usermobile_by_userbscaddress($contactno),
					'amount'=>$request->input('txt_amount'),
					'payment_id'=>'',
					'payment_status'=>'',
					'impsrefno'=>'',
					'message'=>'',
					'remarks'=>'',
					'account_number'=>$request->input('txt_bscaddress'),
					'beneficiary_code'=> '',
					'beneficiary_name'=>'',
					'account_type'=>$request->input('txt_for'),
					'ifsc'=>'',
					'bank_name'=>'',
					'branch_name'=>'',
					'address'=>'',
					'state'=>'',
					'city'=>'',
					'agentid'=>'',
					'payctransid'=>'',
					'topup_charge'=>'0.00',
					'transfer_status'=>'2');
				$dmrreq_response=$this->dmt_proc_repo->doRemmitance($dmr_req);
				
				$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
				$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
				$ERRCODE=$DB_ERROR[0]->ERROR;
				$ERRMSG =$DB_ERRMSG[0]->ERR_MSG;
				//dd($ERRCODE,$ERRMSG);
				

					if($ERRCODE=='success'){
						return response()->json([
						'ERROR'=>$ERRCODE,
						'STATUS'=>'PENDING',
						'MSG' =>$ERRMSG 
						]);
					}
					else
					{
						return response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG 
						]);
					}
				}
				else
				{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
					
				}
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
				
			}
		}
		public function refund_bonus()
    {
			$page = 'REPORT PANEL';
			$form_name = 'MONEY TARNSFER REFUND UPDATE HERE';
			$request = request();
			$descrip="";
			$start = '1970-01-01';
			$end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="1";
			$cond1="1";
			
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_transid')=="")
				{
					$ERRMSG = "Withdrawn transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_impsrefno')=="")
				{
					$ERRMSG = "HASH RefNo should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError = FALSE;
					$ERRCODE="";
				}
				if($this->isError==FALSE)
				{
					$TRANSID=$request->input('txt_transid');
					$txt_status=$request->input('txt_status');
					$full_res=$request->input('txt_res');
					$recereport=array
					( 
						'proc'=>1,
						'account'=>$txt_account,
						'transid'=>$TRANSID,
						'userid'=>$txt_memberid,
						'fromdate'=>$start,
						'todate'=>$end,
						'noofrecords'=>$txt_noofrecords,
						'recstatus'=>-1,
						'descrip'=>$cond
					);
						$rec_report = $this->dmt_reprt_repo->dmrReport($recereport);
							 $m=$rec_report[0]->MemberContactNo;
							 $id=$rec_report[0]->Memberid;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account_number;
							 $amt=$rec_report[0]->Amount;
							//echo $amt;
							
							$operid=$request->input('txt_impsrefno');
							if($txt_status=="success")
							{
								$status1="SUCCESS";
								$status2=1;
							}
							if($txt_status=="pending")
							{
								$status1="PENDING";
								$status2=2;
							}
							if($txt_status=="failed")
							{
								$status1="FAILED";
								$status2=4;
							}
							if($txt_status=="false" || $txt_status=="error")
							{
								$status1="FAILED";
								$status2=4;
							}
							
							$respreport=array(
										'proc'=>2,
										'userid'=>$id,
										'account'=>$account,
										'transid'=>$rqd,
										'liveid'=>$operid,
										'amt'=>$amt,
										'recstatus'=>$status2,
										'descrip'=>$full_res
									);
							 $resquery = $this->dmt_proc_repo->dmrStatusUpdate($respreport);
							 
							 $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
						//	dd($ERRMSG);
							 //return($resp_report);
					}
			}
			return 1;
    }




	public function matchingwithdraw_report()
	{
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$account="";$transid="";$fromdate="";$todate="";$noofrecords="";
			$recstatus="-1";$descrip="1";
			$cond="";
			$cond="`tr15_request_for` IN (1,2) AND 1";
			$txt_account = '';
			$txt_memberid = '';
			$txt_memberids ='';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$txt_bscaddress=$request->has('txt_bscaddress')?'1':'0' ;
			
			if($this->isError==FALSE)
			{
				if($txt_bscaddress==0 )
				{
					$ERRMSG = "Parameter missing or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_bscaddress')=="")
				{
					$ERRMSG = "wallet address should be valid";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$contactno=$request->input('txt_bscaddress');
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
			}
			else
			{
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
			
			if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
			{
				
				$USER= Helper::get_userbscaddress_by_usercode($contactno);
			
			$dmtreport=array
			(
				'proc'=>1,
				'account'=>$txt_account,
				'transid'=>$txt_transid,
				'userid'=>$USER,
				'fromdate'=>date('Y-m-d',strtotime('2025-01-01')),
				'todate'=>date('Y-m-d'),
				'noofrecords'=>$txt_noofrecords,
				'recstatus'=>-1,
				'descrip'=>$cond
			);
			$dmt_report = DB::select('CALL dmr_report(
				:proc,
				:account,
				:transid, 
				:userid,
				:fromdate,
				:todate,
				:noofrecords,
				:recstatus,
				:descrip,
				@msg
			)',$dmtreport);
		
				$ERRMSG="USER TOPUP REPORT FETCH SUCCESSFULLY!";
				$ERRCODE='success';	
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG,
				'WITHDRAW_DATA'=>$dmt_report
				]);
			}
			else
			{
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);
			}
		}
		else
		{
			$ERRMSG = "REQUEST IS NOT VALID";
			$ERRCODE="error";
			return response()->json([
			'ERROR'=>$ERRCODE,
			'MSG' =>$ERRMSG 
			]);
		}


	}


}
?>