<?php

namespace App\Http\Controllers\API;

use Illuminate\Support\Str;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Recharge\Rechargeprocess\RechargeprocessRepository;
use App\Repositories\Recharge\Rechargereport\RechargereportRepository;
use App\Repositories\Dmt\Dmtprocess\DmtprocessRepository;
use App\Repositories\Dmt\Dmtreport\DmtreportRepository;
use DB;
use Helper;

class ApiWebResponse extends Controller
{
    //
private $STATUS = "failed";
		private $ERRMSG = "Invalid Operation";
		private $ERRCODE = "error";
		private $isError = FALSE;
		private $record_per_page =10;
        private $userData = '';
		 private $rech_proc_repo;
		private $rech_reprt_repo;
		private $dmt_proc_repo;
		private $dmt_reprt_repo;
		

public function __construct(
        RechargeProcessRepository $rech_proc_repo, RechargereportRepository $rech_reprt_repo, 
      DmtprocessRepository $dmt_proc_repo, DmtreportRepository $dmt_reprt_repo
       )
	{
		
        $this->rech_proc_repo = $rech_proc_repo;
        $this->rech_reprt_repo = $rech_reprt_repo;
        $this->dmt_proc_repo = $dmt_proc_repo;
        $this->dmt_reprt_repo = $dmt_reprt_repo;

	}


		public function valid_phone_number($str)
		{
			$regex = "/^[0-9]+$/";
			if(preg_match($regex,$str))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}
		public function valid_decimal_amount($amt)
		{
			$regex = "/^(?:d*.d{1,2}|d+)$/";
			if(preg_match($regex,$amt))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}





/**
			* Method name	    : LETS LAUNCH RESPONSE
			* @description   	: Used to Update Recharge Status
			* @param		    : Request data  
			* @return		    : Get Recharge data array with response message
		*/
		public function recharge_callback($id)
		{
			if($_SERVER['REQUEST_METHOD']=="GET")
			{	
				$request = request();
			    $call_backprm=DB::select("SELECT IFNULL(`m25_resp_type`,'json') AS RESP_TYPE,IFNULL(`m25_respfor_status`,'status') as STATUS,IFNULL(`m25_valueof_success`,'SUCCESS') as SUCCESS ,IFNULL(`m25_valueof_pending`,'PENDING') as PENDING,IFNULL(`m25_valueof_failed`,'FAILED') as FAILED,IFNULL(`m25_respfor_liveid`,'OPERID') as OPERID ,IFNULL(`m25_respfor_apitxnid`,'TID') as TID FROM`m25_api_response` WHERE m25_resp_occur=2 AND m12_api_id=".$id." LIMIT 1"); 
				if($call_backprm){

				$token = "";
				$url="";
				$start = '1970-01-01';
				$end ='1970-01-01';$txt_account = '';$txt_memberid = '';
				$txt_transid = '';$txt_noofrecords = '100';$dd_status='-1';$cond="1";
				$CLIENTID="";$apitoken="";
				$userid="";
				$url="";
				$password="";
				$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;
			    $operid="";
				$cp1=$request->has($call_backprm[0]->TID)?'1':'0' ;
				$cp2=$request->has($call_backprm[0]->STATUS)?'1':'0' ;
				$cp3=$request->has($call_backprm[0]->OPERID)?'1':'0' ;
				if($cp1==0|| $cp2==0 || $cp3==0)
				{
						$ERRMSG = "Parameter missing or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
				}
				if($this->isError== FALSE)
				{
				if($request->has($call_backprm[0]->TID))
				$agentid =$_GET[$call_backprm[0]->TID];
				if($request->has($call_backprm[0]->STATUS))
				$status  =$_GET[$call_backprm[0]->STATUS];
				if($request->has($call_backprm[0]->OPERID))
				$opid    =$_GET[$call_backprm[0]->OPERID];
				$response  ='NA';
				$ip=$request->server('REMOTE_ADDR');
				$fullurl=$request->fullUrl();
				$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('$token','$agentid','$ip','$fullurl','',3)");		
			
					if(trim($agentid) == '')
					{
						$ERRMSG = "Recharge transaction id should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else if(trim($response) == '')
					{
						$ERRMSG = "Message should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else
					{
						$this->isError= FALSE;
						$ERRCODE="success";
						$ERRMSG ="";
					}
				}
				if($this->isError== FALSE)
				{
					$TRANSID=$agentid;
					$txt_status=-1;
					$recereport=array
							(
							'proc'=>2,
							'account'=>$txt_account,
							'transid'=>$agentid,
							'userid'=>$txt_memberid,
							'fromdate'=>$start,
							'todate'=>$end,
							'noofrecords'=>$txt_noofrecords,
		     				'recstatus'=>$txt_status,
							'descrip'=>$cond
							);
							$rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
							if($rec_report){
							$m=$rec_report[0]->MemberID;
							$id=$rec_report[0]->UserID;
							$rqd=$rec_report[0]->Transactionid;
							$account=$rec_report[0]->Account;
							$op=$rec_report[0]->ServiceProvider;
							$mode=$rec_report[0]->Mode;
							$amt=$rec_report[0]->Amount;
							$CLIENTID=$rec_report[0]->APITransactionid;
						   	$url=$rec_report[0]->CallBackURL;
							//$operid=$request->input('txt_rechopid');
							$status1="SUCCESS";
							$status2=1;
					
							if($opid  !="" || $opid  !="NULL")
							{	
								$operid=$opid;
								$operid=explode(' ',$operid);
							}
							if($status==$call_backprm[0]->SUCCESS)
							{
								$status1="SUCCESS";
								$status2=1;
								$margin=$amt;
							}
							if($status==$call_backprm[0]->PENDING)
							{
								$status1="PENDING";
								$status2=2;
							}
							if($status==$call_backprm[0]->FAILED || $request->get('status')=="REFUND")
							{
								$status1="FAILED";
								$status2=4;
							}
							$respreport=array(
							'proc'=>1,
							'userid'=>$id,
							'account'=>$account,
							'transid'=>$agentid,
							'liveid'=>$operid[0],
							'amt'=>$amt,
							'recstatus'=>$status2,
							'descrip'=>1							
							);
							$resquery = $this->rech_proc_repo->rechargeStatusUpdate($respreport);
							$DB_ERRMSG=DB::select('SELECT @resmsg as ERR_MSG');
							$ERRMSG = $DB_ERRMSG[0]->ERR_MSG."RECHARGE IS ".$status1." TRANSACTION ID- ".$agentid;
							$this->isError= FALSE;
							$ERRCODE="success";
							$userData =$agentid;
						    $params=array
									(
										'status'=>trim($status1),
										'mobile'=>trim($account),
										'amount'=>trim($amt),
										'agentid'=>trim($CLIENTID),
										'opid'=>trim($operid[0]),
										'tid'=>trim($agentid),
										'bal'=>trim(floatval(0.00))
									);
					        $cb_response=Helper::_curl_execute('GET',$url,$params);	
							//$cb_response="";
							$defaults = array(
							CURLOPT_URL => $url. (strpos($url, '?') === FALSE ? '?' : ''). http_build_query($params)
							);
							$fullurl=$defaults[CURLOPT_URL];
							$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
							VALUES ('$token','$agentid','$ip','$fullurl','$cb_response',4)");	
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG ,
							'STATUS'=>trim($status1),
							'MOBILE'=>trim($account),
							'AMOUNT'=>trim($amt),
							'AGENTID'=>trim($CLIENTID),
							'OPID'=>trim($operid[0]),
							'TID'=>trim($agentid),
							'BAL'=>trim(floatval(0.00))
							]);
							}
						else
						{	
						$ERRMSG = "RECHARGE NOT FIND SOMETHING GOING WRONG";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';	
						return response()->json(
							[
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]
						);
					}
				}
				else
				{	
						$ERRMSG = "SOMETHING GOING WRONG";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';	
						return response()->json(
							[
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]
						);
				}
}
else
						{	
						$ERRMSG = "CALLBACK NOT FIND SOMETHING GOING WRONG";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';	
						return response()->json(
							[
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]
						);
					}

			}
			else
			{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
			}
		}



 /**
			* Method name	    : LETSLAUNCHAPI DMR RESPONSE
			* @description   	: Used to Update Recharge Status
			* @param		    : Request data  
			* @return		    : Get Recharge data array with response message
		*/
		public function letslaunchapi_dmtresponse(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$token ="";
			}
			if($_SERVER['REQUEST_METHOD']=="GET")
			{	
				$token = "";
				$url="";
				$start = '1970-01-01';$end ='1970-01-01';
				$txt_account = '';$txt_memberid = '';$txt_transid = '';$txt_noofrecords = '100';
				$dd_status='-1';$cond="1";$CLIENTID="";$apitoken="";$userid="";$url="";$password="";
				$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;
			    $operid="";
				$agentid =$request->get('agentid');
				$status  =$request->get('status');
				$opid    =$request->get('imps_refno');
				$response  ='NA';
				$ip=$request->server('REMOTE_ADDR');
				$fullurl=$request->fullUrl();
				$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('$token','$agentid','$ip','$fullurl','',3)");		
					if($this->isError== FALSE)
					{
						if(trim($agentid) == '')
						{
							$ERRMSG = "Recharge transaction id should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(trim($response) == '')
						{
							$ERRMSG = "Message should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else
						{
							$this->isError= FALSE;
							$ERRCODE="success";
							$ERRMSG ="";
						}
					}
					if($this->isError== FALSE)
					{

							$TRANSID=$agentid;
							$txt_status=$status;
							$recereport=array
							(
								    'proc'=>1,
									'account'=>'',
									'transid'=>$TRANSID,
									'userid'=>$txt_memberid,
									'fromdate'=>$start,
									'todate'=>$end,
									'noofrecords'=>1,
									'recstatus'=>-1,
									'descrip'=>$cond,
									'msg'=>@msg
							);
							 $rec_report = DB::select('CALL dmr_report(
								 :proc,
								 :account,
								 :transid, 
								 :userid,
								 :fromdate,
								 :todate,
								 :noofrecords,
								 :recstatus,
								 :descrip,
								 :msg
							 )',$recereport);
							 $m=$rec_report[0]->MemberContactNo;
							 $id=$rec_report[0]->Memberid;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account_number;
							 $amt=$rec_report[0]->Amount;
							 $CLIENTID=$rec_report[0]->Agentid;
							 $operid=$request->input('imps_refno');
							
							if($txt_status=="SUCCESS")
							{
								$status1="SUCCESS";
								$status2=1;
							}
							if($txt_status=="PENDING")
							{
								$status1="PENDING";
								$status2=2;
							}
							if($txt_status=="FOR REFUND")
							{
								$status1="FOR REFUND";
								$status2=3;
							}
							if($txt_status=="FAILED")
							{
								$status1="FAILED";
								$status2=4;
							}
							if($txt_status=="REFUNDED")
							{
								$status1="REFUNDED";
								$status2=5;
							}
							if($txt_status=="RSUCCESS")
							{
								$status1="RSUCCESS";
								$status2=7;
							}
							$respreport=array(
										'proc'=>2,
										'userid'=>$id,
										'account'=>$account,
										'transid'=>$rqd,
										'liveid'=>$operid,
										'amt'=>floatval($amt/1.00)+floatval(($amt/1.00)*0.00),
										'recstatus'=>$status2,
										'descrip'=>'1'
									);
							$resp_report = DB::select('CALL dmr_statusupdate(
								 :proc,
								 :userid,
								 :account, 
								 :transid,
								 :liveid,
								 :amt,
								 :recstatus,
								 :descrip,
								 @msg
							 )',$respreport);
				
							$TRANSID=$agentid;
							$txt_status=-1;
							$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							$ERRMSG = $DB_ERRMSG[0]->ERR_MSG."MONEY TRANFER IS ".$status1." TRANSACTION ID- ".$agentid;
							echo $DB_ERRMSG[0]->ERR_MSG;
					}
					else
					{	
							$ERRMSG = "SOMETHING GOING WRONG";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';	
							return response()->json(
								[
								'ERROR'=>$ERRCODE,
								'MSG' =>$ERRMSG 
								]
							);
					}
			}
			else
			{
					return response()->json([
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
			}
		}





}