<?php

namespace App\Helpers;
use DB;
use Helper;
use GuzzleHttp\Client;

class ShipRocket
{

 /*------------------Authorization getToken----------------------*/
	public static function getToken()
	{
		$curl = curl_init();
/*		$login = [
				'email' => config('sourabhsvt@gmail.com'),
				'password' => config('25@May@2015'),
			];
*/
			$login = [
				'email' => 'amitappworks@gmail.com',
				'password' => 'App@123456',
			];

		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://apiv2.shiprocket.in/v1/external/auth/login',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'POST',
		  CURLOPT_POSTFIELDS =>json_encode($login),
		  CURLOPT_HTTPHEADER => array(
		    'Content-Type: application/json'
		  ),
		));
		$response = curl_exec($curl);
		curl_close($curl);
		$response = json_decode($response);

		$token = '';
		if(isset($response->token))
		{
			$token = $response->token;
		}
		return $token;
	}



	/*------------------Create Custom Order----------------------*/
	public static function OrderCreate($order_info,$token)
	{
			if($order_info == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info required'];
			}
			elseif($token == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Token required'];
			}
			elseif(!is_array($order_info))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info Incorrect Data Format'];
			}
			elseif(!is_string($token))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'token Incorrect Format'];
			}
			else
			{
				$curl = curl_init();

				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://apiv2.shiprocket.in/v1/external/orders/create/adhoc',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS => json_encode($order_info),
				  CURLOPT_HTTPHEADER => array(
				    'Content-Type: application/json',
				    'Authorization: Bearer '.$token
				  ),
				));

				$response = curl_exec($curl);

				curl_close($curl);
				
				$response = json_decode($response);
		
				if(isset($response->status_code))
				{
					if($response->status_code == 1)
					{
						$response->{'status'} = 'success';
					}
					else
					{
						$response->{'status'} = 'error';
					}
				}
				else
				{
					$response = ['status' => 'error', 'status_code'=> 500, 'message' => 'Response Not Get'];
				}

				return $response;	
		}
	}



	/*------------------courier assign Order----------------------*/
	public static function CourierAssign($order_info,$token)
	{
			if($order_info == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info required'];
			}
			elseif($token == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Token required'];
			}
			elseif(!is_array($order_info))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info Incorrect Data Format'];
			}
			elseif(!is_string($token))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'token Incorrect Format'];
			}
			else
			{
				$curl = curl_init();

				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://apiv2.shiprocket.in/v1/external/courier/assign/awb',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS => json_encode($order_info),
				  CURLOPT_HTTPHEADER => array(
				    'Content-Type: application/json',
				    'Authorization: Bearer '.$token
				  ),
				));

				$response = curl_exec($curl);

				curl_close($curl);
				
				$response = json_decode($response);
			
				if(isset($response->awb_assign_status))
				{
					if($response->awb_assign_status == 1)
					{
						$response->{'status'} = 'success';
					}
					else
					{
						$response->{'status'} = 'error';
					}
				}
				else
				{
					$msg = '';
					if(isset($response->message))
					{
						$msg = $response->message;
					}
					if($msg == '')
					{
						$msg = 'Response Not Get';
					}

					$response->{'status'} = 'error'; 
					$response->{'status_code'} = 500; 
					$response->{'message'} = $msg; 
				}

				return $response;	
		}
	}



	/*------------------Generate Manifest Order----------------------*/
	public static function GenerateManifest($order_info,$token)
	{
			if($order_info == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info required'];
			}
			elseif($token == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Token required'];
			}
			elseif(!is_array($order_info))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info Incorrect Data Format'];
			}
			elseif(!is_string($token))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'token Incorrect Format'];
			}
			else
			{
				$curl = curl_init();

				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://apiv2.shiprocket.in/v1/external/manifests/generate',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS => json_encode($order_info),
				  CURLOPT_HTTPHEADER => array(
				    'Content-Type: application/json',
				    'Authorization: Bearer '.$token
				  ),
				));

				$response = curl_exec($curl);

				curl_close($curl);
				
				$response = json_decode($response);

				return $response;	
		}
	}



	/*------------------Generate Label Order----------------------*/
	public static function GenerateLabel($order_info,$token)
	{
			if($order_info == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info required'];
			}
			elseif($token == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Token required'];
			}
			elseif(!is_array($order_info))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info Incorrect Data Format'];
			}
			elseif(!is_string($token))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'token Incorrect Format'];
			}
			else
			{
				$curl = curl_init();

				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://apiv2.shiprocket.in/v1/external/courier/generate/label',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS => json_encode($order_info),
				  CURLOPT_HTTPHEADER => array(
				    'Content-Type: application/json',
				    'Authorization: Bearer '.$token
				  ),
				));

				$response = curl_exec($curl);

				curl_close($curl);
				
				$response = json_decode($response);
				
				return $response;	
		}
	}



	/*------------------Generate Invoice Order----------------------*/
	public static function GenerateInvoice($order_info,$token)
	{
			if($order_info == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info required'];
			}
			elseif($token == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Token required'];
			}
			elseif(!is_array($order_info))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info Incorrect Data Format'];
			}
			elseif(!is_string($token))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'token Incorrect Format'];
			}
			else
			{
				$curl = curl_init();

				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://apiv2.shiprocket.in/v1/external/orders/print/invoice',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS => json_encode($order_info),
				  CURLOPT_HTTPHEADER => array(
				    'Content-Type: application/json',
				    'Authorization: Bearer '.$token
				  ),
				));

				$response = curl_exec($curl);

				curl_close($curl);
				
				$response = json_decode($response);
				
				return $response;	
		}
	}




	/*------------------Request for Shipment Pickup----------------------*/
	public static function RequestforShipmentPickup($order_info,$token)
	{
			if($order_info == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info required'];
			}
			elseif($token == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Token required'];
			}
			elseif(!is_array($order_info))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info Incorrect Data Format'];
			}
			elseif(!is_string($token))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'token Incorrect Format'];
			}
			else
			{
				$curl = curl_init();

				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://apiv2.shiprocket.in/v1/external/courier/generate/pickup',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS => json_encode($order_info),
				  CURLOPT_HTTPHEADER => array(
				    'Content-Type: application/json',
				    'Authorization: Bearer '.$token
				  ),
				));

				$response = curl_exec($curl);

				curl_close($curl);
				
				$response = json_decode($response);
				
				if(isset($response->pickup_status))
				{
					if($response->pickup_status == 1)
					{
						$response->{'status'} = 'success';
					}
					else
					{
						$response->{'status'} = 'error';
					}
				}
				else
				{
					$response->{'status'} = 'error'; 
					$response->{'status_code'} = 500; 
					$msg = "info Not Get";
					
					if(isset($response->message))
					{
						$msg = $response->message;
					}

					$response->{'message'} = $msg; 
				}
				
				return $response;	
		}
	}



	/*------------------Request for Shipment Pickup----------------------*/
	public static function OrderCancel($order_info,$token)
	{
			if($order_info == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info required'];
			}
			elseif($token == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Token required'];
			}
			elseif(!is_array($order_info))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info Incorrect Data Format'];
			}
			elseif(!is_string($token))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'token Incorrect Format'];
			}
			else
			{
				$curl = curl_init();

				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://apiv2.shiprocket.in/v1/external/orders/cancel',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS => json_encode($order_info),
				  CURLOPT_HTTPHEADER => array(
				    'Content-Type: application/json',
				    'Authorization: Bearer '.$token
				  ),
				));

				$response = curl_exec($curl);

				curl_close($curl);
				
				$response = json_decode($response);
				
				return $response;	
		}
	}



	/*------------------Create, Ship and Generate Label and Manifest for Order----------------------*/
	public static function CreateShipandGenerateLabelandManifestforOrder($order_info,$token)
	{
			if($order_info == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info required'];
			}
			elseif($token == '')
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Token required'];
			}
			elseif(!is_array($order_info))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'Order Info Incorrect Data Format'];
			}
			elseif(!is_string($token))
			{
				return ['status' => 'error', 'status_code'=> 110, 'message' => 'token Incorrect Format'];
			}
			else
			{
				$curl = curl_init();

				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://apiv2.shiprocket.in/v1/external/shipments/create/forward-shipment',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS => json_encode($order_info),
				  CURLOPT_HTTPHEADER => array(
				    'Content-Type: application/json',
				    'Authorization: Bearer '.$token
				  ),
				));

				$response = curl_exec($curl);

				curl_close($curl);
				
				$response = json_decode($response);
				dd($response);
				if(isset($response->pickup_status))
				{
					if($response->pickup_status == 1)
					{
						$response->{'status'} = 'success';
					}
					else
					{
						$response->{'status'} = 'error';
					}
				}
				else
				{
					$response->{'status'} = 'error'; 
					$response->{'status_code'} = 500; 
					$msg = "info Not Get";
					
					if(isset($response->message))
					{
						$msg = $response->message;
					}

					$response->{'message'} = $msg; 
				}
				
				return $response;	
		}
	}











}

?>