<?php

namespace App\Helpers;
use Illuminate\Support\Facades\DB;
use Helper;
use GuzzleHttp\Client;

class PayU
{

 /*------------------Register Remitter----------------------*/
	public static function register_remitter($address,$agent_id,$dob,$fname,$lname,$mobile_no,$pincode)
	{
	
		$header_data=array('Content-type: application/json', 
							'payuDistributorId: 29',
							'Authorization: Bearer b738e65ddc31651beeafd733afb93d4108097beebec2c2053f358a7e533ec3eb');
 		$data = ['address'=> $address,
		'agentId'=> $agent_id,
		'dob'=> $dob,
		'firstName'=> $fname,
		'lastName' => $lname,
		'mobile' => $mobile_no,
		'pinCode'=> $pincode
			];
		$url="https://test.payumoney.com/dmt/customer/register";
		$body= json_encode($data, true);
		$response = Helper::__curl_execute('POST',$url,$body,$header_data);
		return $response;
	}
	/*------------------Remitter verify----------------------*/
	public static function remitter_verify($mobile_no,$otp)
	{
		$header_data=array('Content-type: application/json', 
							'payuDistributorId: 29',
							'Authorization: Bearer b738e65ddc31651beeafd733afb93d4108097beebec2c2053f358a7e533ec3eb');
 		$data = [
		'otp'=>$otp
		];

		$url="https://test.payumoney.com/dmt/customer/verifyOTP/".$mobile_no;
		$body= json_encode($data, true);
		$response = Helper::__curl_execute('POST',$url,$body,$header_data);
		return $response;
	}

	/*------------------Beneficiary List----------------------*/
	public static function beneficiary_list($mobile_no)
	{

        $header_data=array('Content-type: application/json', 
							'payuDistributorId: 29',
							'Authorization: Bearer b738e65ddc31651beeafd733afb93d4108097beebec2c2053f358a7e533ec3eb');
		$data = '';
		$url="https://test.payumoney.com/dmt/customer/".$mobile_no."/beneficiaries";
		$body= json_encode($data, true);
		$response = Helper::__curl_execute('GET',$url,$body,$header_data);
		return $response;
	}

	 /*------------------Beneficiary Add----------------------*/
	public static function beneficiary_add($agent_id,$account_number,$bankname,$ifsccode,$mobile_no,$beneName,$verified)
	{

        $header_data=array('Content-type: application/json', 
							'payuDistributorId: 29',
							'Authorization: Bearer b738e65ddc31651beeafd733afb93d4108097beebec2c2053f358a7e533ec3eb');
 		$data = ['agentId'=> $agent_id,
		'beneAccount'=> $account_number,
		'beneBankName'=> $bankname,
		'beneIfscCode'=> $ifsccode,
		'beneMobileNumber'=> $mobile_no,
		'beneName' => $beneName,
		'isVerified' => $verified
		];

		$url="https://test.payumoney.com/dmt/customer/".$agent_id."/beneficiaries";
		$body= json_encode($data, true);
		$response = Helper::__curl_execute('POST',$url,$body,$header_data);
		return $response;
	}


	/*------------------Beneficiary Delete----------------------*/
	public static function beneficiary_verify($mobile_no,$beneId,$otp)
	{

        $header_data=array('Content-type: application/json', 
							'payuDistributorId: 29',
							'Authorization: Bearer b738e65ddc31651beeafd733afb93d4108097beebec2c2053f358a7e533ec3eb');
 		$data = ['otp'=> $otp
		];

		$url="https://test.payumoney.com/dmt/customer/".$mobile_no."/beneficiaries/verifyOTP/".$beneId;
		$body= json_encode($data, true);
		$response = Helper::__curl_execute('POST',$url,$body,$header_data);
		return $response;
	}

	/*------------------Beneficiary Delete----------------------*/
	public static function customer_limit($mobile_no)
	{

        $header_data=array('Content-type: application/json', 
							'payuDistributorId: 29',
							'Authorization: Bearer b738e65ddc31651beeafd733afb93d4108097beebec2c2053f358a7e533ec3eb');
 		$data = ['customerMobile'=> $mobile_no
		];

		$url="https://test.payumoney.com/dmt/customer/limit";
		$body= json_encode($data, true);
		$response = Helper::__curl_execute('POST',$url,$body,$header_data);
		return $response;
	}
}

?>