<?php
namespace App\Helpers;
use DB;
use Session;
use Razorpay\Api\Api;
use Illuminate\Support\Str;
use Hash;
class Helper
{

    public static function __curl_execute($api_url,$encrypt_xml_data)
	{
		$key = "1ACF0480438D1DA5C006194AC61C0C5F";
		$data['accessCode'] = "AVMN39GU35OZ97LQZC";
		$data['requestId'] = Helper::generateRandomString();
		$data['ver'] = "1.0";
		$data['instituteId'] = "IP02";
		$parameters = http_build_query($data);
		$url = "https://stgapi.billavenue.com/billpay/extMdmCntrl/mdmRequestNew/xml?".$parameters;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypt_xml_data);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: text/xml'));
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		$result = curl_exec($ch);
		echo 'Encrypted Response: ' . $result . "<br><br>";
		$response = Helper::decrypt($result,$key);
		echo "<pre>";
		echo htmlentities($response);
		exit;
    }



//********** To generate ramdom String ********
public static function generateRandomString($length = 35) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}


//********** Hexadecimal to Binary function for php 4.0 version ********
public static function hextobin($hexString) {
    $length = strlen($hexString);
    $binString = "";
    $count = 0;
    while ($count < $length) {
        $subString = substr($hexString, $count, 2);
        $packedString = pack("H*", $subString);
        if ($count == 0) {
            $binString = $packedString;
        } else {
            $binString .= $packedString;
        }

        $count += 2;
    }
    return $binString;
}


//*********** Encryption Function *********************
public static function encrypt($plainText, $key) {
    $secretKey = hex2bin(md5($key));
    $initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
    $openMode = openssl_encrypt($plainText, 'AES-128-CBC', $secretKey, OPENSSL_RAW_DATA, $initVector);
    $encryptedText = bin2hex($openMode);
    return $encryptedText;
}

//*********** Decryption Function *********************
public static function decrypt($encryptedText, $key) {
    $key = hex2bin(md5($key));
    $initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
    $encryptedText = hex2bin($encryptedText);
    $decryptedText = openssl_decrypt($encryptedText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
    return $decryptedText;
}

public static function notify_data($request,$type=null,$notifiable=null,$data=null,$user_id=null,$is_employee=null)
    {
			$show=3;
			if($is_employee==3){$show=1;}
			else{$show=$is_employee;}
            $dataarray=array(
                'm51_type'=> $type,
                'm51_notifiable'=>$notifiable,
                'm51_data'=> $data,
				'm51_show'=>$show,
				'm51_user_id'=>$user_id,
				'm51_isemplooyee'=>$is_employee
            	);
            DB::table('m51_notifications')->insert($dataarray);
     }

	public static function unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info)
    {
        $dataarray=array(
            'm72_file_type'=>$file_type,
            'm72_request'=> $request_data,
			'm72_user_id'=> $user_id,
			'm72_server_info'=> $server_info,
			'm72_full_user_info'=> $user_info
        );
        DB::table('m72_unwanted_activity')->insert($dataarray);
    }

	public static function is_admin()
	{
			$login_detail = DB::table('m00_admin_login')->where('m00_login_id',1)->get();
			$count = count($login_detail);
			if($count == 1){
				return TRUE;
			}else{
				return FALSE;
			}
	}
	public static function get_storeid($id)
	{
	$member_detail = DB::select("SELECT * FROM `m44_store` WHERE `m44_store_userid` = '".$id."'");
	if( !empty( $member_detail ) ){

			return $member_detail[0]->m44_store_id;

		}else{

			return false;

		}
	}
	public static function get_ledgerwise_income($id,$income_type)
	{
	   $income =  DB::select("SELECT ROUND(get_balby_income(".$id.",".$income_type."),2) as bal");
	   return $income;
	}
    
    public static function get_userdirect($id)
	{
	$login_detail = DB::select("SELECT COUNT(*) AS TOT_DIRECT FROM `enroll` WHERE `ReferralCode`='".$id."'");
	if(!empty($login_detail)){
			return $login_detail[0]->TOT_DIRECT;
		}else{
			return false;
		}
	}
	public static function get_useractivedirect($id)
	{
	$login_detail = DB::select("SELECT COUNT(*) AS TOT_DIRECT FROM `enroll` WHERE TOPUP_DATE<>'' AND  `ReferralCode`='".$id."'");
	if(!empty($login_detail)){
			return $login_detail[0]->TOT_DIRECT;
		}else{
			return false;
		}
	}

   public static function get_userkyc($id)
	{
	$kyc_detail = DB::select("SELECT `m19_user_kyc`.`m19_uk_status` AS `KYCStatus` FROM `m19_user_kyc` WHERE  `m19_user_kyc`.`m11_user_id`='".$id."'");
	if(!empty($kyc_detail)){
			return $kyc_detail[0]->KYCStatus;
		}else{
			return 'PENDING';
		}
	}
	public static function get_treedetails($id)
	{
	   $user_tree =  DB::select("SELECT * FROM `tree` WHERE `USER_ID`='".$id."'");
	   return $user_tree;
	}  
	public static function get_admin_details(){
	$login_detail = DB::select("SELECT * FROM m00_admin_login WHERE 1 LIMIT 1");
	return $login_detail;
	}
	public static function get_userdetail($id)
	{
	$login_detail = DB::select("SELECT * FROM enroll WHERE RegId=".$id." ORDER BY PACKAGE_NAME ASC LIMIT 1");
	return $login_detail;
	}

	public static function get_dmtuserdetail($id)
	{
	$login_detail = DB::select("SELECT * FROM dmt_userdetails WHERE REM_ID=".$id."");
	return $login_detail;
	}

	public static function get_empdetail($id)
	{
	$login_detail1 = DB::select("SELECT * FROM `employee_enroll` WHERE RegId=".$id."");
	return $login_detail1;
	}

	public static function get_all_empdetail()
	{
	$login_detail2 = DB::select("SELECT * FROM `employee_enroll` WHERE MemberStatus='Active'");
	return $login_detail2;
	}
 
   public static function get_user_bene_detail($id)
   {
	$bene_detail = DB::select("SELECT * FROM `user_benedetails` WHERE `RegId`='".$id."' AND BENE_STATUS!='DELETED'");
	return $bene_detail;
	}

	public static function get_beneficiary_detail($id)
	{
	$bene_detail = DB::select("SELECT * FROM `user_benedetails` WHERE `BENE_ID`='".$id."' AND BENE_STATUS!='DELETED'");
	return $bene_detail;
	}

	public static function get_useralldetail($id)
	{
	$login_detail = DB::select("SELECT * FROM `user_details` WHERE `RegId`='".$id."' AND MemberStatus='Active'");
	return $login_detail;
	}

	public static function get_usershopdetail($id)
	{
	$shop_detail = DB::select("SELECT * FROM `user_shopdetails` WHERE `RegId`=".$id);
	return $shop_detail;
	}	

	public static function get_empalldetail($id)
	{
	$login_detail = DB::select("SELECT * FROM `employee_details` WHERE `RegId`='".$id."' AND MemberStatus='Active'");
	return $login_detail;
	}

	public static function getuserdetail_ByCode($id)
	{
	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberCode`='".$id."' AND MemberStatus='Active'");
	return $member_detail;
	}

	public static function getuserdetail_ByMobileNo($mobileno)
	{
	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberContactNo`='".$mobileno."' AND MemberStatus='Active'");
	return $member_detail;
	}

	public static function get_userid($id)
	{
	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberCode`='".$id."' AND MemberStatus='Active'");
	if( !empty( $member_detail ) ){

			return $member_detail[0]->RegId;

		}else{

			return false;

		}
	}

	public static function get_introid($id)
	{
	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberCode`='".$id."' AND MemberStatus='Active'");
	if( !empty( $member_detail ) ){

			return $member_detail[0]->ReferralCode;

		}else{

			return false;

		}
	}

	public static function get_userbscaddress($id)
	{

	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberCode`='".$id."' AND MemberStatus='Active'");
	if( !empty( $member_detail ) ){

			return $member_detail[0]->BSCAddress;

		}else{

			return false;

		}
	}


	public static function get_userbscaddress_by_userid($id)
	{

	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `BSCAddress`='".$id."' AND MemberStatus='Active'");
	if( !empty( $member_detail ) ){

			return $member_detail[0]->MemberCode;

		}else{

			return false;

		}
	}

	public static function get_userbscaddress_by_usercode($id)
	{

	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `BSCAddress`='".$id."' AND MemberStatus='Active'");
	if( !empty( $member_detail ) ){

			return $member_detail[0]->RegId;

		}else{

			return false;

		}
	}


	public static function get_userid_by_mobile($mobileno)
	{
	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberContactNo`='".$mobileno."' AND MemberStatus='Active'");
	if( !empty( $member_detail ) ){

			return $member_detail[0]->RegId;

		}else{

			return false;

		}
	}

	public static function get_dmtuser_by_mobile($mobileno)
	{
	$member_detail = DB::select("SELECT * FROM `dmt_userdetails` WHERE `REM_CONTACT`='".$mobileno."' AND REM_STATUS='ACTIVE'");
	if( !empty( $member_detail ) ){

			return $member_detail[0]->REM_ID;

		}else{

			return false;

		}
	}

	public static function get_userid_from_contact($mobileno)
	{
	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberContactNo`='".$mobileno."' AND MemberStatus='Active'");
	if( !empty( $member_detail ) ){

			return $member_detail[0]->RegId;

		}else{

			return false;

		}
	}

	public static function get_empid($id)
	{
		$emp_detail = DB::select("SELECT * FROM `employee_enroll` WHERE `MemberCode`='".$id."' AND MemberStatus='Active'");
		
		if( !empty( $emp_detail ) ){
			return $emp_detail[0]->RegId;
		}else{
			return false;
		}
	}

public static function get_user_main_bal($id,$for)
	{
	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberCode`='".$id."' AND MemberStatus='Active'");
	if( !empty( $member_detail ) ){
				if($for==1)
			return $member_detail[0]->RECHARGE_BAL;
				if($for==2)
				return $member_detail[0]->UTILITY_BAL;
		}else{

			return false;

		}
	}

	public static function get_user_name($id)
	{
	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberCode`='".$id."' AND MemberStatus='ACTIVE'");
	
	if( !empty( $member_detail ) ){

			return $member_detail[0]->MemberName;

		}else{

			return false;

		}
	}
	
	public static function get_user_name1($id)
	{
	$member_detail = DB::select("SELECT * FROM `m11_user` WHERE `m11_user_code`='".$id."' AND m11_user_status='ACTIVE'");
	
	if( !empty( $member_detail ) ){

			return $member_detail[0]->m11_user_name;

		}else{

			return false;

		}
	}
public static function get_userid1($id)
	{
	$member_detail = DB::select("SELECT * FROM `m11_user` WHERE `m11_user_code`='".$id."' AND m11_user_status='Active'");
	if( !empty( $member_detail ) ){

			return $member_detail[0]->m11_user_id;

		}else{

			return false;

		}
	}
	
	public static function get_userbscaddress1($id)
	{

	$member_detail = DB::select("SELECT * FROM `m11_user` WHERE `m11_user_code`='".$id."' AND m11_user_status='Active'");
	if( !empty( $member_detail ) ){

			return $member_detail[0]->m11_bsc_address;

		}else{

			return false;

		}
	}

	public static function get_employee_name($id)
	{
	$employee_detail = DB::select("SELECT * FROM `employee_enroll` WHERE `MemberCode`='".$id."' AND MemberStatus='ACTIVE'");
	
		if(!empty($employee_detail)){

			return $employee_detail[0]->MemberName;

		}else{

			return false;

		}
	}
	/*----------------Get Bal From User Id------------------*/
	public static function get_bal($id,$bal_Type)
	{
		$res = DB::select("SELECT get_available_bal($id,$bal_Type) as bal");
		if(!empty($res)){
			return $res;
		}
		
	}
	/*----------------Get Bal From User Id------------------*/

	public static function get_config_ImageByName($name)
	{
	   $config_image = DB::table('m00_setconfig')->where('m00_name',$name)->get();
	   //dd(	$config_image[0]);
    	return $config_image[0];
	}
    public static function get_configwl_ImageByName($name)
	{
	$config_image =DB::table('m00_setconfig_wl')->where('m00_name',$name)->where('m00_affid',Session::get('AFFILIATE_CODE'))->get();
	   //dd(	$config_image[0]);
    	return $config_image[0];
	}
	public static function  get_memberChild($id)
	{
	   $user_child =  DB::select("SELECT * FROM `user_details` WHERE `ParentCode`='".$id."'");
	   return $user_child;
	}

	public static function get_api($api_for,$status)
    {
		
		if($api_for==-1)
		{
	      $api = DB::select("SELECT * FROM `api` WHERE API_STATUS='".$status."'");
		}
		else 
		{
		 $api = DB::select("SELECT * FROM `api` WHERE API_FOR=".$api_for." AND API_STATUS='".$status."'");
		}
		 return $api;
	}
	public static function  get_operator($serviceid,$status)
	{
		if($serviceid==-1)
		{
			if($status!="ALL")
	      		$operator = DB::select("SELECT * FROM `telecom_brand` WHERE BrandStatus='".$status."'");
	  		else
	  			$operator = DB::select("SELECT * FROM `telecom_brand` WHERE 1");
		}
		else if ($serviceid==-2) 
		{
			$operator = DB::select("SELECT * FROM `telecom_brand` WHERE `ServiceTypeId` IN(1,2) AND BrandStatus='Active' ORDER BY TelecomBrandId ");
		}
		else 
		{
		    $operator = DB::select("SELECT * FROM `telecom_brand` WHERE `ServiceTypeId`='".$serviceid."' AND BrandStatus='".$status."'");
		}
	   return $operator;
	}
	public static function get_login_log($userid)
	{
		if($userid==0)
		{
	      $login_log = DB::select("SELECT * FROM admin_loginlog WHERE USER_ID=0 LIMIT 100");
		}
		else if($userid==-1)
		{
			$login_log = DB::select("SELECT * FROM login_log WHERE USER_ID!=0 AND 1 LIMIT 100");
		}
		else 
		{
		  $login_log = DB::select("SELECT * FROM login_log WHERE USER_ID='".$userid."' LIMIT 100");
		}
	   return $login_log;
	}
	
	public static function get_group($user,$status){
		
		if($user==-1)
		{
	      $group = DB::select("SELECT * FROM `group` WHERE GROUP_STATUS='".$status."'");
		}
		else 
		{
		 $group = DB::select("SELECT * FROM `group` WHERE USER_ID=".$user." AND GROUP_STATUS='".$status."'");
		}
		 return $group;
	}

	public static function get_bankaccount($user,$status)
	{
		
		if($user==-1)
		{
					  $bank_account = DB::select("SELECT * FROM `company_bank_account` WHERE BANK_STATUS=".$status."");
		}
		else 
		{
			 $bank_account = DB::select("SELECT * FROM `company_bank_account` WHERE `USER_ID`=".$user." AND BANK_STATUS=".$status."");
		}
		 return $bank_account;
	}

	public static function get_news($user,$status,$for)
	{
		
		if($user==-1)
		{
			$news = DB::select("SELECT * FROM `news` WHERE NewsStatus='".$status."'");
		}
		else 
		{
			$news = DB::select("SELECT * FROM `news` WHERE `AffID`=".$user." AND NewsStatus='".$status."' AND NewsFor='".$for."'");
		}
		return $news;
	}

	public static function reg_data($request, $pass=null,$pinpass=null,$file=null,$panfile=null,$adharfile=null,$gstno=null,$bankproof=null)
    {
		$first_name="";
		$last_name="";
		 $role='8';
		 $role1=$request->has('dd_role')?'1':'0' ;
		  if($role1!=0)
			$role=$request->input('dd_role');
			if($request->input('dd_role')!='')
				$role=$request->input('dd_role');
					$member_detail = DB::select("SELECT * FROM `enroll` WHERE `RegCode`='".$request->input('txt_referralcode')."' AND MemberStatus='Active'");
					$affid=$member_detail[0]->Affid;
					$groupid=$member_detail[0]->GroupId;
				$status='1';
				$txt_parentcode=$request->input('txt_referralcode');
				$txt_parentcode1=$request->has('txt_parentcode')?'1':'0' ;
				$status1=$request->has('dd_status')?'1':'0' ;
			if($status1!=0)
				$status=$request->input('dd_status');
			if($request->input('dd_status')!='')
				$status=$request->input('dd_status');


				

			if($txt_parentcode1!=0)
				$txt_parentcode=$request->input('txt_parentcode');

			if($request->input('txt_parentcode')!='')
				$txt_parentcode=$request->input('txt_parentcode');


					$name=explode(" " ,$request->input('txt_username'));
					if(sizeof($name)==1)
					{ 
					  $first_name= $name[0];
					  $last_name="K";
					}
					if(sizeof($name)>1)
					{ 
					  $first_name= $name[0];
					  $last_name= $name[1];
					}
				
			if($request->hasFile('txt_addressproof'))
				{
					$image = $request->file('txt_addressproof');
					$name = time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/USER_ADDRESSPROOF');
					$image->move($destinationPath, $name);
					$txt_addressproof = $name;
				}
				else
				{
					$txt_addressproof = '';
				}

         $data=array(
                'proc'=>1,
                'm11_user_id'=>0,
                'm11_user_code'=>'',
                'm22_affiliate_id'=>$affid,
                'm11_first_name'=> $first_name,
                'm11_last_name'=> $last_name,
                'm11_user_name'=> $request->input('txt_username'),
                'm11_user_dob'=>'1970-01-01',
                'm11_user_gender'=> 1,
                'm11_user_email'=> $request->input('txt_email'),
                'm11_user_contactno'=> $request->input('txt_mobileno'),
                'm11_user_about_me'=>'',
                'm11_user_interested_in'=>'',
                'm16_gr_id'=>$groupid,
                'm11_user_location'=> $request->input('txt_address'),
				'm11_user_country'=> $request->input('dd_country'),
				'm11_user_state'=> $request->input('dd_state'),
				'm11_user_city'=> $request->input('dd_city'),
                'm11_user_image'=> '',
                'm11_user_role'=>$role,
                'm11_cancellation_policy'=>2,
                'm11_subcription'=> 2,
                'm11_fb_id'=>$request->input('dd_user_forwallet'),
			    'm11_gplus_id'=> $request->input('dd_package'),
                'm11_user_status'=> $status,
                'm11_user_callback'=>$request->input('dd_wallet'),
                'm11_user_islogin'=> 2,
                'm11_user_istraveling'=> '',
                'm11_user_notifications'=> 1,
                'm11_user_emailalert'=> 1,
                'm11_user_newsletter'=> 1,
                'm11_user_language'=> 1,
                'm11_user_activate_code'=>$request->input('txt_aadhar'),
				'm11_user_api_token'=> uniqid ( base64_encode (Str::random(30))),
                'm11_user_device_token'=>$request->input('txt_panno'),
                'm11_user_device_type'=>$request->input('txt_accno'),
                'm11_user_app_version'=>$request->input('txt_ifsccode'),
                'm11_user_latitude'=>$request->input('dd_bank'),
                'm11_user_longitude'=>$request->input('txt_branchname'),
                'm11_user_referral_code'=> $request->input('txt_referralcode'),
				'm11_user_parent_code'=> $txt_parentcode,
				'm11_user_position'=> $request->input('dd_position'),
				'm22_shop_company_name'=> $request->input('txt_shopname'),
				'm22_shop_gstin'=> $request->input('txt_gstno'),
				'm22_shop_gstin_copy'=> $gstno,
				'm22_shop_bankproof_copy'=> $bankproof,
				'm19_uk_idproof_type'=> $request->input('ddaddproof'),
				'm19_uk_id_img'=> $txt_addressproof ,
				'm19_uk_id_number'=> $request->input('txt_idno'),
				'tr04_login_pwd'=>Hash::make($pass),
				'tr04_pin_pwd'=>Hash::make($pinpass)
            );
        return $data;
     }



    public static function reg_employee($request,$pass=null,$pinpass=null,$file=null,$panfile=null,$adharfile=null,$gstno=null,$bankproof=null)
    {
		$first_name="";
		$last_name="";$role='8';
		$role1=$request->has('dd_role')?'1':'0' ;
		if($role1!=0)
			$role=$request->input('dd_role');
		if($request->input('dd_role')!='')
			$role=$request->input('dd_role');
        $affid='1';$status='1';
        $status1=$request->has('dd_status')?'1':'0' ;
		if($status1!=0)
			$status=$request->input('dd_status');
        if($request->input('dd_status')!='')
          $status=$request->input('dd_status');
          $name=explode(" " ,$request->input('txt_username'));
          if(sizeof($name)==1)
          { 
            $first_name= $name[0];
            $last_name="K";
          }
          if(sizeof($name)>1)
          { 
            $first_name= $name[0];
            $last_name= $name[1];
          }
         $data=array(
                'proc'=>1,
                'm30_employee_id'=>0,
                'm30_employee_code'=>'',
                'm22_affiliate_id'=>$affid,
                'm30_first_name'=> $first_name,
                'm30_last_name'=> $last_name,
                'm30_employee_name'=> $request->input('txt_username'),
                'm30_employee_dob'=>'1970-01-01',
                'm30_employee_gender'=> 1,
                'm30_employee_email'=> $request->input('txt_email'),
                'm30_employee_contactno'=> $request->input('txt_mobileno'),
                'm30_employee_about_me'=>'',
                'm30_employee_interested_in'=>'',
                'm16_gr_id'=>1,
                'm30_employee_location'=> $request->input('txt_address'),
				'm30_employee_country'=> $request->input('dd_country'),
				'm30_employee_state'=> $request->input('dd_state'),
				'm30_employee_city'=> $request->input('dd_city'),
                'm30_employee_image'=> '',
                'm30_employee_role'=>$role,
                'm30_cancellation_policy'=>2,
                'm30_subcription'=> 2,
                'm30_fb_id'=>$request->input('dd_user_forwallet'),
                'm30_gplus_id'=> $request->input('dd_package'),
                'm30_employee_status'=> $status,
                'm30_employee_callback'=>$request->input('dd_wallet'),
                'm30_employee_islogin'=> 2,
                'm30_employee_istraveling'=> '',
                'm30_employee_notifications'=> 1,
                'm30_employee_emailalert'=> 1,
                'm30_employee_newsletter'=> 1,
                'm30_employee_language'=> 1,
                'm30_employee_activate_code'=>$request->input('txt_aadhar'),
                'm30_employee_api_token'=> uniqid ( base64_encode (Str::random(30))),
                'm30_employee_device_token'=>$request->input('txt_panno'),
                'm30_employee_device_type'=>$request->input('txt_accno'),
                'm30_employee_app_version'=>$request->input('txt_ifsccode'),
                'm30_employee_latitude'=>$request->input('dd_bank'),
                'm30_employee_longitude'=>$request->input('txt_branchname'),
                'm30_employee_referral_code'=> $request->input('txt_referralcode'),
                'm30_employee_parent_code'=> '1',
                'm30_employee_position'=>$request->input('position'),
                'm22_shop_company_name'=> $request->input('txt_shopname'),
                'm22_shop_gstin'=> $request->input('txt_gstno'),
                'm22_shop_gstin_copy'=> $gstno,
                'm22_shop_bankproof_copy'=> $bankproof,
                'tr35_login_pwd'=>$pass,
                'tr35_pin_pwd'=>$pinpass,
            );
//dd($data);
        return $data;
     }



public static function reg_data1($request,$pass=null,$pinpass=null,$file=null,$panfile=null,$adharfile=null,$gstno=null,$bankproof=null)
    {
		$first_name="";
		$last_name="";
		$address="NA";
		 $role='8';
		 $address1=$request->has('txt_address')?'1':'0' ;
		  if($address1!=0)
			$address=$request->input('txt_address');
			$role1=$request->has('dd_role')?'1':'0' ;
			if($role1!=0)
			$role=$request->input('dd_role');
			if($request->input('dd_role')!='')
				$role=$request->input('dd_role');
				$affid='1';
				$status='1';$txt_parentcode=$request->input('txt_referralcode');
				$status1=$request->has('dd_status')?'1':'0' ;
				$txt_parentcode1=$request->has('txt_parentcode')?'1':'0' ;
			if($status1!=0)
				$status=$request->input('dd_status');
			if($request->input('dd_status')!='')
				$status=$request->input('dd_status');

			if($txt_parentcode1!=0)
				$txt_parentcode=$request->input('txt_parentcode');

			if($request->input('txt_parentcode')!='')
				$txt_parentcode=$request->input('txt_parentcode');

					$name=explode(" " ,$request->input('txt_username'));
					if(sizeof($name)==1)
					{ 
					  $first_name= $name[0];
					  $last_name="K";
					}
					if(sizeof($name)>1)
					{ 
					  $first_name= $name[0];
					  $last_name= $name[1];
					}
         $data=array(
                'proc'=>1,
                'm11_user_id'=>0,
                'm11_user_code'=>'',
                'm22_affiliate_id'=>$affid,
                'm11_first_name'=> $first_name,
                'm11_last_name'=> $last_name,
                'm11_user_name'=> $request->input('txt_username'),
                'm11_user_dob'=>'1970-01-01',
                'm11_user_gender'=> 1,
                'm11_user_email'=> $request->input('txt_email'),
                'm11_user_contactno'=> $request->input('txt_mobileno'),
                'm11_user_about_me'=>'',
                'm11_user_interested_in'=>'',
                'm16_gr_id'=>1,
                'm11_user_location'=>$address,
                'm11_user_image'=> '',
                'm11_user_role'=>$role,
                'm11_cancellation_policy'=>2,
                'm11_subcription'=> 2,
                'm11_fb_id'=>'0',
			    'm11_gplus_id'=> '',
                'm11_user_status'=> $status,
                'm11_user_callback'=>'',
                'm11_user_islogin'=> 2,
                'm11_user_istraveling'=> '',
                'm11_user_notifications'=> 1,
                'm11_user_emailalert'=> 1,
                'm11_user_newsletter'=> 1,
                'm11_user_language'=> 1,
                'm11_user_activate_code'=> '',
				'm11_user_api_token'=> uniqid ( base64_encode (Str::random(30))),
                'm11_user_device_token'=> '',
                'm11_user_device_type'=> '',
                'm11_user_app_version'=> '',
                'm11_user_latitude'=>'',
                'm11_user_longitude'=>'',
                'm11_user_referral_code'=> $request->input('txt_referralcode'),
				'm11_user_parent_code'=> $txt_parentcode,
				'm11_user_position'=> 'LEFT',
				'm22_shop_company_name'=> $request->input('txt_shopname'),
				'm22_shop_gstin'=> $request->input('txt_gstno'),
				'm22_shop_gstin_copy'=> $gstno,
				'm22_shop_bankproof_copy'=> $bankproof,
				'tr04_login_pwd'=>$pass,
				'tr04_pin_pwd'=>$pinpass
            );
        return $data;
     }


	/* -------- GET All API  */
	public static function get_apioperator($api_id,$status)
    {
		
		if($api_id==-1)
		{
	      $apioperator = DB::select("SELECT * FROM `service_provider` WHERE ApiStatus='".$status."'");
		}
		else 
		{
		 $apioperator = DB::select("SELECT * FROM `service_provider` WHERE ApiId=".$api_id." AND ApiStatus='".$status."'");
		}
		 return $apioperator;
	}

		public static function get_response($apiid,$status)
		{
			if($apiid==-1)
			{
			  $response = DB::select("SELECT * FROM `resp_status` WHERE RESP_STATUS='".$status."'");
			}
			else 
			{
			 $response = DB::select("SELECT * FROM `resp_status` WHERE API_ID=".$apiid." AND RESP_STATUS='".$status."'");
			}
			 return $response;
		}

		public static function get_apicode($apiid,$brandid)
		{
			$api_opcode = DB::select("SELECT get_api_code(".$apiid.",".$brandid.") as APICODE ");
			if($api_opcode[0]->APICODE)
				{
					return $api_opcode[0]->APICODE;
				}
				else
				{
					return 0;
				}
		}

public static function getBetween($content,$start,$end){
	    $r = explode($start, $content);
	    if (isset($r[1])){
	        $r = explode($end, $r[1]);
	        return $r[0];
	    }
	    return '';
	}

        public static function get_user_investment($user,$status)
		{
			$investment = DB::select("SELECT get_user_investment(".$user.",".$status.") as Amount ");
			return $investment[0]->Amount;
		}
		 public static function get_allot_coin($user,$status)
		{
			$investment = DB::select("SELECT get_user_investment(".$user.",3) as Amount ");
			return $investment[0]->Amount;
		}
		 public static function get_avail_coin($user,$status)
		{
			$investment = DB::select("SELECT get_user_investment(".$user.",4) as Amount ");
			return $investment[0]->Amount;
		}
	    public static function get_fund_request($user,$status)
		{
			$fund_request = DB::select("SELECT get_fund_request(".$user.",".$status.") as Amount ");
			return $fund_request[0]->Amount;
		}
		/**
		*This function is used to validate the phone number
		*@param string $str
		*@return Boolean
	*/
	public static function _valid_phone_number($str)
	{
		$regex = "/^[+(0-9)0-9-0-9 . ]+$/";
		if(preg_match($regex,$str))
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}


	public static function coinpayments_api_call($cmd,$coin,$req = array()) {
    // Fill these in from your API Keys page
    //$public_key = '385bd2f580d369423becf3c2af2b3502d4a9d6743fb426b28550de65e48e3905';
    //$private_key = '9d754044E2108F91bC2c84965d00aFB9Ef5031ec1be7140C46fd64fcb4DB9105';

   $public_key = '3763a2c94c8ed0275f0620bd90c15fdadffafac5756447d1e976523dd99b9af4';
    $private_key = '1a12edE892b50524871e2b948ffc8d9877C9BB9dd64EB4C0dA93E5201ba6caC3';
    
    // Set the API command and required fields
    $req['version'] = 1;
	$req['currency'] = $coin;
	$req['label'] = 'FOR ACCEPT PAYMNETS ADDRESS';
    $req['cmd'] = $cmd;
    $req['key'] = $public_key;
    $req['format'] = 'json'; //supported values are json and xml
    
    // Generate the query string
    $post_data = http_build_query($req, '', '&');
    
    // Calculate the HMAC signature on the POST data
    $hmac = hash_hmac('sha512', $post_data, $private_key);
    
    // Create cURL handle and initialize (if needed)
    static $ch = NULL;
    if ($ch === NULL) {
        $ch = curl_init('https://www.coinpayments.net/api.php');
        curl_setopt($ch, CURLOPT_FAILONERROR, TRUE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    }
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('HMAC: '.$hmac));
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
    
    // Execute the call and close cURL handle     
    $data = curl_exec($ch);                
    // Parse and return data if successful.
    if ($data !== FALSE) {
        if (PHP_INT_SIZE < 8 && version_compare(PHP_VERSION, '5.4.0') >= 0) {
            // We are on 32-bit PHP, so use the bigint as string option. If you are using any API calls with Satoshis it is highly NOT recommended to use 32-bit PHP
            $dec = json_decode($data, TRUE, 512, JSON_BIGINT_AS_STRING);
        } else {
            $dec = json_decode($data, TRUE);
        }
        if ($dec !== NULL && count($dec)) {
            return $dec;
        } else {
            // If you are using PHP 5.5.0 or higher you can use json_last_error_msg() for a better error message
            return array('error' => 'Unable to parse JSON result ('.json_last_error().')');
        }
    } else {
        return array('error' => 'cURL error: '.curl_error($ch));
    }
}




	/**
	 * [_curl_execute description]
	 * @param  [type] $url  [description]
	 * @param  [type] $data [description]
	 * @return [type]       [description]
	 */
	public static function _curl_execute($method,$url,$data)
	{
		if($method=="POST")
		{
			$ch = curl_init($url);
			curl_setopt($ch, CURLOPT_POST, true);           // set method to POST
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // set to return data to string ($result)
			curl_setopt($ch, CURLOPT_TIMEOUT, 56);          // set timeout to 56s
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);   // pass $param as post fields
			$result = curl_exec($ch); 
			if(!$result)
			{
				$result=trigger_error(curl_error($ch));
				curl_close($ch);
				return $result;
			}
			else
			{	                
				curl_close($ch);
				return $result;
			}
		}
		if($method=="GET" && $data!="")
		{
			$options = array(
			CURLOPT_SSL_VERIFYHOST => 0,
			CURLOPT_SSL_VERIFYPEER => 0
			);
			$defaults = array(
			CURLOPT_URL => $url. (strpos($url, '?') === FALSE ? '?' : ''). http_build_query($data),
			CURLOPT_HEADER => 0,
			CURLOPT_RETURNTRANSFER => TRUE,
			CURLOPT_TIMEOUT =>56
			);
			$ch = curl_init();
			curl_setopt_array($ch, ($options + $defaults));
			$result = curl_exec($ch);
			if(!$result)
			{
				$result=trigger_error(curl_error($ch));
				curl_close($ch);
				return $result;
			}
			else
			{	                
				curl_close($ch);
				return $result;
			}
		}
		if($method=="GET" && $data=="")
		{
			$options = array(
			CURLOPT_SSL_VERIFYHOST => 0,
			CURLOPT_SSL_VERIFYPEER => 0
			);
			$defaults = array(
			CURLOPT_URL => $url,
			CURLOPT_HEADER => 0,
			CURLOPT_RETURNTRANSFER => TRUE,
			CURLOPT_TIMEOUT =>56
			);
			$ch = curl_init();
			curl_setopt_array($ch, ($options + $defaults));
			$result = curl_exec($ch);
			if(!$result)
			{
				$result=trigger_error(curl_error($ch));
				curl_close($ch);
				return $result;
			}
			else
			{	                
				curl_close($ch);
				return $result;
			}
		}
	}


/**
			* Method name	: Send Sms
			* @description 	: Used for sending sms on registration 
			* @param		: user mob number and message to send  
			* @return		: send message to user registered
		*/
  	public function send_sms($mob,$msg)
	{
		$url = Config('SMS_SEND_URL');
		$params = array(
        'user'=>Config('SMS_AUTH'),
        'password'=>Config('SMS_PWD'),
        'senderid'=>Config('SMS_SENDERID'),    
        'channel'=>Config('SMS_CHANNEL'),             
        'DCS'=>0,
		'flashsms'=>0,
        'number'=>$mob,
        'text'=>$msg,     
		'route'=>Config('SMS_ROUTE')
		);

		//Helper::_curl_execute('GET',$url,$params);
	}



/**
			* Method name	: Send Sms with log 
			* @description 	: Used for sending sms on registration 
			* @param		: user mob number and message to send  
			* @return		: send message to user registered
		*/
  	public static function send_sms_or_log($sms_data)
	{
		$url = Config('SMS_SEND_URL');
		$params = array(
        'user'=>Config('SMS_AUTH'),
        'password'=>Config('SMS_PWD'),
        'senderid'=>Config('SMS_SENDERID'),    
        'channel'=>Config('SMS_CHANNEL'),             
        'DCS'=>0,
		'flashsms'=>0,
        'number'=>$sms_data['MOBILE_NO'],
        'text'=>$sms_data['MESSAGE'],   
		'route'=>Config('SMS_ROUTE')
		);

		/*$response = Helper::_curl_execute('GET',$url,$params);*/
		$response ='smd';
		DB::SELECT("INSERT INTO `m73_msg_campaign` (`m73_send_by`,`m73_send_by_id`,`m73_send_to`,`m73_subject`,`m73_desc`,`m73_response`,`m12_sms_api`,`m73_type`) 
		VALUES(".$sms_data['SEND_BY'].",".$sms_data['SEND_BY_ID'].",".$sms_data['MOBILE_NO'].",'".$sms_data['SUBJECT']."','".$sms_data['MESSAGE']."','".$response."',1,".$sms_data['TYPE'].")");
	}



	// public static function cashfree_api($url, $orders)
	// {
	// 	$curl = curl_init();
	// 	curl_setopt_array($curl, array(
	// 	  CURLOPT_URL => $url,
	// 	  CURLOPT_RETURNTRANSFER => true,
	// 	  CURLOPT_ENCODING => '',
	// 	  CURLOPT_MAXREDIRS => 10,
	// 	  CURLOPT_TIMEOUT => 0,
	// 	  CURLOPT_FOLLOWLOCATION => true,
	// 	  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	// 	  CURLOPT_CUSTOMREQUEST => 'POST',
	// 	  CURLOPT_POSTFIELDS => $orders,
	// 	));		
	// 	$response = curl_exec($curl);
	// 	curl_close($curl);
	// 	return $response;
	// }

	// public static function cashfree_api_header($url, $orders='')
	// {
	// 	$curl = curl_init();


	// 	if($orders == '' )
	// 	{
	// 		curl_setopt_array($curl, [
	// 		  CURLOPT_URL => $url,
	// 		  CURLOPT_RETURNTRANSFER => true,
	// 		  CURLOPT_ENCODING => "",
	// 		  CURLOPT_MAXREDIRS => 10,
	// 		  CURLOPT_TIMEOUT => 30,
	// 		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	// 		  CURLOPT_CUSTOMREQUEST => "POST",
	// 		  CURLOPT_HTTPHEADER => [
	// 		    "Accept: application/json",
	// 		    "x-client-id:".config('APP_ID'),
	// 		    "x-client-secret:".config('SECRETKEY')
	// 		  ]
	// 		]);
	// 	}
	// 	else
	// 	{
	// 		curl_setopt_array($curl, [
	// 		  CURLOPT_URL => $url,
	// 		  CURLOPT_RETURNTRANSFER => true,
	// 		  CURLOPT_ENCODING => "",
	// 		  CURLOPT_MAXREDIRS => 10,
	// 		  CURLOPT_TIMEOUT => 30,
	// 		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	// 		  CURLOPT_CUSTOMREQUEST => "POST",
	// 		  CURLOPT_HTTPHEADER => [
	// 		    "Accept: application/json",
	// 		    "x-client-id:".config('APP_ID'),
	// 		    "x-client-secret:".config('SECRETKEY')
	// 		  ],
	// 		  CURLOPT_POSTFIELDS => json_encode($orders),
	// 		]);
	// 	}
	
	// 	$response = curl_exec($curl);
	// 	curl_close($curl);
	// 	return $response;
	// }

	// public static function cashfreePayoutAuthorize()
	// {
	// 	$curl = curl_init();

	// 	curl_setopt_array($curl, [
	// 	  CURLOPT_URL => 'https://payout-api.cashfree.com/payout/v1/authorize',
	// 	  CURLOPT_RETURNTRANSFER => true,
	// 	  CURLOPT_CUSTOMREQUEST => "POST",
	// 	  CURLOPT_HTTPHEADER => [
	// 	    "Accept: application/json",
	// 	    "x-client-id:".config('PAYOUT_APP_ID'),
	// 	    "x-client-secret:".config('PAYOUT_SECRETKEY')
	// 	  ]
	// 	]);

	// 	$response = curl_exec($curl);
	// 	curl_close($curl);
	// 	return json_decode($response);

	// }

	// public static function cashfreePayoutVerify($url, $Token, $method='')
	// {
	// 	$curl = curl_init();
	// 	$methods="POST";
	// 	if($method !='')
	// 	{
	// 		$methods=$method;
	// 	}
	// 	curl_setopt_array($curl, [
	// 	  CURLOPT_URL => $url,
	// 	  CURLOPT_RETURNTRANSFER => true,
	// 	  CURLOPT_CUSTOMREQUEST => $methods,
	// 	  CURLOPT_HTTPHEADER => [
	// 	    "Authorization: Bearer ".$Token
	// 	  ]
	// 	]);

	// 	$response = curl_exec($curl);
	// 	curl_close($curl);
	// 	return $response;

	// }


	// public static function cashfreePayoutVerifyOrder($url, $orders, $Token)
	// {
	// 	$curl = curl_init();

	// 	curl_setopt_array($curl, [
	// 	  CURLOPT_URL => $url,
	// 	  CURLOPT_RETURNTRANSFER => true,
	// 	  CURLOPT_CUSTOMREQUEST => "POST",
	// 	  CURLOPT_HTTPHEADER => [
	// 	    "Authorization: Bearer ".$Token
	// 	  ],
	// 		CURLOPT_POSTFIELDS => json_encode($orders),
	// 	]);

	// 	$response = curl_exec($curl);
	// 	curl_close($curl);
	// 	return $response;

	// }



 	// public static function razorpay($request,  $user)
    // {    
	// 	$form_data = $request->all();

    //     // Generate random receipt id
    //     $receiptId = date('Ymdhisv').rand(1000,9999);
		
    //     // Create an object of razorpay
    //     //$api = new Api('', '');

    //     // In razorpay you have to convert rupees into paise we multiply by 100
    //     // Currency will be INR
    //     // Creating order
    //     $order = $api->order->create(array(
    //         'receipt' => $receiptId,
    //         'amount' => $form_data['txt_amount'] * 100,
    //         'currency' => 'INR'
    //         )
    //     );

	// $orders =	array(
    //         'receipt' => $receiptId,
    //         'amount' => $form_data['txt_amount'] * 100,
    //         'currency' => 'INR');

    //     // Return response on payment page
    //     $response = [
    //         'orderId' => $order['id'],
    //         'razorpayId' => 'rzp_live_IX9CfCAJspoSR9',
    //         'amount' => $form_data['txt_amount'] * 100,
    //         'name' =>  config('SITE_NAME'),
    //         'currency' => 'INR',
    //         'email' => $user->MemberEmail,
    //         'contactNumber' => $user->MemberContactNo,
    //         'address' => $user->MemberLocation.', '.$user->MemberCity.', '.$user->MemberState.', '.$user->MemberCountry,
    //         'description' =>  $user->MemberName.' Add Money In Wallet',
    //         'user_code' => $user->RegCode,
	// 		'receiptId' => $receiptId
    //     ];

	// 	DB::table('tr31_online_payment_request')->insert([
	// 													'request_rzp' =>json_encode($orders),
	// 													'request_form' =>json_encode($form_data),
	// 													'response' =>json_encode($response)
	// 													]);
    //     // Let's checkout payment page is it working
    //     //return view('payment-page',compact('response','form_data'));    
    //     return $response;
    // }


		// In this function we return boolean if signature is correct
		 public static function SignatureVerify($_signature,$_paymentId,$_orderId)
		{
				
			$data = DB::select("SELECT * FROM `online_payment` WHERE op_gatewaytxn_id = '".$_orderId."' OR op_gateway_res = '".$_signature."' LIMIT 1");
			if(count($data) > 0)
			{
				 return false;
			}
			else
			{
				try
				{
					// Create an object of razorpay class
					//$api = new Api('rzp_live_IX9CfCAJspoSR9', 'ebXBjg85A2fgKN2mveGaHv4U');
					$attributes  = array('razorpay_signature'  => $_signature,  'razorpay_payment_id'  => $_paymentId ,  'razorpay_order_id' => $_orderId);
					$order  = $api->utility->verifyPaymentSignature($attributes);
					return true;
				}
				catch(\Exception $e)
				{
					// If Signature is not correct its give a excetption so we use try catch
					return false;
				}
			}

		}







	public static function sendOtp($otp,$mobile)
    {
        ///$MSG_CONTENT = "Dear user your one time password (OTP) for login is $otp TEAM INBOX";
        /*$params = array(
            '{username}'=>'appworks',
            '{apikey}'=>'j1uq0skPeqhU',           
            '{senderid}'=>'TECBOX',           
            '{route}'=>'TRANS',
            '{tid}'=>'1707170263668881397',
            '{peid}'=>'1201160986848173706',
            '{mobile}'=>$mobile,
            '{text}'=>urlencode($MSG_CONTENT)
            );

        $url = "https://vapio.in/api.php?username={username}&apikey={apikey}&senderid={senderid}&route={route}&mobile={mobile}&text={text}&TID={tid}&PEID={peid}";
        $new_url = strtr($url, $params);

        $response = self::_curl_execute('GET',$new_url,'');*/
		    $hash = 'nJj4w4FrdFf';
            $fields = array(
            "message" => "Hi Your OTP is " . $otp . " " . $hash . "",
            "variables_values" => $otp,
            "route" => "q", //"otp"
            "numbers" => $mobile,
        );


        $curl = curl_init();
        /*I2sztjdlWyvO8ShpMJZYmgA59wDrULHuebxN6fCXKEQVainF4ccG7o0hCmXNT3V1nLt8pqFDv6dkUuJM*/
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://www.fast2sms.com/dev/bulkV2",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($fields),
            CURLOPT_HTTPHEADER => array(
                "authorization: 8TZVn7zBFbYeSr4dOkj3RuJDowaKN2Ufm0PxtpE5gMX69LC1cA5VqpyxFLts34zNDWRe9a67AJ0cQGuh",
                "accept: */*",
                "cache-control: no-cache",
                "content-type: application/json"
            ),
        ));
        //8TZVn7zBFbYeSr4dOkj3RuJDowaKN2Ufm0PxtpE5gMX69LC1cA5VqpyxFLts34zNDWRe9a67AJ0cQGuh
        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        //return     json_decode($response);

        return $response;
    }
	
	
	public static function get_userid_by_userbscaddress($id)
	{
	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `BSCAddress`='".$id."' AND MemberStatus='Active'");
	if( !empty( $member_detail ) )
	{

			return $member_detail[0]->RegId;

	}
	else
	{
			return false;
	}
	}
	
	public static function get_userwds_by_userbscaddress($id)
	{

	$member_detail = DB::select("  SELECT 1 as WD_STATUS FROM `m11_user` WHERE `m11_bsc_address`='".$id."'");
	if( !empty( $member_detail ) )
	{

			return $member_detail[0]->WD_STATUS;

	}
	else
	{
			return false;
	}
	}
	
	public static function get_usermobile_by_userbscaddress($id)
	{

	$member_detail = DB::select("SELECT * FROM `enroll` WHERE `BSCAddress`='".$id."' AND MemberStatus='Active'");
	if( !empty( $member_detail ) )
	{

			return $member_detail[0]->MemberContactNo;

	}
	else
	{
			return false;
	}
	}

}?>