<?php
namespace App\Helpers;
use DB;
use Session;
use Razorpay\Api\Api;
use Illuminate\Support\Str;
use Hash;
class CoinPayment
{

   
	public static function coinpayments_basic_info($cmd, $req = array()) {
	    // Fill these in from your API Keys page
	    $public_key = '';//'f7988f6870b1defd8c1ef262132525a14997c33bf0e321e9c3fb31f97d74bb95';
	    $private_key = '';//'E2425eF34E159f4703b33938144650fc0B5486d7e5d5067441D2f4C0283f1A94';
	    
	    // Set the API command and required fields
	    $req['version'] = 1;
	    $req['cmd'] = $cmd;
	    $req['key'] = $public_key;
	    $req['format'] = 'json'; //supported values are json and xml
	    
	    // Generate the query string
	    $post_data = http_build_query($req, '', '&');
	    
	    // Calculate the HMAC signature on the POST data
	    $hmac = hash_hmac('sha512', $post_data, $private_key);
	    
	    // Create cURL handle and initialize (if needed)
	    static $ch = NULL;
	    if ($ch === NULL) {
	        $ch = curl_init('https://www.coinpayments.net/api.php');
	        curl_setopt($ch, CURLOPT_FAILONERROR, TRUE);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	    }
	    curl_setopt($ch, CURLOPT_HTTPHEADER, array('HMAC: '.$hmac));
	    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
	    
	    // Execute the call and close cURL handle     
	    $data = curl_exec($ch);                
	    // Parse and return data if successful.
	    if ($data !== FALSE) {
	        if (PHP_INT_SIZE < 8 && version_compare(PHP_VERSION, '5.4.0') >= 0) {
	            // We are on 32-bit PHP, so use the bigint as string option. If you are using any API calls with Satoshis it is highly NOT recommended to use 32-bit PHP
	            $dec = json_decode($data, TRUE, 512, JSON_BIGINT_AS_STRING);
	        } else {
	            $dec = json_decode($data, TRUE);
	        }
	        if ($dec !== NULL && count($dec)) {
	            return $dec;
	        } else {
	            // If you are using PHP 5.5.0 or higher you can use json_last_error_msg() for a better error message
	            return array('error' => 'Unable to parse JSON result ('.json_last_error().')');
	        }
	    } else {
	        return array('error' => 'cURL error: '.curl_error($ch));
	    }
	}





	public static function coinpayments_transactions($cmd,$amt, $req = array()) {
	    // Fill these in from your API Keys page
	    $public_key = '';//'f7988f6870b1defd8c1ef262132525a14997c33bf0e321e9c3fb31f97d74bb95';
	    $private_key = '';//'E2425eF34E159f4703b33938144650fc0B5486d7e5d5067441D2f4C0283f1A94';

	    // Set the API command and required fields
	    $req['version'] = 1;
	    $req['amount'] = $amt;
	    $req['currency1'] = 'USD';
	    $req['currency2'] = 'USDT.TRC20';
	    $req['buyer_email'] = $req['email'];
	    $req['cmd'] = $cmd;
	    $req['key'] = $public_key;
	    $req['format'] = 'json'; //supported values are json and xml
	    
	    // Generate the query string
	    $post_data = http_build_query($req, '', '&');
	    
	    // Calculate the HMAC signature on the POST data
	    $hmac = hash_hmac('sha512', $post_data, $private_key);
	    
	    // Create cURL handle and initialize (if needed)
	    static $ch = NULL;
	    if ($ch === NULL) {
	        $ch = curl_init('https://www.coinpayments.net/api.php');
	        curl_setopt($ch, CURLOPT_FAILONERROR, TRUE);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	    }
	    curl_setopt($ch, CURLOPT_HTTPHEADER, array('HMAC: '.$hmac));
	    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
	    
	    // Execute the call and close cURL handle     
	    $data = curl_exec($ch);                
	    // Parse and return data if successful.
	    if ($data !== FALSE) {
	        if (PHP_INT_SIZE < 8 && version_compare(PHP_VERSION, '5.4.0') >= 0) {
	            // We are on 32-bit PHP, so use the bigint as string option. If you are using any API calls with Satoshis it is highly NOT recommended to use 32-bit PHP
	            $dec = json_decode($data, TRUE, 512, JSON_BIGINT_AS_STRING);
	        } else {
	            $dec = json_decode($data, TRUE);
	        }
	        if ($dec !== NULL && count($dec)) {
	            return $dec;
	        } else {
	            // If you are using PHP 5.5.0 or higher you can use json_last_error_msg() for a better error message
	            return array('error' => 'Unable to parse JSON result ('.json_last_error().')');
	        }
	    } else {
	        return array('error' => 'cURL error: '.curl_error($ch));
	    }
	}






	public static function coinpayments_transaction_status($cmd,$txid, $req = array()) {
	    // Fill these in from your API Keys page
	    $public_key = '';//'f7988f6870b1defd8c1ef262132525a14997c33bf0e321e9c3fb31f97d74bb95';
	    $private_key = '';//'E2425eF34E159f4703b33938144650fc0B5486d7e5d5067441D2f4C0283f1A94';
	    
	    // Set the API command and required fields
	    $req['version'] = 1;
	    $req['txid'] = $txid;
	    $req['full'] = '1';
	    $req['cmd'] = $cmd;
	    $req['key'] = $public_key;
	    $req['format'] = 'json'; //supported values are json and xml
	    
	    // Generate the query string
	    $post_data = http_build_query($req, '', '&');
	    
	    // Calculate the HMAC signature on the POST data
	    $hmac = hash_hmac('sha512', $post_data, $private_key);
	    
	    // Create cURL handle and initialize (if needed)
	    static $ch = NULL;
	    if ($ch === NULL) {
	        $ch = curl_init('https://www.coinpayments.net/api.php');
	        curl_setopt($ch, CURLOPT_FAILONERROR, TRUE);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	    }
	    curl_setopt($ch, CURLOPT_HTTPHEADER, array('HMAC: '.$hmac));
	    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
	    
	    // Execute the call and close cURL handle     
	    $data = curl_exec($ch);                
	    // Parse and return data if successful.
	    if ($data !== FALSE) {
	        if (PHP_INT_SIZE < 8 && version_compare(PHP_VERSION, '5.4.0') >= 0) {
	            // We are on 32-bit PHP, so use the bigint as string option. If you are using any API calls with Satoshis it is highly NOT recommended to use 32-bit PHP
	            $dec = json_decode($data, TRUE, 512, JSON_BIGINT_AS_STRING);
	        } else {
	            $dec = json_decode($data, TRUE);
	        }
	        if ($dec !== NULL && count($dec)) {
	            return $dec;
	        } else {
	            // If you are using PHP 5.5.0 or higher you can use json_last_error_msg() for a better error message
	            return array('error' => 'Unable to parse JSON result ('.json_last_error().')');
	        }
	    } else {
	        return array('error' => 'cURL error: '.curl_error($ch));
	    }
	}




}

?>