<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Excel;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Exports\RechargeRepo;
use DB;
use Storage;

class recharge_repo extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'appworks:rechargerepo';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'get recharge repo and send email';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        
      $filename = date("dmY").'_Recharge_Report.xlsx';
      Excel::store(new RechargeRepo, $filename); 
      $file = storage_path($filename);

						$template_type = 1;
						$smsdata = array(
							'msg_title' => 'backup_data',
							'name' => 'Backup Recharge Report Data',
							'useremail' => 'durgeshvrm010@gmail.com',
							'link' => config('WEBSITE_NAME').Storage::url('app/'.$filename),
							'template_name' => 'email',
							'WEBSITE_NAME' => config('WEBSITE_NAME'),
							'SITE_NAME' => config('SITE_NAME'),
							'SITE_LOGO' => config('SITE_LOGO')
						);
						$msg_config = DB::select('select * from config_msg where MSG_TITLE = "'.$smsdata['msg_title'].'"');
						$smsdata['MSG_CONTENT'] = $msg_config[0]->MSG_CONTENT;
						$smsdata['MSG_SUBJECT'] = $msg_config[0]->MSG_SUB;
						$smsdata['USER_TYPE'] = 1;
						$smsdata['USER_ID'] = 1;
						$smsdata['MSG_CONTENT'] = strtr($smsdata['MSG_CONTENT'], array('{name}' => $smsdata['name'],
						'{useremail}'=>$smsdata['useremail'],'{link}'=>$smsdata['link'],'{WEBSITE_NAME}'=>$smsdata['WEBSITE_NAME'],'{SITE_LOGO}'=>$smsdata['SITE_LOGO'],'{SITE_NAME}'=>$smsdata['SITE_NAME']));
						$smsdata['pdf'] =$filename;
						$template_data = $smsdata;
						Mail::to(config('BACKUP_DATA_EMAIL_ID'))->send(new SendMail($template_data, $template_type));
    }
}